/*  $Id: v_tile.pl,v 1.1 1993/06/15 12:44:36 jan Exp $

    Part of XPCE
    Designed and implemented by Anjo Anjewierden and Jan Wielemaker
    E-mail: jan@swi.psy.uva.nl

    Copyright (C) 1993 University of Amsterdam. All rights reserved.
*/

:- module(pce_tile_hierarchy, []).

:- pce_begin_class(tile_hierarchy, frame).

initialise(F, Tile:tile) :->
	"Display hierarchy of tile"::
	send(F, send_super, initialise, 'Tile Hierarchy'),
	send(F, append, new(P, picture)),
	send(new(D, dialog), below, P),
	fill_dialog(D),
	send(F, display_tile, Tile),
	send(F, open).


fill_dialog(D) :-
	get(D, frame, Frame),
	send(D, append, button(quit, message(Frame, destroy))).


display_tile(F, Tile:tile) :->
	"Display hierarchy below tile"::
	get(F, member, picture, P),
	send(P, clear),
	send(P, display, tree(new(R, tile_node(Tile)))),
	send(R, expand).

:- pce_end_class.

:- pce_begin_class(tile_node, node).

initialise(N, Tile:tile) :->
	"Create node for tile"::
	(   get(Tile, object, Obj),
	    Obj \== @nil
	->  get(Obj, name, Label)
	;   get(Tile, orientation, Label)
	),

	new(S, string('%s %dx%d\n-%dx+%d -%dy+%d',
		      Label,
		      Tile?ideal_width, Tile?ideal_height,
		      Tile?hor_shrink, Tile?hor_stretch,
		      Tile?ver_shrink, Tile?ver_stretch)),

	new(_, hyper(N, Tile, tile)),

	send(N, send_super, initialise, text(S, center)).

expand(N) :->
	"Expand tile sub-tree"::
	get(N, hypered, tile, Tile),
	(   get(Tile, members, SubTiles),
	    SubTiles \== @nil
	->  send(Tile?members, for_all,
		 and(assign(new(SubNode, var), ?(N?class, instance, @arg1)),
		     message(N, son, SubNode),
		     message(SubNode, expand)))
	;   true
	).

:- pce_end_class.
