%-----------------------------------------------------------------------%
%									%
%			       Ytoolkit					%
%									%
%					April 90 Ze' Paulo Leal		%
%									%
%-----------------------------------------------------------------------%
%									%
%	File: 		tools.yap					%
%	Version:	2.0						%
%	Purpose:	utils used in other Ytoolkit modules		%
%									%
%-----------------------------------------------------------------------%
%									%
%	Last change:	90/12/12					%
%	Bugs & Com.:							%
%									%
%-----------------------------------------------------------------------%


/* 	available utils

	deref_attr/3,
	eval_attr/3,
	member/2,
	append/3,
	try/1,
	set_depend/2
*/


working_widget(W) :-    current_window(W,[]), !, working_envir(W,W).


% ---- evaluate expressions envolving attr -------------
%							|
%							|

:- op(200,xfy,~).	% W~A meens attr A of widget W

/* usual cases (Edipo primitives) */

eval(V,_,_,_) :- var(V), !, fail.
eval(N,N,L,L) :- number(N), !.
eval(W~A,V,D,[W|D]) :- !,
	(nonvar(W),nonvar(A) -> 
	    get_window_attr(W,A,V)
	; 
	    format('[[ytoolkit: invalide constraint ~w]]~n',W~A), abort
	).
eval(A,V,R,[W|R]) :- atom(A), !,
	(edipo_attr(window,A) ->
	    working_widget(W), 
	    get_window_attr(W,A,V)
	;
	    format('[[ytoolkit: invalide constraint ~w]]~n',A), abort	    
	).
eval(A+B,AB, D,L) :- eval(A,VA,D,LA), eval(B,VB,LA,L), AB is VA+VB.
eval(A*B,AB, D,L) :- eval(A,VA,D,LA), eval(B,VB,LA,L), AB is VA*VB.
eval(A-B,AB, D,L) :- eval(A,VA,D,LA), eval(B,VB,LA,L), AB is VA-VB.
eval(A/B,AB, D,L) :- eval(A,VA,D,LA), eval(B,VB,LA,L), AB is VA/VB.
eval(A<<B,AB, D,L) :- eval(A,VA,D,LA), eval(B,VB,LA,L), AB is VA<<VB.
eval(A>>B,AB, D,L) :- eval(A,VA,D,LA), eval(B,VB,LA,L), AB is VA>>VB.

eval_poly([],[],L,L).
eval_poly([(X,Y)|R],[(CX,CY)|NR],D,L) :-
	eval(X,NX,D,D1),	yt_coord(NX,CX),
	eval(Y,NY,D1,D2),	yt_coord(NY,CY),
	eval_poly(R,NR,D2,L).
	

deref_attr(_M:line(X1,Y1,X2,Y2),edipo:line(CX1,CY1,CX2,CY2),L) :- !,
	eval(X1,NX1,[],L1),	yt_coord(NX1,CX1),
	eval(Y1,NY1,L1,L2),	yt_coord(NY1,CY1),
	eval(X2,NX2,L2,L3),	yt_coord(NX2,CX2),
	eval(Y2,NY2,L3,L) ,	yt_coord(NY2,CY2).
deref_attr(_M:rectangle(X,Y,W,H),edipo:rectangle(CX,CY,CW,CH),L) :- !,
	eval(X,NX,[],L1),	yt_coord(NX,CX),
	eval(Y,NY,L1,L2),	yt_coord(NY,CY),
	eval(W,NW,L2,L3),	yt_coord(NW,CW),
	eval(H,NH,L3,L) ,	yt_coord(NH,CH).
deref_attr(_M:frectangle(X,Y,W,H),edipo:frectangle(NX,NY,NW,NH),L) :- !,
	deref_attr(_M:rectangle(X,Y,W,H),edipo:rectangle(NX,NY,NW,NH),L).
deref_attr(_M:crectangle(X,Y,W,H),edipo:crectangle(NX,NY,NW,NH),L) :- !,
	deref_attr(_M:rectangle(X,Y,W,H),edipo:rectangle(NX,NY,NW,NH),L).
deref_attr(_M:writeterm(X,Y,S),edipo:writeterm(CX,CY,S),L) :- !,
	eval(X,NX,[],L1),	yt_coord(NX,CX),
	eval(Y,NY,L1,L),	yt_coord(NY,CY).
deref_attr(_M:writestring(X,Y,S),edipo:writestring(CX,CY,S),L) :- !,
	eval(X,NX,[],L1),	yt_coord(NX,CX),
	eval(Y,NY,L1,L),	yt_coord(NY,CY).
deref_attr(_M:arc(X,Y,W,H,A,B),edipo:arc(CX,CY,CW,CH,CA,CB),L) :- !,
	eval(X,NX,[],L1),	yt_coord(NX,CX),
	eval(Y,NY,L1,L2),	yt_coord(NY,CY),
	eval(W,NW,L2,L3),	yt_coord(NW,CW),
	eval(H,NH,L3,L4),	yt_coord(NH,CH),
	eval(A,NA,L4,L5),	yt_coord(NA,CA),
	eval(B,NB,L5,L),	yt_coord(NB,CB).
deref_attr(_M:farc(X,Y,W,H,A,B),edipo:farc(NX,NY,NW,NH,NA,NB),L) :- !,
	deref_attr(_M:arc(X,Y,W,H,A,B),edipo:arc(NX,NY,NW,NH,NA,NB),L).
deref_attr(_M:circle(X,Y,R),edipo:circle(CX,CY,CR),L) :- !,
	eval(X,NX,[],L1),	yt_coord(NX,CX),
	eval(Y,NY,L1,L2),	yt_coord(NY,CY),
	eval(R,NR,L2,L),	yt_coord(NR,CR).
deref_attr(_M:fcircle(X,Y,R),edipo:fcircle(CX,CY,CR),L) :- !,
	eval(X,NX,[],L1),	yt_coord(NX,CX),
	eval(Y,NY,L1,L2),	yt_coord(NY,CY),
	eval(R,NR,L2,L),	yt_coord(NR,CR).
deref_attr(_M:poly(P),edipo:poly(NP),L) :- !,
	eval_poly(P,NP,[],L).
deref_attr(_M:fpoly(P),edipo:fpoly(NP),L) :- !,
	eval_poly(P,NP,[],L).


/* general cases (old) */

deref_attr(M:T,M:NT,L) :- !, deref_attr(T,NT,L).
deref_attr(using(L,G),G,LD) :- !,
	'$calc'(L,_,LD,[]).
deref_attr(writestring(X,Y,S),writestring(NX,NY,S),L) :- !,
	'$calc'([X,Y],[NX,NY],L,[]).
deref_attr(writeterm(X,Y,S),writeterm(NX,NY,S),L) :- !,
	'$calc'([X,Y],[NX,NY],L,[]).
deref_attr(T,NT,L) :-
	T=..[F|A],
	'$calc'(A,CA,L,[]),
	NT=..[F|CA].


eval_attr([H|T],[H|T],[]) :- !.
eval_attr(E,EV,L) :-
	'$valueof'(E,NA,Type,L,[]),
	'$value'(Type,NA,EV).

'$calc'([],[],L,L).
'$calc'([A|R],[VA|NR],L,D) :-
	'$valueof'(A,NA,Type,LD,D),
	'$value'(Type,NA,VA),
	'$calc'(R,NR,L,LD).

'$value'(number,NA,VA) :- !, VA is NA.
'$value'(no_number,NA,NA).

'$valueof'(T,T,no_number,L,L) :- var(T), !.
'$valueof'(T,T,_,L,L) :- number(T), !.
'$valueof'(X is E,X,no_number,LD,R) :- !, 
	'$valueof'(E,Y,Type,LD,R),
	'$value'(Type,Y,X).
'$valueof'(W~A,V,N,[W|R],R) :- !, 
	(nonvar(W),nonvar(A) -> 
	    get_window_attr(W,A,V), type(V,N); 
	    format('[[ytoolkit: invalide constraint ~w]]~n',W~A), abort
	).
'$valueof'(M:G,M:VG,no_number,L,D) :- !, '$valueof'(G,VG,no_number,L,D).
'$valueof'([],[],no_number,L,L) :- !.
'$valueof'([H|T],[NH|TV],no_number,L,D) :- !,
	'$valueof'(H,NH,_,LD,D),
	'$valueof'(T,TV,_,L,LD).
'$valueof'((H,T),(HV,TV),no_number,L,D) :- !,
	'$valueof'(H,NH,Type1,LD,D),			'$value'(Type1,NH,HV),
	'$valueof'(T,NT,Type2,L,LD),			'$value'(Type2,NT,TV).
'$valueof'(A,V,N,[W|R],R) :- 	atom(A), 
				edipo_attr(window,A), 
				current_window(W,[]), !,
	get_window_attr(W,A,V), 
	type(V,N).
'$valueof'(T,T,no_number,L,L) :- atom(T),!.
'$valueof'(T,V,Type,L,D) :- 
	T=..[F|A],
	'$valueof_l'(A,VA,AType,L,D),
	V=..[F|VA],
	'$f_type'(F,AType,Type).

'$f_type'(F,AType,Type) :- 
	(('$e_type'(F), var(AType)) -> otherwise ; Type=no_number).

'$e_type'(+).
'$e_type'(-).
'$e_type'(*).
'$e_type'(/).
'$e_type'(^).
'$e_type'(>>).
'$e_type'(<<).

'$valueof_l'([],[],_,L,L).
'$valueof_l'([H|T],[NH|NT],Type,L,D) :- 
	'$valueof'(H,NH,Type,Ld,D),
	'$valueof_l'(T,NT,Type,L,Ld).

type(VA,_) :- number(VA), !.
type(_,no_number).
%							|
%							|
%-------------------------------------------------------




% ---- good old member ---------------------------------
%							|
%							|
member(X,[X|_]).
member(X,[_|R]) :- member(X,R).

%							|
%							|
%-------------------------------------------------------

	


% ---- good old append ---------------------------------
%							|
%							|
% <append is built-in in Quintus>
%							|
%							|
%-------------------------------------------------------



% ---- execute once if defined -------------------------
%							|
%							|
set_depend([],_).
set_depend([X|R],D) :- member(X,R), !,
	set_depend(R,D).
set_depend([X|R],D) :- 
	recorda(X,D,_),
	set_depend(R,D).
%							|
%							|
%-------------------------------------------------------
