
:- module(showtext,[]).

:- ensure_loaded(library(edipo)).
:- ensure_loaded(library(ytoolkit)).

:- ytoolkit:super_class(showtext:scrollwindow).

default(lines,0).	% this is, in fact, an initialization
%default(line(1),'').	% and this is just an example 
default(line_font,F) :- current_font([
'-*-lucidatypewriter-medium-*-normal-*-12-*-*-*-*-*-*-*',
'*helvetica*--10-*',
'*-10-*','*'],F).

sub_widgets(W) :-	make_lines(W).

make_lines(Name) :-
	current_widget(_,[line_font=F,back=B,height=FH],Name),
	window(B,[]),gc(B,[font=F]),
	(get_attr(Name,line(_N),T),
		get_attr(Name,lines,NL),
		writebox(T,_WW,IH), 
/*
	 	IW is IWW+1,
	        new_widget(_,[
			parent=B,
			x=10,y=NL*IH,
			height=IH, width=IW,
			font=F
    	       ],W),
	       draw(W,writeterm(0,IH,T)),
	       set_attr(Name,win_of(N),W),
 */
	   draw(B,writeterm(10,NL*IH,T)),
	       ML is NL+1,	
	       set_attr(Name,lines,ML),
	fail;window(B,[y=0])),
	writebox(1,_,IH),
	change_back(Name,B,IH,FH).

change_back(Name,B,IH,FH) :-
        get_attr(Name,lines,FL),
	NH is FL*IH, NH>0,
	(FH >= NH -> 
	    change_widget(_,[height=NH],B)
	;
	    NY is FH-NH,
	    change_widget(_,[height=NH,y=NY],B)
	).


change_attr(line(N),Name,T) :- 
	current_widget(_,[line_font=F,back=B,height=FH],Name),
	gc(Name,[font=F]),
	change_attr(N,Name,T,F,B,FH).

change_attr(N,Name,T,F,B,FH) :-
	get_attr(Name,lines,NL),	
	writebox(T,IWW,IH), IW is IWW+1,
	(get_attr(Name,win_of(N),W) ->
	    clear_widget(W),
	    change_widget(_,[width=IW],W)
	;
	    current_widget(_,[height=H],B),
	    new_widget(_,[
		parent=B,
		x=10,y=H,
		height=IH, width=IW,
		font=F
	    ],W),
	    ML is NL+1,	
	    set_attr(Name,lines,ML),
	    set_attr(Name,win_of(N),W),
	    NH is H+IH,	change_widget(_,[height=NH],B),
	    (FH >= NH -> 
		otherwise; 
		NY is FH-NH,
		change_widget(_,[y=NY],B)
	    )
	),
	draw(W,writeterm(0,IH,T)).
change_attr(line_font,Name,F) :- 
	gc(Name,[font=F]),
	(get_attr(Name,win_of(N),W),
		unset_attr(Name,win_of(N)),
		kill_widget(_,[],W),
		fail
	    ;
	    set_attr(Name,lines,0)
	),
	make_lines(Name).
