
:- module(scrollback,[]).

:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library(edipo)).

behavior(createNotify,Name) :- 
	current_window(Name,[x=X,y=Y,width=W,height=H]),
	behavior(configureNotify(X,Y,W,H,_),Name).
behavior(configureNotify(X,_,W,_,_),Name) :-
	get_attr(Name,sbx,SB),
	get_attr(Name,front,F),
	get_window_attr(SB,width,SB_W),
	get_window_attr(F,width,F_W),
	Pos is integer(-X/W*SB_W),
	Part is F_W/W,
	(Part<1 -> 
		set_attr(SB,pos,Pos),
		set_attr(SB,part,Part),
		send_event(expose(0),SB)
	;
		current_window(Name,[]), window(Name,[x= -1]),
		unset_attr(SB,pos),
		unset_attr(SB,part),
		window(SB,[]), clear
	).
behavior(configureNotify(_,Y,_,H,_),Name) :-
	get_attr(Name,sby,SB),
	get_attr(Name,front,F),
	get_window_attr(SB,height,SB_H),
	get_window_attr(F,height,F_H),
	Pos is integer(-Y/H*SB_H),
	Part is F_H/H,  
	(Part<1 -> 
		set_attr(SB,pos,Pos),
		set_attr(SB,part,Part),
		send_event(expose(0),SB)
	;
		current_window(Name,[]), window(Name,[y= -1]),
		unset_attr(SB,pos),
		unset_attr(SB,part),
		window(SB,[]), clear
	).

