%-----------------------------------------------------------------------%
%									%
%			       Ytoolkit					%
%									%
%					April 90 Ze' Paulo Leal		%
%									%
%-----------------------------------------------------------------------%
%									%
%	File: 		tools.yap					%
%	Version:	2.0						%
%	Purpose:	several general Ytoolkits tools			%
%									%
%-----------------------------------------------------------------------%
%									%
%	Last change:	93/05/19					%
%	Bugs & Com.:							%
%									%
%-----------------------------------------------------------------------%


/* information about widgets ---------------------------------------


set_attr(?Name,?Attr,?Value).	Sets the atribute Attr to the value Value
				in the environement of Name. Any previous
				value of Attr is discarded.

get_attr(?Name,?Attr,?Value).	Unifies Values with the current value for
				the atribute Attr. If no value is recorded
				the predicate fails

*/


set_attr(Name,Attr,_) :- 
	recorded(Name,'$attr'(Attr,_),Ref),
	erase(Ref),
	fail.
% set_attr(Name,Attr,eval(E)) :- !,
%	eval_attr(Expr,Value,D), set_depend(D,Name,Attr,E,Value),
%	recorda(Name,$attr(Attr,Value),_).
%
set_attr(Name,Attr,Value) :-
	recorda(Name,'$attr'(Attr,Value),_).

unset_attr(Name,Attr) :- 
	recorded(Name,'$attr'(Attr,_),Ref),
	erase(Ref),
	fail.
unset_attr(_,_).

get_attr(Name,Attr,Value) :- 
	recorded(Name,'$attr'(Attr,Value),_).
%get_attr(Name,Attr,Value) :- dipo_attr(Type,Attr), !,
%	get_x_attr(Type,Name,Attr,Value).

get_x_attr(window,Name,Attr,Value) :- current_window(Name,[Attr=Value]).

call_back(Name,Attr) :-
	recorded(Name,'$attr'(Attr,Call),_),
	recorded(Name,'$attr'(source,Source),_),
	call(Source:Call), !.
call_back(_,_).



set_attr(Attr,_) :- 
	working_widget(Name),
	recorded(Name,'$attr'(Attr,_),Ref),
	erase(Ref),
	fail.
set_attr(Attr,Value) :-
	working_widget(Name),
	recorda(Name,'$attr'(Attr,Value),_).


unset_attr(Attr) :- 
	working_widget(Name),
	recorded(Name,'$attr'(Attr,_),Ref),
	erase(Ref),
	fail.
unset_attr(_).


get_attr(Attr,Value) :- 
	working_widget(Name),
	recorded(Name,'$attr'(Attr,Value),_).

call_back(Attr) :-
	working_widget(Name),
	recorded(Name,'$attr'(Attr,Call),_),
	recorded(Name,'$attr'(source,Source),_),
	call(Source:Call), !.
call_back(_).




/* --- widget cache -----------------------------------------------------------

init_cache(N)			initialize the widget cache with n elements

dispose_widget(Class,Parent,Name)

recicle_widget(Class,Parent,Name)

-----------------------------------------------------------------------------*/


% ---- init_cache --------------------------------------
%							|
%							|
init_cache(N) :- 
	set_value('$$cache',0),
	set_value('$$max_cache',N),
	(recorded('$cache',_,R),
		erase(R),
	fail;true).

re_init_cache(N) :-
	get_value('$$cache',[]),!,
	init_cache(N).
re_init_cache(_).
%							|
%							|
%-------------------------------------------------------


% ---- dispose_widget ----------------------------------
%							|
%							|
dispose_widget(Class,Parent,Name) :-
	recorded(Name,'$object'(Class,Parent),Ref),erase(Ref),
	recordz('$cache',widget(Class,Parent,Name),_),
	working_window(Name), unmap,
	get_value('$$cache',V),
	(get_value('$$max_cache',V) ->
		recorded('$cache',widget(C,P,N),First), !, erase(First),
		(current_window(N,[]) -> 
			recorda(N,'$object'(C,P),_), kill_widget(C,P,N)
		;
			true
		)
	;
		U is V+1, set_value('$$cache',U)
	).
%							|
%							|
%-------------------------------------------------------


% ---- recicle_widget  ---------------------------------
%							|
%							|
recicle_widget(Class,Parent,Name) :-
	recorded('$cache',widget(Class,Parent,Name),Ref),
	erase(Ref),
	current_window(Name,[]), !,
	recorda(Name,'$object'(Class,Parent),_),
	get_value('$$cache',V), U is V-1, set_value('$$cache',U),
	working_window(Name), map.
recicle_widget(Class,Parent,Name) :-
	new_widget(Class,Parent,Name).
%							|
%							|
%-------------------------------------------------------



% ---- show_cache  -------------------------------------
%							|
%							|
show_cache :-
	nl, nl,
	get_value('$$cache',V), write(cache=V), nl,
	get_value('$$max_cache',M), write(max_cache=M), nl, nl,

	recorded('$cache',widget(_,_,N),_),
		write(N), nl,
	fail.
show_cache :-
	write('press any key to continue'),
	get0(_).
%							|
%							|
%-------------------------------------------------------




/* --- error and debugging ----------------------------------------------------

predicates:				

widget_tree.				shows all current widgets

all_info.

defined_widget(Name/Arity).		widgets defined with define_widget/3

undefine_widget(Name/Arity).		undefine a widget defined with "

*/

% ---- widget_tree --------------------------------------
%							|
%
widget_tree :-
	nl, nl,
	'$widget_tree'(root,background,0).

'$widget_tree'(Window,Class,Level) :-
	tab(Level), write('---- '), write(Class), nl, 
	tab(Level), write('     |'), write(Window), nl,
	current_widget(SonClass,Window,Name),
	Next is Level + 5,
	'$widget_tree'(Name,SonClass,Next),
	fail.
'$widget_tree'(_,_,Level) :-
	tab(Level), write('_____|'), nl.
%							|
%							|
%-------------------------------------------------------



all_info :-
	current_key(K,_),
	nl,nl,nl,write(K),nl,nl,
		recorded(K,A,_),
		write(A),nl,
	fail.
all_info.





% ----      --------------------------------------------
%							|
%							|

%							|
%							|
%-------------------------------------------------------



%
%
%	Layout construction tools
%
%

/* --- global information about widgets ---------------------------------------


set_attr(?Name,?Attr,?Value).	Sets the atribute Attr to the value Value
				in the environement of Name. Any previous
				value of Attr is discarded.

get_attr(?Name,?Attr,?Value).	Unifies Values with the current value for
				the atribute Attr. If no value is recorded
				the predicate fails

unset(?Name,?Attr)		erases the Attr and recovers the memory
				used by it.
*/

/* --- Drawing and Text utilities ---------------------------------------------




draw(T).		Uses the drawing predicate T in the current widget
			The arguments of the predicate may involve aritmetic
			expressions and atoms of the window attributes
				ex. draw(line(width/2,0,with,height)).

clear_widget.

undraw(T).

text_write(T).

text_nl.

-----------------------------------------------------------------------------*/

gen_object_name(Name) :-
	(recorded('$free',Name,Ref) ->
		erase(Ref)
	;
		(get_attr('$$name','$$name',B) -> Name is B+1; Name=0),
		set_attr('$$name','$$name',Name)
	).



% ---- draw undraw   ---------------------------------------
%							|
%							|

redraw :- working_widget(Window), redraw(Window).

redraw(Window) :-
%	current_window(Window,[width=W,height=H]),
	get_window_attr(Window,width,W), 
	get_window_attr(Window,height,H), 
	working_window(Window),
	recorded(Window,'$object'(Class),_),
	crectangle(0,0,W,H),
	try(ytoolkit:'$process'(expose(0),Window,Class)).

clear_widget :-
	working_widget(Name),	
	clear_widget(Name).	


clear_widget(Name) :-
	recorded(Name,'$draw'(_),Ref),
		erase(Ref),
	fail.
clear_widget(Name) :-
	recorded(Name,'$draw'(_,_),Ref),
		erase(Ref),
	fail.

clear_widget(Name) :-
	recorded(Name,'$layout_depend'(_,_),Ref),
		erase(Ref),
	fail.

clear_widget(Name) :-
	recorded(Name,'$draw_object'(_,_,_),Ref),
		erase(Ref),
	fail.

clear_widget(Name) :- 
	working_window(Name),
	get_window_attr(Name,width,W), 
	get_window_attr(Name,height,H), 
	crectangle(0,0,W,H).

'$draw'(T) :-
	working_widget(Name),		
	deref_attr(T,NT,L),			% utils
	recorda(Name,'$draw'(NT),R),
	gen_object_name(ON),
	recorda(Name,'$draw_object'(ON,R),_),
	set_depend(L,'$layout_depend'(Name,T,ON)),
	call(NT).

'$draw'(W,T) :-
	deref_attr(T,NT,L),			% utils
	recorda(W,'$draw'(NT),R),
	gen_object_name(ON),
	recorda(W,'$draw_object'(ON,R),_),
	set_depend(L,'$layout_depend'(W,T,ON)),
	working_window(W), call(NT).

'$draw'(W,GC,T) :-
	deref_attr(T,NT,L),			% utils
	recorda(W,'$draw'(GC,NT),R),
	gen_object_name(ON),
	recorda(W,'$draw_object'(ON,R),_),
	set_depend(L,'$layout_depend'(W,T,ON)),
	working_envir(W,GC), call(NT).


'$undraw'(T) :- 	
	working_widget(Name),		
%	deref_attr(T,NT,_L),			% utils
	(recorded(Name,'$draw'(T),Ref),
		recorded(Name,'$draw_object'(_ON,Ref),R),
		erase(R),
		erase(Ref), fail
	; true).

'$undraw'(W,T) :- 
%	deref_attr(T,NT,_L),			% utils	
	(recorded(W,'$draw'(T),Ref),
		recorded(W,'$draw_object'(_ON,Ref),R),
		erase(R),
		erase(Ref), fail
	; true).


'$undraw'(W,GC,T) :- 
%	deref_attr(T,NT,_L),			% utils	
	(recorded(W,'$draw'(GC,T),Ref), 
		recorded(W,'$draw_object'(_ON,Ref),R),
		erase(R),
		erase(Ref), fail
	; true).

	
drawn(W,T) :- recorded(W,'$draw'(T),_Ref).

drawn(W,W,T) :- recorded(W,'$draw'(T),_Ref).
drawn(W,GC,T) :- recorded(W,'$draw'(GC,T),_Ref).
%							|
%							|
%-------------------------------------------------------


% ----  --------------------------------------------
%							|
%							|
%							|
%							|
%-------------------------------------------------------




% ---- text_write  -------------------------------------
%							|
%							|
/* text_write(T) :-
	get_attr(col,C),
	get_attr(line,L), */
%							|
%							|
%-------------------------------------------------------


% ----  --------------------------------------------
%							|
%							|
current_font([P|_],F) :- current_font(P,F), !.
current_font([_|R],F) :- current_font(R,F), !. 
current_font(P,F) :- atom(P),
	(recorded('$fonts','$fonts'(P,F),_) ->
		otherwise
	;
		font_list(P,F),
		recorda('$fonts','$fonts'(P,F),_)
	), !.
		
%							|
%							|
%-------------------------------------------------------


