%-----------------------------------------------------------------------%
%									%
%			       Ytoolkit					%
%									%
%					April 90 Ze' Paulo Leal		%
%									%
%-----------------------------------------------------------------------%
%									%
%	File: 		dispatch.yap					%
%	Version:	2.0						%
%	Purpose:	event dispatcher and  event processing preds.	%
%									%
%-----------------------------------------------------------------------%
%									%
%	Last change:	91/01/06					%
%	Bugs & Com.:							%
%									%
%-----------------------------------------------------------------------%




/*-----------------------  Main Execution Loop ---------------------------

predicates:		
	loop			starts the loop execution
	exit_loop		stops the loop execution when there is no 
				more events in the quee.
	fast_exit_loop		stops the loop execution emidiatelly


-------------------------------------------------------------------------*/


% ---- loop, inner_loop ---------------------------------
%							|
%							|



loop :- 
	clear_exit,
	dont_flush, 
	inner_loop,
	do_flush, flush.

clear_exit :- recorded('$exit_loop','$exit_loop',Ref), erase(Ref), fail.
clear_exit.

inner_loop :-
	repeat,
	event(Window,Event),					% Edipo
		recorded(Window,'$object'(Class),_),
		working_envir(Window),				% Edipo
		'$process'(Event,Window,Class),
	recorded('$exit_loop','$exit_loop',R), !,
	erase(R).


exit_loop :- 
format('~n[[ytoolkit: "?- ytoolkit:loop." to resume interaction ]]~n~n',[]),
	exit_inner_loop.

exit_inner_loop :- 
	recorda('$exit_loop','$exit_loop',_).

%							|
%							|
%-------------------------------------------------------



/* --- Event handling -------------------------------------------------------*/

%'$process'(E,W,_) :- write(W+E), nl, fail.
%'$process'(_E,_W,_) :- write('Press "a" to abort, RET to continue'), get0(97), fail.

'$process'(expose(0),Window,_) :-
	recorded(Window,'$draw'(D),_),
	call(D),
	fail; true.
'$process'(expose(0),Window,_) :-
	recorded(Window,'$draw'(GC,D),_),
	working_gc(GC),
	call(D),
	fail; working_gc(Window).

'$process'(configureNotify(_,_,_,_,_),Window,_Class) :-
	bagof((A=NV),dependent_attr(Window,W,A,NV),L),
	window(W,L).
'$process'(configureNotify(_,_,_,_,_),Window,_Class) :-
	recorded(Window,'$attr_depend'(other,A,E,V,W),R),
	\+ edipo_attr(_,A),
	eval_attr(E,NV,_), 
	NV \== V,
	erase(R),
	recorda(Window,'$attr_depend'(other,A,E,NV,W),_),
	set_attr(W,A,NV),
	send_event(configureNotify(_,_,_,_,_),W).
'$process'(configureNotify(_,_,_,_,_),Window,_Class) :-
	collect_dependent(Window,List),
	redraw_dependent(List,Window).

'$process'(keyPress(A,B,C,D),_,_) :- recorded('$focus',Window,_), !,
		recorded(Window,'$object'(Class),_),
		working_envir(Window),				% Edipo
		call(Class:behavior(keyPress(A,B,C,D),Window)).	
'$process'(keyRelease(A,B,C,D),_,_) :- recorded('$focus',Window,_), !,
		recorded(Window,'$object'(Class),_),
		working_envir(Window),				% Edipo
		call(Class:behavior(keyRelease(A,B,C,D),Window)).	

'$process'(Event,Window,Class) :- call(Class:behavior(Event,Window)).

focus(W) :- recorded('$focus',W,_), !.
focus(_) :- 
	recorded('$focus',W,R),
	send_event(leaveNotify,W),
	erase(R), 
	fail.
focus(W) :- 
	recorda('$focus',W,_),
	send_event(enterNotify,W).


current_focus(W) :- 	recorded('$focus',W,_).

defocus :- recorded('$focus',_,R), erase(R).

dependent_attr(Window,W,A,NV) :-
	recorded(Window,'$attr_depend'(window,A,E,V,W),R),
	(current_window(W,[]) -> working_window(W) ; erase(R)),
	eval_attr(E,WV,_), yt_coord(WV,NV),
	NV \== V,
	erase(R),
	recorda(Window,'$attr_depend'(window,A,E,NV,W),_).

collect_dependent(Window,List) :-
	findall(W+L,
		bagof(T+ON,R^Ref^(
			recorded(Window,'$layout_depend'(W,T,ON),_),
			recorded(W,'$draw_object'(ON,R),Ref),
			erase(R), erase(Ref),
			current_window(W,[]))
		,L),
		List).


redraw_dependent([],_).
redraw_dependent([W+L|R],Window) :-
	redraw_dependent(R,Window),
	working_envir(W),
	draw_list(L,Window,W),
	clear, 
	(recorded(W,'$draw'(D),_),call(D),fail;true).

draw_list([],_,_).
draw_list([T+ON|C],Window,W) :-
	deref_attr(T,NT,_),	!,		% utils
	recorda(W,'$draw'(NT),R),
	recorda(W,'$draw_object'(ON,R),_),
	draw_list(C,Window,W).




/* --- Event handling ---------------------------------------------------------



*/


% ---- yt_event  ----------------------------------------
%							|
%							|
yt_event(W,E) :-
	events(W,E), 
		recordz('$$events',event(W,E),_),
	fail.
yt_event(W,E) :- recorded('$$events',event(W,E),R), !, erase(R).
yt_event(W,E) :- event(W,E).
%							|
%							|
%-------------------------------------------------------


% ---- refresh  ----------------------------------------
%							|
%							|
refresh(Parent) :-
%	current_window(Parent,[cursor=C]),
%	window(parent,[cursor=150]),
	(current_widget(Class,Parent,Name),
	working_envir(Name),
	recorded(Class,'$process'(Pred,expose(0),Name),_),
	call(Pred),
	fail;true).
%	window(Parent,[cursor=C]).
%							|
%							|
%-------------------------------------------------------



% ----  send_event  ------------------------------------
%							|
%
/*
send_event(Event,Window) :-
	recordz('$$events',event(Window,Event),_).
*/

send_event(Event,Window) :-
		recorded(Window,'$object'(Class),_),
		working_widget(CWW),
		working_envir(Window),				% Edipo
		('$process'(Event,Window,Class), fail; true), !,
		(recorded(CWW,'$object'(Class),_) ->
			working_envir(CWW)		 	% Edipo
		;
			otherwise
		).			
%							|
%							|
%-------------------------------------------------------



% ---- event_flush  ------------------------------------
%							|
%
event_flush :- 
	events(_,_), 						% Edipo	
	fail.
event_flush.

user_event_flush :- 
	events(W,E), 						% Edipo	
	\+ user_event(E),	
	send_event(E,W),
	fail.
user_event_flush.

user_event(buttonPress(_,_,_)).
user_event(buttonRelease(_,_,_)).
user_event(keyPress(_,_,_,_)).
user_event(keyRelease(_,_,_,_)).
user_event(motionNotify(_,_)).
%							|
%							|
%-------------------------------------------------------


% ---- wait_for ----------------------------------------
%							|
%							|
wait_for(Window,Event) :-
	repeat,
	event(W,E),
	'$wait_for'(Window,Event,W,E), !.	

'$wait_for'(W,E,W,E) :- !.
/*
'$wait_for'(_,_,Window,Event) :-
	recorded(Window,'$object'(Class),_),
	send_event(Event,Window).
*/
%							|
%							|
%-------------------------------------------------------
