%-----------------------------------------------------------------------%
%									%
%			Edipo - sicstus/quintus version			%
%									%
%						August 90		%
%						Ze' Paulo Leal		%
%						Universidade do Porto	%
%									%
%-----------------------------------------------------------------------%
%									%
%	file :		text.pl						%
%	purpose : 	edipo text primitives				%
%	creation	90/08/03					%
%	last changes :	90/09/03					%
%	bugs :		font_list backtrak is not soundly implemented	%
%	comments :	stream interface is really needed		%
%									%
%-----------------------------------------------------------------------%


/* Fonts  */


font_list(Pattern,Font) :-
	edipo_on,
	recorded('$display','$display'(_,Display),_), !,
	x_init_font_list(Display,Pattern),
	repeat,
	x_list_font(Font),
	(Font=[],!,fail;true).

writeterm(X,Y,T) :- 
	recorded('$window','$window'(_,Display,Window,GC),_), !,
	(atom(T) -> 
	    x_my_draw_atom(Display,Window,GC,X,Y,T)
	;
	    x_tmp(F),
	    tell(F),
	    write(T),
	    told,
	    x_my_draw_term(Display,Window,GC,X,Y,F)
	),
	if_flush(Display).		

writestring(X,Y,S) :- % this is not very efficient
	recorded('$window','$window'(_,Display,Window,GC),_), !,
	put_string(S),
	x_my_draw_string(Display,Window,GC,X,Y),
	if_flush(Display).		

put_string([]) :- x_end_string.
put_string([C|R]) :-
	x_next_char(C),
	put_string(R).

writebox(T,W,H) :- 
	recorded('$window','$window'(_,Display,_,GC),_), !,
	(atom(T) -> 
	    x_my_writebox(Display,GC,T,W,H)
	;
	    x_tmp(F),
	    tell(F),
	    write(T),
	    told,
	    x_my_termbox(Display,GC,F,W,H)
	).

stringbox(S,W,H) :-
	recorded('$window','$window'(_,Display,_,GC),_), !,
	name(A,S), % this is not very efficient
	x_my_writebox(Display,GC,A,W,H).


