/*----------------------------------------------------------------------*
*									*
*			Edipo - sicstus/quintus version			*
*									*
*						August 90		*
*						Ze' Paulo Leal		*
*						Universidade do Porto	*
*									*
*-----------------------------------------------------------------------*
*									*
*	file :		init.c						*
*	purpose : 	initialization function				*
*	creation	91/03/15					*
*	last changes :	91/03/15					*
*	bugs :								*
*	commennts :					 		*
*									*
*----------------------------------------------------------------------*/

#include "callx.h"
#include "event.h"

#include <sys/types.h>
#include <signal.h>

int edipo_on=FALSE;
int  edipo_screen;
Colormap  edipo_cmap;
unsigned long int nil_atom;


my_error_handler(message,flag)
     char *message;
       int flag;
{
  int pid,sig;

  fprintf(stderr,"[[edipo: %s ]]\n",message);
  switch(flag) {   
  case CONTINUE_AFTER_ERROR: return;
  case ABORT_AFTER_ERROR: sig=SIGINT; break;
  case EXIT_AFTER_ERROR: sig=SIGKILL; break;
  default: return;
  }
  pid=getpid();
  kill(pid,sig);
}


xerror(disp,err)
     Display *disp;
     XErrorEvent *err;
{
  char messg[STRSIZE], xerror[STRSIZE];
  
  XGetErrorText(disp,err->error_code,xerror,STRSIZE);
  strcpy(messg," X interface error: ");
  strcat(messg,xerror);
  ErrorHandler(messg,ABORT_AFTER_ERROR);
}


c_init_edipo(display)
     Display *display;
{
  
  if(edipo_on)
    return;
  edipo_on=TRUE;


  edipo_screen=DefaultScreen(display);
  edipo_cmap=DefaultColormap(display,edipo_screen);

  init_window_atoms();
  
  nil_atom = AtomFromString("[]");
  keyPress_atom = AtomFromString("keyPress");
  keyRelease_atom = AtomFromString("keyRelease");
  buttonPress_atom = AtomFromString("buttonPress");
  buttonRelease_atom = AtomFromString("buttonRelease");
  motionNotify_atom = AtomFromString("motionNotify");
  enterNotify_atom = AtomFromString("enterNotify");
  leaveNotify_atom = AtomFromString("leaveNotify");
  expose_atom = AtomFromString("expose");
  visibilityNotify_atom = AtomFromString("visibilityNotify");
  createNotify_atom = AtomFromString("createNotify");
  configureNotify_atom = AtomFromString("configureNotify");
  destroyNotify_atom = AtomFromString("destroyNotify");
  mapNotify_atom = AtomFromString("mapNotify");
  unmapNotify_atom = AtomFromString("unmapNotify");

  XSetErrorHandler(xerror);
}


#if SICSTUS
#ifdef OLD
# else
char *sp_string_from_atom(atom) 
     SP_term atom;
{
  char *str;
  SP_get_string(atom,&str);
  return str;
}

unsigned long int sp_atom_from_string(str)
     char *str;
{
  SP_term atom;
  SP_put_string(&atom,str);
  return (unsigned long) atom;
}
#endif
#endif
