%-----------------------------------------------------------------------%
%									%
%			Edipo - sicstus/quintus version			%
%									%
%						August 90		%
%						Ze' Paulo Leal		%
%						Universidade do Porto	%
%									%
%-----------------------------------------------------------------------%
%									%
%	file :		bitmaps.pl					%
%	purpose : 	bitmaps and pixmaps creation			%
%	creation	91/12/16					%
%	last changes :	91/12/16					%
%	bugs :								%
%	comments :	very incomplete					%
%									%
%-----------------------------------------------------------------------%


getimage(Name,from_file(File)) :-
	recorded('$window','$window'(_,DY,WD,GC),_), !,
%	'XReadBitmapFile'(DY,WD,File,_W,_H,PixMap,_X_Hot,_Y_Hot,Status),
	x_my_read_bitmap_data(File,Status),
	(Status=0 ->
	    true;
	    format('[[edipo: error reading bitmap file "~w" ]]~n',File), fail
	),
	x_my_create_pixmap_from_data(DY,WD,GC,PixMap),
	(recorded('$pixmap','$pixmap'(Name,_),Ref), erase(Ref), fail; true),
	recorda('$pixmap','$pixmap'(Name,PixMap),_).

getimage(Name,from_window(X,Y,W,H)) :-
	recorded('$window','$window'(WN,DY,WD,GC),_), !,
	Mask=16'ffff,
	Format=1,
	'XGetImage'(DY,WD,X,Y,W,H,Mask,Format,Image),
	(Image=0 ->
	    format('[[edipo: invalid bitmap from window "~w" ]]~n',WN), fail;
	    true
	),
	x_my_display_planes(DY,Depth),
	'XCreatePixmap'(DY,WD,W,H,Depth,PixMap),
	'XPutImage'(DY,PixMap,GC,Image,0,0,0,0,W,H),
	(recorded('$pixmap','$pixmap'(Name,_),Ref), erase(Ref), fail; true),
	recorda('$pixmap','$pixmap'(Name,PixMap),_).

putimage(Name,to_file(File,W,H)) :-
	recorded('$window','$window'(_,DY,_,_),_), !,
	recorded('$pixmap','$pixmap'(Name,PixMap),_),
	X_Hot = -1, 
	Y_Hot = -1,
	'XWriteBitmapFile'(DY,File,PixMap,W,H,X_Hot,Y_Hot,Status),
	(Status=0 ->
	    true;
	    format('[[edipo: error writting bitmap file "~w" ]]~n',File)
	).	
putimage(Name,to_window(BMX,BMY,X,Y,W,H)) :-
	recorded('$window','$window'(_,DY,WD,GC),_), !,
	recorded('$pixmap','$pixmap'(Name,PixMap),_),
	Mask=16'ffff,
	XYPixmap=1,
    	'XGetGeometry'(DY,PixMap,_Root,_PX,_PY,PW,PH,_BW,_Depth),
	'XGetImage'(DY,PixMap,0,0,PW,PH,Mask,XYPixmap,Image),
	'XPutImage'(DY,WD,GC,Image,BMX,BMY,X,Y,W,H).


get_pixmap(PixAtom,PixMap) :- atomic(PixAtom), !,
	recorded('$pixmap','$pixmap'(PixAtom,PixMap),_).
get_pixmap(PixList,PixMap) :-
	recorded('$window','$window'(_,Display,Window,GC),_), !,
	list_to_pixmap(PixList),
	x_my_create_pixmap_from_data(Display,Window,GC,PixMap).



list_to_pixmap([]).
list_to_pixmap([Line|R]) :-
	list_to_pixmap_line(Line),
	x_my_end_pixmap_line,
	list_to_pixmap(R).

list_to_pixmap_line([]).
list_to_pixmap_line([Pixel|Rest]) :-
	x_my_add_pixel(Pixel),
	list_to_pixmap_line(Rest).

	
	
