/*----------------------------------------------------------------------*
*									*
*			Edipo - sicstus/quintus version			*
*									*
*						August 90		*
*						Ze' Paulo Leal		*
*						Universidade do Porto	*
*									*
*-----------------------------------------------------------------------*
*									*
*	file :		attr.c						*
*	purpose : 	window and gc attr functions			*
*	creation	91/12/16					*
*	last changes :	92/04/24					*
*	bugs :								*
*	commennts :							*
*									*
*----------------------------------------------------------------------*/

#include "callx.h"

#define MAXDATA	1024
int width=0,max_width=0, height=0, bit_counter=0;
int x_hot, y_hot;
char data[MAXDATA], *ptr=data;

x_my_add_pixel(Pixel) long int Pixel;
{
  *ptr |= ((char) Pixel==' ' ? '\0' : 0x01<<bit_counter);
  if( (bit_counter=(bit_counter+1)%8)==0 )
    {
      if(ptr-data > MAXDATA)
	ErrorHandler("bitmap too long",ABORT_AFTER_ERROR);
      else
	ptr++;
    }
  width++;
}
x_my_end_pixmap_line()
{
  height++;
  if( width>max_width ) max_width=width;
  width=0;
  if( bit_counter!=0 ) ptr++;
  bit_counter=0;
}

x_my_create_pixmap_from_data(display,window,gc,pixmap)
     Display *display;
     Window window;
     GC gc;
     Pixmap *pixmap;
{int depth, i;	

 depth= DisplayPlanes(display,DefaultScreen(display));
 *pixmap= XCreatePixmapFromBitmapData(display,
				      window, /*DefaultRootWindow(display),*/
				      data,max_width,height,
				      gc->values.foreground,
				      gc->values.background,
				      depth);

 /* Reset data structures */
 width=max_width=height=bit_counter=0;
 ptr=data;
 for(i=0;i<MAXDATA;i++)
   data[i]='\0';
}

long int x_my_display_planes(display) 
     Display *display;
{ 
  return DisplayPlanes(display,DefaultScreen(display));
}

long int x_my_read_bitmap_data(name)
     char *name;
{
  FILE *fp;
  int i,size, v;
  char c, t[256];

  if((fp=fopen(name,"r")) == NULL) 
    return ~BitmapSuccess;
  if(
     (fscanf(fp,"%s%s%d",t,t,&max_width)==EOF) ||
     (fscanf(fp,"%s%s%d",t,t,&height)==EOF) ||
     (fscanf(fp,"%s%s%d",t,t,&x_hot)==EOF) ||
     (fscanf(fp,"%s%s%d",t,t,&y_hot)==EOF)
     )
    return ~BitmapSuccess;

  size = ((max_width) + 7)/ 8  * (height);
  if(size > MAXDATA) 
     return ~BitmapSuccess;
  for(i=0;i<size;i++)
    {
      while(1)
	{
	  c=fgetc(fp);
	  if(c == EOF)
	    return ~BitmapSuccess;
	  if(c != '0')
	    continue;
	  c=fgetc(fp);
	  if(c == EOF)
	    return ~BitmapSuccess;
	  if(c == 'x')
	    break;
	  }
      if(fscanf(fp,"%x",&v) == EOF)
	return ~BitmapSuccess;
      data[i] = (char) v;
    }  

  return BitmapSuccess;
}
