/*----------------------------------------------------------------------*
*									*
*			Edipo - sicstus/quintus version			*
*									*
*						August 90		*
*						Ze' Paulo Leal		*
*						Universidade do Porto	*
*									*
*-----------------------------------------------------------------------*
*									*
*	file :		attr.c						*
*	purpose : 	window and gc attr functions			*
*	creation	91/04/12					*
*	last changes :	91/04/12					*
*	bugs :								*
*	commennts :							*
*									*
*----------------------------------------------------------------------*/

#include "callx.h"
#include "attr.h"

int n_wd_atoms, n_gc_atoms, n_wd_v_atoms, n_gc_v_atoms;
atom_entry window_atoms[] = 
{
  {  "display",		0L, /* No XConf. Mask*/		0L },
  {  "parent",		0L, /* idem  */			0L },
  {  "x", 		CWX,				0L },
  {  "y", 		CWY,				0L },
  {  "width",		CWWidth,			0L },
  {  "height",		CWHeight,			0L },
  {  "border",		CWBorderWidth,			0L },
  {  "bkg_pixmap",	CWBackPixmap,			0L },
  {  "bkg_pixel",	CWBackPixel,			0L },
  {  "border_pixmap",	CWBorderPixmap,			0L },
  {  "border_pixel",	CWBorderPixel,			0L },
  {  "bit_gravity",	CWBitGravity,			0L },
  {  "win_gravity", 	CWWinGravity,			0L },
  {  "backing_store",	CWBackingStore,			0L },
  {  "backing_planes",	CWBackingPlanes,		0L },
  {  "backing_pixel",	CWBackingPixel,			0L },
  {  "save_under",	CWSaveUnder,			0L },
  {  "redirect",	CWOverrideRedirect,		0L },
  {  "colormap",	CWColormap,			0L },
  {  "cursor", 		CWCursor,			0L },
  {  NULL,		0L,				0L }  
};


atom_entry gc_atoms[] = 
{
  {  "function",	GCFunction,			0L },
  {  "line_width",	GCLineWidth,			0L },
  {  "line_style",	GCLineStyle,			0L },
  {  "cap",		GCCapStyle,			0L },
  {  "join",		GCJoinStyle,			0L },
  {  "fill_style",	GCFillStyle,			0L },
  {  "fill_rule",	GCFillRule,			0L },
  {  "arc_mode",	GCArcMode,			0L },
  {  "font",		GCFont,				0L },
  {  "plane_mask",	GCPlaneMask,			0L },
  {  "foreground",	GCForeground,			0L },
  {  "background",	GCBackground,			0L },
  {  NULL,		0L,				0L }
};



atom_entry window_val_atoms[]={
{  "forget", 		ForgetGravity,			0L },
{  "unmap",		UnmapGravity,			0L },
{  "northWest",		NorthWestGravity,		0L },
{  "north",		NorthGravity,			0L },
{  "northEast",		NorthEastGravity,		0L },
{  "west",		WestGravity,			0L },
{  "center",		CenterGravity,			0L },
{  "east",		EastGravity,			0L },
{  "southWest",		SouthWestGravity,		0L },
{  "south",		SouthGravity,			0L },
{  "southEast",		SouthEastGravity,		0L },
{  "static",		StaticGravity,			0L },
/*
{  "true",		0L,		        	0L },
{  "false",		0L,				0L },
{  "none",		0L,				0L },
{  "parentRelative",	0L,				0L },
{  "notUseful",		0L,				0L },
{  "whenMapped",	0L,				0L },
{  "always",		0L, 				0L },
*/
{  NULL,						0L }
};


atom_entry gc_val_atoms[]={
{  "solid",		LineSolid,			0L },
{  "onOffDash",		LineOnOffDash,			0L },
{  "doubleDash",	LineDoubleDash,			0L },
{  "notLast",		CapNotLast,			0L },
{  "butt",		CapButt,			0L },
{  "round",		CapRound,			0L },
{  "projecting",	CapProjecting,			0L },
{  "miter",		JoinMiter,			0L },
{  "round",		JoinRound,			0L },
{  "bevel",		JoinBevel,			0L },
{  "fillSolid",		FillSolid,			0L },
{  "tiled",		FillTiled,			0L },
{  "stippled",		FillStippled,			0L },
{  "opaqueStippled",	FillOpaqueStippled,		0L },
{  "evenOdd", 		EvenOddRule,			0L },
{  "winding",		WindingRule,			0L },
{  "chord",		ArcChord,			0L },
{  "pieSlice",		ArcPieSlice,			0L },
{  "clear",		GXclear,			0L },
{  "and",		GXand,				0L },
{  "andReverse",	GXandReverse,			0L },
{  "copy",		GXcopy,				0L },
{  "andInverted",	GXandInverted,			0L },
{  "noop",		GXnoop,				0L },
{  "xor",		GXxor,				0L },
{  "or",		GXor,				0L },
{  "nor",		GXnor,				0L },
{  "equiv",		GXequiv,			0L },
{  "invert",		GXinvert,			0L },
{  "orReverse",		GXorReverse,			0L },
{  "copyInverted",	GXcopyInverted,			0L },
{  "orInverted",	GXorInverted,			0L },
{  "nand",		GXnand,				0L },
{  "set",		GXset,				0L },
{  NULL,		0L,				0L}
};



atom_compare(a,b) atom_entry *a, *b;
{
  return a->atom - b->atom;
}

unsigned long int window_atom, gc_atom, true_atom, false_atom;

static init_atom_table(table,size) 
     atom_entry table[]; 
     int *size;
{
  int i;

  for(i=0;table[i].name;i++)
    table[i].atom=AtomFromString(table[i].name);

  *size=i;
  qsort((char *)table,
	*size,
	sizeof(atom_entry),
	atom_compare
	);
}


init_window_atoms()
{
  window_atom = AtomFromString("window");
  gc_atom = AtomFromString("gc");
  true_atom = AtomFromString("true");
  false_atom = AtomFromString("false");
  
  init_atom_table(window_atoms,&n_wd_atoms);
  init_atom_table(gc_atoms,&n_gc_atoms);
  init_atom_table(window_val_atoms,&n_gc_v_atoms);
  init_atom_table(gc_val_atoms,&n_gc_v_atoms);

  return TRUE;
}

unsigned long int x_window_attr(Attr) unsigned long int Attr;
{
  atom_entry *an;
  WindowAtomSearch(an,Attr);
  if(an != NULL) 
    return true_atom;
  return false_atom;
}

unsigned long int x_gc_attr(Attr) unsigned long int Attr;
{
  atom_entry *an;
  GCAtomSearch(an,Attr);
  if(an != NULL) 
    return true_atom;
  return false_atom;
}







