
% generation of new positions using minimax (with alfa-beta)

choose_minimax(T,L,black,NT) :- f_min(T,_,L,NT,NV).
choose_minimax(T,L,white,NT) :- f_max(T,_,L,NT,NV).
/*
			 - f_min -
			/         \
		       /	  min ---|
		      /     	/     	 |
		   f_max     f_max    	f_max
		    /	     /  \
		   /	    /     ab_max --|
		  /	   /	 / 	   |
		f_min	f_min   f_min  



*/



/* first evaluation */

f_min(T,S,L,M,V) :-
	(L=0 -> 
		V=S
	;
		K is L-1,
		gen_ord_pos(T,black,[(FS,_,FT)|R]),
		f_max(FT,FS,K,_,FV),
		min(R,K,FT,FV,M,V)
	).

f_max(T,S,L,M,V) :-
	(L=0 -> 
		V=S
	;
		K is L-1,
		gen_ord_pos(T,white,[(FS,_,FT)|R]),
		f_min(FT,FS,K,_,FV),
		max(R,K,FT,FV,M,V)
	).

/* top right branch evaluation */

max([],_,M,V,M,V).
max([(FS,_,FT)|R],L,GT,GV,M,V) :-
	f_min(FT,FS,L,_,FV),
	(FV > GV ->
		max(R,L,FT,FV,M,V)
	;
		max(R,L,GT,GV,M,V)
	).
		

min([],_,M,V,M,V).
min([(FS,_,FT)|R],L,GT,GV,M,V) :-
	f_max(FT,FS,L,_,FV),
	(FV < GV ->
		min(R,L,FT,FV,M,V)
	;
		min(R,L,GT,GV,M,V)
	).


