
:- ensure_loaded(library(edipo)).

:- nl,
	write('try					?  vaz.'), nl,
	write('try also 				?  bigvaz.'), nl,
	write('or try, with N=1..6 			?- vaz(N). '), nl, nl.

vaz :- 
	window(vazarelli,[width=300,height=300]), 
	vaz(5).

bigvaz :-
	window(vazarelli,[width=600,height=600]),
	vaz(6).

%%%%%%%

vaz(Type) :- 
	window(vazarelli,[]),
	gc(black,[background=black,foreground=white]),
	gc(white,[background=white,foreground=black]),
	clear,
	size(Type,ML,MC),
	lin(0,ML,MC,white,black,Type).

lin(Line,ML,MC,Color,Other,Type) :-
	(Line==ML -> true;
	    col(0,Line,ML,MC,Color,Other,Type),
	    Next is Line+1,
	    lin(Next,ML,MC,Other,Color,Type)
	).

col(Column,Line,ML,MC,Color,Other,Type) :-
	(Column==MC -> true;
	    gc(Color,[]),
	    rect(Type,Line,Column,ML,MC,X,Y,W,H),
	    frectangle(X,Y,W,H),
	    Next is Column+1,
	    col(Next,Line,ML,MC,Other,Color,Type)
	).


%%%%%%%

size(1,ML,MC) :-
	current_window(vazarelli,[width=W,height=H]),
	TH is 1+8*H, sqrt(TH,STH),
	ML is integer((-1+STH)/2),
	TW is 1+8*W, sqrt(TW,STW),
	MC is integer((-1+STW)/2).	

rect(1,L,C,_,_,X,Y,W,H) :-
	X is C*(C+1)>>1,
	Y is L*(L+1)>>1,
	W is C+1,
	H is L+1.

%%%%%%%%

size(2,ML,MC) :-
	P = 10,
	current_window(vazarelli,[width=W,height=H]),
	T is P*(P+1)>>1,
	ML is integer(W/T*P),
	MC is integer(H/T*P).


rect(2,LL,CC,_,_,X,Y,W,H) :-
	P is 10,
	L is LL mod P,
	C is CC mod P,
	G is P*(P+1)>>1,
	X is (CC//P)*G + C*(C+1)>>1,
	Y is (LL//P)*G + L*(L+1)>>1,
	W is C+1,
	H is L+1.

%%%%%%%%

size(3,ML,MC) :-
	current_window(vazarelli,[width=W,height=H]),
	TH is 1+8*H, sqrt(TH,STH),
	ML is integer((-1+STH)/2),
	TW is 1+8*W, sqrt(TW,STW),
	MC is integer((-1+STW)/2).	

rect(3,L,C,ML,MC,X,Y,W,H) :-
	X is C*MC - C*(C-1)>>1,
	Y is L*ML - L*(L-1)>>1,
	W is (MC-C),
	H is (ML-L).

%%%%%%%%

size(4,ML,MC) :-
	P = 10,
	current_window(vazarelli,[width=W,height=H]),
	T is P*(P+1)>>1,
	ML is integer(W/T*P),
	MC is integer(H/T*P).


rect(4,LL,CC,_,_,X,Y,W,H) :-
	P is 10,
	L is LL mod P,
	C is CC mod P,
	G is P*(P+1)>>1,
	X is (CC//P)*G + C*P - C*(C-1)>>1,
	Y is (LL//P)*G + L*P - L*(L-1)>>1,
	W is P-C,
	H is P-L.

%%%%%%%%%%

size(5,ML,MC) :-
	P = 10,
	current_window(vazarelli,[width=W,height=H]),
	T is P*(P+1)>>1,
	ML is integer((W/T+1)*P),
	MC is integer((H/T+1)*P).


rect(5,LL,CC,_,_,X,Y,W,H) :-
	P is 10,
	L is LL mod P,
	C is CC mod P,
	G is P*(P+1)>>1,
	(1 is (CC//P) mod 2 ->
		X is (CC//P)*G + C*P - C*(C-1)>>1,
		W is P-C ;
		X is (CC//P)*G + C*(C+1)>>1,
		W is C+1),
	(1 is (LL//P) mod 2 ->
		Y is (LL//P)*G + L*P - L*(L-1)>>1,
		H is P-L ;
		Y is (LL//P)*G + L*(L+1)>>1,
		H is L+1).

%%%%%%%%%%

size(6,ML,MC) :-
	current_window(vazarelli,[width=W,height=H]),
	TH is 1+8*H>>1, sqrt(TH,STH),
	ML is integer((-1+STH)/2) <<1,
	TW is 1+8*W>>1, sqrt(TW,STW),
	MC is integer((-1+STW)/2) <<1.	


rect(6,LL,CC,ML,MC,X,Y,W,H) :-
	LP is ML>>1,
	CP is MC>>1,
	L is LL mod LP,
	C is CC mod CP,
	GL is LP*(LP+1)>>1,
	GC is CP*(CP+1)>>1,
	(CC >= LP ->
		X is (CC//CP)*GC + C*CP - C*(C-1)>>1,
		W is CP-C ;
		X is (CC//CP)*GC + C*(C+1)>>1,
		W is C+1),
	(LL >= LP ->
		Y is (LL//LP)*GL + L*LP - L*(L-1)>>1,
		H is LP-L ;
		Y is (LL//LP)*GL + L*(L+1)>>1,
		H is L+1).

:- (edipo:engine(quintus) -> 
	ensure_loaded(library(math))
    ;
	asserta((sqrt(X,Y) :- Y is sqrt(X)))
    ).
