
:- ensure_loaded(library(edipo)).

pi(3.14159).

home :- 
	current_window('Turtle Graphics',[width=WD,height=HG]),
	X is WD>>1,
	Y is HG>>1,
	H is 0,
	set_turtle(X,Y,H).


get_turtle(X,Y,H) :- recorded(pos,pos(X,Y,H),_).

set_turtle(_,_,_) :- recorded(pos,_,R), erase(R), fail.
set_turtle(X,Y,H) :- recorda(pos,pos(X,Y,H),_).


fd(L) :-
	get_turtle(X,Y,H),
	cos(H,CH),
	NX is X + L*CH,
	sin(H,SH),
	NY is Y - L*SH,
	iline(X,Y,NX,NY),
	set_turtle(NX,NY,H).


rt(A) :-
	get_turtle(X,Y,H),
	pi(PI),
	NH is H+(A/180)*PI,
	set_turtle(X,Y,NH).




show_turtle(X,Y,H) :- L=10,
	gc(turtle,[]),
	circle(X,Y,L),
	cos(H,CH),
	XL is X+L*CH,
	sin(H,SH),
	YL is X+L*SH,
	iline(X,Y,XL,YL),
	gc(graphics,[]).


show_help :-
	writeterm(10,20,'?- fd(L).       to move the turtle forward L pixels'),
	writeterm(10,40,'?- rt(A).       to rotate the turtle A degrees'),
	writeterm(10,60,'?- set(X,Y,H).  to set turtle pos. and head.'),
	writeterm(10,80,'?- get(X,Y,H).  to get turtle pos. and head.').


iline(X1,Y1,X2,Y2) :-
	IX1 is integer(X1),
	IY1 is integer(Y1),
	IX2 is integer(X2),
	IY2 is integer(Y2),
	line(IX1,IY1,IX2,IY2).


:- (edipo:engine(quintus) -> 
	ensure_loaded(library(math))
    ;
	asserta((sqrt(X,Y) :- Y is sqrt(X))),
	asserta((cos(X,Y) :- Y is cos(X))),
	asserta((sin(X,Y) :- Y is sin(X))),
	asserta((acos(X,Y) :- Y is acos(X)))
    ).


:-
	window('Turtle Graphics',[]),
	gc(turtle,[function=invert]),
	gc(graphics,[function=copy]),
	home,
	show_help.



