% water.nl

% some code which is ftp'able for use with the Luger & Stubblefied
% book - Introduction to AI (Benjamin Cummings)
%
% pretty well as is, some minor changes	
% test using go( state(5,0),state(2,3),Path).
%
% because of ordering of moves, it takes a very long way round to do this
%
%%%%%Basic depth first path algorithm in PROLOG %%%%%%%
	% go initializes the visited stack and calls path
	
go(Start, Goal, Path) :-
	empty_stack(Empty_been_list),
	stack(Start, Empty_been_list, Been_list),
	path(Start, Goal, Been_list, Path).
	
	% path implements a depth first search in PROLOG
	
	% Current state = goal, print out been list
path(Goal, Goal, Been_list, Been_list).

	
path(State, Goal, Been_list, Path) :-
	move2(State, Next),
	% not(unsafe(Next)),
	not_member_stack(Next, Been_list),
	stack(Next, Been_list, New_been_list),
	path(Next, Goal, New_been_list, Path), !.
	
%%%%%%%%%%%%%%%%%%%% stack operations %%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	% These predicates give a simple, list based implementation of stacks

	% empty stack generates/tests an empty stack


empty_stack([]).

	% member_stack tests if an element is a member of a stack

not_member_stack(E, S) :- (member(E, S), !, fail) ; true.

	% stack performs the push, pop and peek operations
	% to push an element onto the stack
		% ?- stack(a, [b,c,d], S).
	%    S = [a,b,c,d]
	% To pop an element from the stack
	% ?- stack(Top, Rest, [a,b,c]).
	%    Top = a, Rest = [b,c]
	% To peek at the top element on the stack
	% ?- stack(Top, _, [a,b,c]).
	%    Top = a 

stack(E, S, [E|S]).


	% move rules for water jugs. 
	% States are state(Large, Small).
	% 
	% George: I had to call these move2 since AAIS PROLOG already uses move 
	% for some of its internals
	

	% Fill the large
move2(state(_, S), state(5, S)).

	% Fill the small
move2(state(L, _), state(L, 3)).

	% Empty the large
move2(state(_, S), state(0, S)).

	% Empty the small
move2(state(L, _), state(L, 0)).

	% Fill the large from the small
move2(state(L, S), state(5, New_S)):-
	is( S1, -(5, L)),
	>=( S , S1),
	is( New_S, -( S, S1)).

	% Fill the small from the large
move2(state(L, S), state(New_L, 3)):-
	is( L1, -( 3, S)),
	>=( L, L1),
	is( New_L, -(L, L1)).
	
	% Empty the large into the small
move2(state(L, S), state(0, New_small)):-
	is(L1, -( 3, S)),
	>=( L1, L),
	is( New_small, +( S, L)).
	
	% Empty the small into the large
move2(state(L, S), state(New_large, 0)):-
	is( S1, -( 5, L)),
	>=( S1, S),
	is( New_large, +(L, S)).
	


