#include <stdio.h>
#include "token.h"
#include "interf.h"

#define QUOTED 1
#define IGNORE_OPS 2
#define NUMBERVARS 4
#define WLTERM 256

#define OPTIONMASK 255

#define WBUFSIZE (4096*16)

#define SOLO_ITEM 0
#define NUMERIC_ITEM 1
#define IDENTIFIER_ITEM 2
#define QUOTED_ATOM_ITEM 3
#define GRAPHIC_ITEM 4

#define VARNUM 1024

unsigned char wbuffer[1+WBUFSIZE+MAXTOKENLENGTH+SLACK];
/*
 * +-+-------------------+------------+
 * |p|       wbufsize    |   reserve  |
 * +-+-------------------+------------+
 *
 * p = previous character
 */

unsigned char *wptr = wbuffer;
int lastitem = SOLO_ITEM;

#define RESETWBUF() wptr = wbuffer+1
#define PUTCHAR(c) {*wptr++ = (c);}
#define PUTSOLO(c) {lastitem = SOLO_ITEM; *wptr++ = (c);}
#define CHECKBUFFER(file) if (wptr > wbuffer+1+WBUFSIZE) flushbuffer(file)
#define USDVAR(s) ((s[0] == '$') && (s[1] == 'V') && \
                   (s[2] == 'A') && (s[3] == 'R') && (!s[4]))
#define PUTINT(i) \
{ \
  register unsigned n = (i); \
  unsigned char tempbuffer[20]; \
  register unsigned char *p = tempbuffer; \
  do { \
    *p++ = n % 10 + '0'; \
    n /= 10; \
  } while (n); \
  do { \
    PUTCHAR(*--p); \
  } while (p > tempbuffer); \
}


#define FUNCTIONAL(tp,termname) \
{ \
  if ((options & NUMBERVARS) && USDVAR(termname) && __ARITY(tp) == 1) { \
    register int varno; \
    register termtype *tp2; \
             \
    tp2 = __LASTARG(tp,1); \
    tp2 = deref(tp2); \
    if (ISINT(tp2)) { \
      varno = __INT(tp2); \
      if (lastitem == IDENTIFIER_ITEM) PUTCHAR(' '); \
      PUTCHAR(varno % 26 + 'A'); \
      if (varno = varno / 26) { \
        PUTINT(varno); \
      } \
      lastitem = IDENTIFIER_ITEM; \
      return; \
    } \
  }  \
  showname(termname, options); \
  PUTSOLO('('); \
  for (i=1; i < __ARITY(tp); i++) { \
    recwriteterm(file, __ARG(tp,i), options, 1000, 1201); \
    PUTSOLO(','); \
  } \
  recwriteterm(file, __LASTARG(tp,__ARITY(tp)), options, 1000, 1201); \
  PUTSOLO(')'); \
}

void flushbuffer(file)
FILE *file;
/*
 * write buffer is copied to file
 */
{
  *wptr = 0;
  fprintf(file,wbuffer+1);
  *wbuffer = wptr[-1];
  RESETWBUF();
  fflush(file);
}

int needquotes(s)
unsigned char *s;
/*
 * function that checks whether an atom should be quoted
 * in order to make it readable by read_term/3 again
 */
{
  if (small_letter_char(*s)) {
    s++;
    while (alpha_numeric_char(*s)) s++;
    return *s;
  } else if (graphic_token_char(*s)) {
    s++;
    while (graphic_token_char(*s)) s++;
    return *s;
  } else if (semicolon_char(*s) && !s[1])
    return 0;
  else if (cut_char(*s) && !s[1]) 
    return 0;
  else if (solo_char(*s) && !s[1]) 
    return 1;
  else if (open_list_char(s[0]) && close_list_char(s[1]) && !s[2]) 
    return 0;
  else if (open_curly_char(s[0]) && close_curly_char(s[1]) && !s[2]) 
    return 0;
  return 1;
}

void showname(s, options)
unsigned char *s;
int options;
/* 
 * outputs a name, adds quotes and layout text if needed
 */
{
  if ((options & QUOTED) && needquotes(s)) {
    if (lastitem == QUOTED_ATOM_ITEM) PUTCHAR(' ');
    PUTCHAR('\'');
    while (*s) { 
      if (*s >= ' ') {
        if (backslash_char(*s)) { /* escape char should be duplicated 
                             in order to denote itself */
          PUTCHAR(*s); 
          PUTCHAR(*s); 
        } else 
          PUTCHAR(*s);
      } else {
        PUTCHAR('\\');
        switch (*s) {
          case 7:  PUTCHAR('a'); break;
          case 8:  PUTCHAR('b'); break;
          case 9:  PUTCHAR('t'); break;
          case 10: PUTCHAR('n'); break;
          case 11: PUTCHAR('v'); break;
          case 12: PUTCHAR('f'); break;
          case 13: PUTCHAR('r'); break;
        }
      }
      s++;
    }
    PUTCHAR('\'');
    lastitem = QUOTED_ATOM_ITEM;
  } else {
    if ((lastitem == IDENTIFIER_ITEM || lastitem == NUMERIC_ITEM) && 
           alpha_numeric_char(*s) || 
        lastitem == GRAPHIC_ITEM     && graphic_token_char(*s))
          PUTCHAR(' ');
    while (*s) {
      PUTCHAR(*s); 
      s++;
    }
    if (graphic_token_char(wptr[-1]))
      lastitem = GRAPHIC_ITEM;
    else
      lastitem = IDENTIFIER_ITEM;
  }
}

int needspace(tp, termpri)
termtype *tp;
int termpri;
/*
 * checks whether the term tp will be displayed between
 * brackets, given the priority level termpri. In that
 * case a space need to be inserted before the left bracket.
 */
{
  int prepri, inpri, postpri, spec;

  if (!tp) return 0;
  tp = deref(tp); 
  if (ISATOM(tp)) 
    return operator(__ATOMNAME(tp),&prepri,&inpri,&postpri,&spec);
  else if (ISTERM(tp)) {
    if(operator(__TERMNAME(tp), &prepri, &inpri, &postpri, &spec)) {
      if (__ARITY(tp)==2) 
        return inpri >= termpri;
      if (__ARITY(tp)==1) {
        if (isprefix(spec) && ispostfix(spec)) {
          /* in case of ambiguity:
             select the associative operator over the nonassociative
             select prefix over postfix */
          if (isfy(spec)) spec = isfy(-1);
          else if (isyf(spec)) spec = isyf(-1);
          else spec = isfx(-1);
        }
        if (isprefix(spec))
          return prepri >= termpri;
        else
          return postpri >= termpri;
      } else 
        return 0;
    } else 
      return 0;
  } else 
    return 0;
}

void recwriteterm(file, tp, options,termpri,atompri)
FILE *file;
termtype *tp;
int options;
int termpri, atompri;
/*
 * recursive writeterm routine
 */
{
  int prepri, inpri, postpri, spec;

  if (!tp) return;
  CHECKBUFFER(file);
  tp = deref(tp); 
  if (ISINT(tp)) {
    register int intval = __INT(tp);
    if (intval < 0) {
      if (lastitem == GRAPHIC_ITEM)
        PUTCHAR(' ');
      PUTCHAR('-');
      intval = -intval;
    } else {
      if (lastitem == NUMERIC_ITEM || lastitem == IDENTIFIER_ITEM)
        PUTCHAR(' ');
    }
    PUTINT(intval);
    lastitem = NUMERIC_ITEM;
  } else if (ISATOM(tp)) {
    register int brackets = 0;
    register unsigned char *atomname = __ATOMNAME(tp);
    if (atompri == 1201)
      showname(atomname, options);
    else {
      if (operator(atomname,&prepri,&inpri,&postpri,&spec)) {
        if (prepri >= atompri) brackets = 1;
        if (inpri >= atompri) brackets = 1;
        if (postpri >= atompri) brackets = 1;
        if (comma_char(atomname[0]) && !atomname[1]) brackets = 1;
      }
      if (brackets) PUTSOLO('(');
      showname(atomname, options);
      if (brackets) PUTSOLO(')');
    }
  } else if (ISFLOAT(tp)) {
    register double ff = __FLOAT(tp);
    if (ff < 0.0) {
      if (lastitem == GRAPHIC_ITEM)
        PUTCHAR(' ');
    } else {
      if (lastitem == NUMERIC_ITEM || lastitem == IDENTIFIER_ITEM)
        PUTCHAR(' ');
    }
    sprintf(wptr,"%f", __FLOAT(tp));
    while (*wptr) wptr++;
    lastitem = NUMERIC_ITEM;
  } else if (ISTERM(tp)) {
      register unsigned char *termname = __TERMNAME(tp);
      register int termarity = __ARITY(tp);
      register int i;
      if (options & IGNORE_OPS || termarity > 2) {
        FUNCTIONAL(tp,termname);
      } else  /* operator definitions are now in effect */
      if (termarity == 2) {
        if (end_char(termname[0]) && !termname[1]) {  /* list constructor */
          register int first = 1;

          PUTSOLO('[');
          do {
            if (first) first = 0; else PUTSOLO(',');
            recwriteterm(file, __ARG(tp,1), options, 1000, 1201);
            tp = __LASTARG(tp,2);
            tp = deref(tp);
          } while (ISTERM(tp) && 
                  (termname = __TERMNAME(tp)) && 
                  end_char(termname[0]) && !termname[1]);
          if (!ISATOM(tp) || strcmp(__ATOMNAME(tp),"[]")) {
            PUTSOLO('|');
            recwriteterm(file,tp,options, 1000, 1201);
          } 
          PUTSOLO(']');
        } else if (operator(termname, &prepri, &inpri, &postpri, &spec) &&
                   isinfix(spec) && inpri) {
          if (inpri >= termpri || 
              (options & WLTERM) && isxfy(spec) && inpri+1==termpri) PUTSOLO('('); 
          if (isyfx(spec))
            recwriteterm(file, __ARG(tp,1), options | WLTERM, inpri+1,0);
          else
            recwriteterm(file, __ARG(tp,1), options & OPTIONMASK, inpri,0);
          if (comma_char(termname[0]) && !termname[1]) {
            PUTSOLO(',');
          } else 
            showname(termname, options);
          recwriteterm(file,__LASTARG(tp,2),options,isxfy(spec)?inpri+1:inpri,0);
          if (inpri >= termpri ||
              (options & WLTERM) && isxfy(spec)  && inpri+1==termpri) PUTSOLO(')'); 
        } else {
          FUNCTIONAL(tp,termname);
        }
      } else if (termarity == 1) {
        if (operator(termname, &prepri, &inpri, &postpri, &spec)) {
          if (isprefix(spec) && ispostfix(spec)) {
            /* in case of ambiguity:
               select the associative operator over the nonassociative
               select prefix over postfix */
            if (isfy(spec)) spec = isfy(-1);
            else if (isyf(spec)) spec = isyf(-1);
            else spec = isfx(-1);
          }
          if (isprefix(spec) && prepri) {
            if (prepri >= termpri || 
                (options & WLTERM) && isfy(spec) && prepri+1==termpri) PUTSOLO('('); 
            showname(termname, options);
            if (needspace(tp,isfy(spec)?prepri+1:prepri)) PUTSOLO(' ');
            recwriteterm(file, __LASTARG(tp,1), options, isfy(spec)?prepri+1:prepri,0);
            if (prepri >= termpri ||
                (options & WLTERM) && isfy(spec) && prepri+1==termpri) PUTSOLO(')'); 
          } else if (ispostfix(spec) && postpri) {
            if (postpri >= termpri) PUTSOLO('('); 
            if (isyf(spec))
              recwriteterm(file, __LASTARG(tp,1), options | WLTERM, postpri+1, 0);
            else
              recwriteterm(file, __LASTARG(tp,1), options, postpri, 0);
            showname(termname, options);
            if (postpri >= termpri) PUTSOLO(')'); 
          } else {
            FUNCTIONAL(tp,termname);
          }
        } else if (open_curly_char(termname[0]) && 
            close_curly_char(termname[1]) && !termname[2]) {
          /* curly brackets */
          PUTSOLO('{');
          recwriteterm(file, __LASTARG(tp,1), options, 1201,1201);
          PUTSOLO('}');
        } else {
          FUNCTIONAL(tp,termname);
        }
      } else {
        FUNCTIONAL(tp,termname);
      }
    } else if (ISVAR(tp)) {
      if (lastitem == IDENTIFIER_ITEM) {
        PUTCHAR(' ');
      }
      putvarname(wptr, tp);
      while (*wptr) wptr++;
      lastitem = IDENTIFIER_ITEM; /* same properties as variable */
    } else {
      fprintf(stderr, "Unknown term type (%08x)\n", tp);
    }
}

int writeterm(file, tp, options)
FILE *file;
termtype *tp;
int options;
{
  RESETWBUF();
  lastitem = SOLO_ITEM;
  recwriteterm(file, tp, options, 1201,1201);
  flushbuffer(file);
  return 1;
}

