/*
 * This file contains the interface with the underlying
 * Prolog system. Put here all the include files you
 * need to complete the defines that follow
 */

#include "symtab.h"

typedef unsigned *heapcell;

/*
 * tag values used in this toy example
 */
#define __FLOATTAG 1
#define __INTTAG 2
#define __ATOMTAG 4
#define __TERMTAG 8
#define __VARTAG 16
 
/*
 * toy term type
 */

typedef struct termtype {
    int tag;
    symboltype *data[1];
  } termtype;


/**************************************************
 * here starts the obligatory part of interface.h
 **************************************************/

/***************** type tests ********************/
/*   t is a term */

#define ISFLOAT(t)     ((t)->tag == __FLOATTAG)
#define ISINT(t)       ((t)->tag == __INTTAG)
#define ISATOM(t)      ((t)->tag == __ATOMTAG)
#define ISTERM(t)      ((t)->tag == __TERMTAG)
#define ISVAR(t)       ((t)->tag == __VARTAG)

/***************** value definitions *************/
/* these definitions can be used as lvalue and
   as rvalues!  They will have to be redefined
   by the user.  **********************************/

/* floating point value */
#define __FLOAT(t)     (*(double *)((t)->data[0]))

/* integer value */
#define __INT(t)       ((int)((t)->data[0]))

/* internalized atom */
#define __ATOM(t)      ((symboltype *)((t)->data[0]))

/* string representation of an atom t */
#define __ATOMNAME(t)  (__ATOM(t)->name)

/* string representation of a compound term t  */
#define __TERMNAME(t)  (__ATOM(t)->name)

/* arity of a compound term  t */
#define __ARITY(t)     (__ATOM(t)->arity)

/* argument n of compound term t */
#define __ARG(t,n)     ((termtype *)((t)->data[n]))

/* last argument of a compound term t
   some implementations (eg BinProlog) use a compaction
   scheme that treats the last argument of a compound
   term different from the other arguments */
#define __LASTARG(t,n) ((termtype *)((t)->data[n]))


/********************* fixed part of interface.h   
 This part should not be modified by the user  *******/

termtype *makefloat();
termtype *makeinteger();
termtype *makeatom();
termtype *maketerm();
termtype *makevar();
symboltype *getsymbol();
termtype *deref();
int fileread();
int operator();
void putvarname();


/************* defines used to deal with operators */

#define XFX       0x0001
#define XFY       0x0002
#define YFX       0x0004
#define XF        0x0010
#define YF        0x0020
#define FX        0x0040
#define FY        0x0080
#define DELIMITER 0x0100
#define TERM      0x1000
#define LTERM     0x3000

#define isprefix(X)    ((X) & (FX|FY))
#define ispostfix(X)   ((X) & (XF|YF))
#define isinfix(X)     ((X) & (XFX|XFY|YFX))

#define isfx(X)        ((X) & FX)
#define isfy(X)        ((X) & FY)
#define isxf(X)        ((X) & XF)
#define isyf(X)        ((X) & YF)
#define isxfx(X)       ((X) & XFX)
#define isxfy(X)       ((X) & XFY)
#define isyfx(X)       ((X) & YFX)

#define isop(X)        ((X) & (XFX|XFY|YFX|XF|YF|FX|FY))
#define isterm(X)      ((X) & TERM)

#define islterm(X)     (((X) & LTERM) == LTERM)
#define isdelimiter(X) ((X) & DELIMITER)
