/*
 * interface module with the standard Prolog parser
 *
 */

#include "interf.h"
#include <stdio.h>

extern heapcell heap[];

termtype *makefloat(Hptr,f)
register heapcell *Hptr;
double f;
/*
 * internatizes the float value f
 * and return it 
 */
{
  termtype *tp = (termtype *)*Hptr;
  *Hptr += sizeof(termtype) >> 2;
  tp->tag = __FLOATTAG;
  if ((int)(*Hptr) & 7) *Hptr += 1; /* align double word */
  tp->data[0] = (void *)*Hptr;
  *Hptr += sizeof(double) >> 2;
  __FLOAT(tp) = f;
  return tp;
}

termtype *makeinteger(Hptr,i)
register heapcell *Hptr;
int i;
/*
 * internalizes the integer value i
 * and return it
 */
{
  termtype *tp = (termtype *)*Hptr;
  *Hptr += sizeof(termtype) >> 2;
  tp->tag = __INTTAG;
  tp->data[0] = (symboltype *)i;
  return tp;
}

termtype *makeatom(Hptr,s)
register heapcell *Hptr;
char *s;
/*
 * internalizes the string s and returns
 * it as atom 
 */
{
  termtype *tp = (termtype *)*Hptr;
  *Hptr += sizeof(termtype) >> 2;
  tp->tag = __ATOMTAG;
  __ATOM(tp) = getsymbol(s, 0);
  return tp;
}

termtype *maketerm(Hptr,s,n)
register heapcell *Hptr;
char *s;
int n;
/*
 * internalizes the functor string s with arity n
 * and returns a pointer to it
 */
{
  int i;
  termtype *tp = (termtype *)*Hptr;
  *Hptr += (n*sizeof(void *)+sizeof(termtype)) >> 2;

  tp->tag = __TERMTAG;
  __ATOM(tp) = getsymbol(s, n);
  for (i=1; i<=n; i++) __ARG(tp,i) = (void *)NULL;
  return tp;
}

termtype *makevar(Hptr)
register heapcell *Hptr;
/*
 * creates a variable and returns it
 */
{
  termtype *tp = (termtype *)*Hptr;
  *Hptr += sizeof(termtype) >> 2;
  tp->tag = __VARTAG;
  tp->data[0] = (symboltype *)NULL;
  return tp;
}

symboltype *getsymbol(s,a)
char *s;
int a;
/*
 * return the internalized version of the functor s with
 * arity a; create the symbol if it does not already exist
 */
{
  return (symboltype *)findsymbol(s,a);
}

termtype *deref(tp)
termtype *tp;
/* no comment */
{
  while (ISVAR(tp) && tp->data[0]) tp = tp->data[0];
  return (termtype *)tp;
}

int fileread(buf, len)
register char *buf;
register int len;
/* 
 * read at most len bytes from stdin into buf
 * returns the number of bytes read 
 */
{
   return read(0, buf, len);
}

int operator(op, prepri, inpri, postpri, spec)
char *op;
int *prepri, *inpri, *postpri, *spec;
/*
 * operator interface.
 * given a string representation op,
 * it returns the priority as prefix operator (prepri),
 * infix operator (inpri) and postfix operator (postpri).
 * In addition it returns the specifier of the operator.
 * This is the OR of all the possible (overloaded)
 * specifiers. The function returns 1 is op is an 
 * operator, 0 otherwise 
 */
{
  return findoperator(op, prepri, inpri, postpri, spec);
}

void putvarname(buffer, t)
register char *buffer;
register termtype *t;
/*
 * this functions writes a null terminated string
 * in buffer, corresponding to the output format
 * for variable t
 */
{
  sprintf(buffer, "_%d", (heapcell)t-(heapcell)heap);
}
