/*  VT52.PL
    Shelved on the 21st of December 1987
*/


/*  '$vedescape'( X+ ):
    Emit atom X, preceded by an ESC.
*/
'$vedescape'( X ) :-
    put( 27 ), write( X ).


/*  cursor( X+, Y+ ):
    Move cursor to X, Y.
*/
cursor( X, Y ) :-
    '$vedescape'( 'Y' ),
    put( Y+32 ),
    put( X+32 ).

/*  clear_from( X+, Y+ ):
    Move cursor to X,Y and clear rest of page.
*/
clear_from( X, Y ) :-
    cursor( X, Y ),
    '$vedescape'( 'J' ).


/*  clear_line( X+, Y+ ):
    Move cursor to X,Y and clear rest of line.
*/
clear_line( X, Y ) :-
    cursor( X, Y ),
    '$vedescape'( 'K' ).


/*  clear_eol:
    Clear to end of current line.
*/
clear_eol :-
    '$vedescape'( 'K' ).


/*  hilight( State+ ):
    Inverse video on (State=on) or off (State=off).
*/
hilight( on ) :-
    '$vedescape'( '3' ).
hilight( off ) :-
    '$vedescape'( '4' ).


/*  set_graphics:
    Place VDU into graphic (i.e. cursor-addressable) mode
    and clear screen.
*/
set_graphics :-
    clear_screen.


/*  clear_screen:
    Clear the screen.
*/
clear_screen :-
    '$vedescape'( 'E' ),
    cursor( 0, 0 ).
