/*  VT100.PL
    Shelved on the 21st of December 1987
*/


/*  '$vedoutint'( X+ ):
    Emit X (integer) as its ASCII representation.
*/
'$vedoutint'( X ) :-
    write( X ).


/*  '$vedescape'( X+ ):
    Emit atom X, preceded by an ESC.
*/
'$vedescape'( X ) :-
    put( 27 ), write( X ).  


/*  cursor( X+, Y+ ):
    Move cursor to X, Y.
*/
cursor( X, Y ) :-
    '$vedescape'( '[' ),
    Y1 is Y + 1, '$vedoutint'( Y1 ),
    write( ';' ),
    X1 is X + 1, '$vedoutint'( X1 ),
    write( 'H' ).


/*  clear_from( X+, Y+ ):
    Move cursor to X,Y and clear rest of page.
*/
clear_from( X, Y ) :-
    cursor( X, Y ),
    '$vedescape'( '[' ), write('J').


/*  clear_line( X+, Y+ ):
    Move cursor to X,Y and clear rest of line.
*/
clear_line( X, Y ) :-
    cursor( X, Y ),
    '$vedescape'( '[' ), write('K').


/*  clear_eol:
    Clear to end of current line.
*/
clear_eol :-
    '$vedescape'( '[' ), write('K').


/*  hilight( State+ ):
    Inverse video on (State=on) or off (State=off).
*/
hilight( on ) :-
    '$vedescape'( '[' ), write( '7m' ).
hilight( off ) :-
    '$vedescape'( '[' ), write( '0m' ).


/*  set_graphics:
    Place VDU into graphic mode (i.e. cursor-addressable mode)
    and clear screen.
*/
set_graphics :-
    clear_screen.


/*  clear_screen:
    Clear the screen.
*/
clear_screen :-
    '$vedescape'( '[' ), write( '2J' ),
    cursor( 0, 0 ).
