From:	CBS%UK.AC.NSFNET-RELAY::EDU.BRANDEIS.CS.CHAOS::DSMITH 27-FEB-1991 01:08:38.77
To:	popx
CC:	
Subj:	Submission to public library

Via: UK.AC.NSFNET-RELAY; Wed, 27 Feb 91   1:08 GMT
Received: from vax.nsfnet-relay.ac.uk by sun2.nsfnet-relay.ac.uk 
          with SMTP inbound id <16204-410@sun2.nsfnet-relay.ac.uk>;
          Tue, 26 Feb 1991 22:20:47 +0000
Received: from [129.64.2.6] by vax.NSFnet-Relay.AC.UK via NSFnet with SMTP 
          id aa13373; 26 Feb 91 20:41 GMT
Received: by chaos.cs.brandeis.edu Tue, 26 Feb 91 12:02:46 est
Date: Tue, 26 Feb 91 12:02:46 est
From: "Donald A. Smith" <dsmith@edu.brandeis.cs.chaos>
Message-Id: <9102261702.AA11373@chaos.cs.brandeis.edu>
To: popx@uk.ac.oxford.vax
Subject: Submission to public library

%Submission to public library.

:- public length_bounded/3,max_length/2,max_depth/2.
%----------------------------------------------------------------
/*
Many Prologs have a builtin function length/2 that can be used either
(1) to determine the length of a given list or (2) to non-deterministically 
create longer and longer lists.     We define a function length_bounded/3 
with the following specification:

  length_bounded(?L,?Len,+Max) "L is a list of length Len, where Len<=Max".

Like length/2, it can bind L to successively longer lists when Len is
unbound, but subject to the constraint that Len<=Max.   It uses ":-wait"
declarations and runs under Sicstus Prolog.
*/

length_bounded(L,Len,Max):- max_length(L,Max),length(L,Len).
%----------------------------------------------------------------
:- wait max_length/2.
/*
max_length(?L,+Max)  "L is not a list of length > Max".
This predicate causes failure and backtracking if and when L gets bound 
to a list of length > Max.
This predicate can NOT be used to instantiate L to longer and longer lists;
because of the "wait" declaration above, max_length/2 is a consumer of L,
not a producer of L.  
Use length_bounded/3 to get the effect of length/2 with a maximum length.
*/
max_length(L,_):-
	functor(L,F,A),F-A \== '.'-2.
max_length([_|T],Max):- Max>0, % Assume that Max is a number
	MaxM1 is Max-1, max_length(T,MaxM1).

%----------------------------------------------------------------

:- wait max_depth/2.
/* Assume

       depth(X)=0  if X is atomic.
       depth(X)=1+max(depth(T_i)) if X is f(T_1,...,T_n)

Then max_depth(T,Max) causes failure and backtracking if and when T gets
bound to a term of depth>Max.  

max_depth/2 might be useful for simulating breadth-first search:
iteratively increase the maximum depth of data structures appearing
in a call until the call succeeds.

Because of the "wait" we know that A below is not a variable.
*/
max_depth(A,_):- atomic(A),!.
max_depth(A,Depth):- Depth>0,NewDepth is Depth-1,
	functor(A,_,N),max_depth_args(N,A,NewDepth).

max_depth_args(0,_,_).
max_depth_args(N,A,NewDepth):- N>0,arg(N,A,Arg),max_depth(Arg,NewDepth),
	Nm1 is N-1,max_depth_args(Nm1,A,NewDepth).
