/* Copyright (C) 1994 Mauro Gaspari - Dipartimento di Matematica,
   University on Bologna, Italy. */

/*********************************************************** 
 * This file is compiled dinamically this allows to define the
 * constants 
 * #define WMSIZE       size of the bitmaps
 * #define NRULES       number of rules
 * #define MODULE       current module
 * I am using -D options in compile_c_file
 ***********************************************************/

#define mskcnt WMSIZE
#define FALSE 0
#define TRUE 1

#include "bitmap.h"

/* Rules
 * for the bitmap matching algorithm
 */

/* Working Memory items */

#define BBELEMENTS WMSIZE*32

/* Items of this array identifies 
 * masks for each rule
 */

static int rg[NRULES][WMSIZE];
static int ng[NRULES][WMSIZE];

static int BBstate[BBELEMENTS]; /* BBstate number */ 
long BBelements[WMSIZE];	/* BBstate mask */

#define BBSET(i) BITSET(BBelements, i)
#define BBUPD(i) BITSET(BBelements, i);(BBstate[i])++;
#define BBDEL(i) if (--(BBstate[i]) == 0) BITCLEAR(BBelements, i)

#define RGSET(r,i) (BITSET(rg[r],i))
#define NGSET(r,i) (BITSET(ng[r],i))

void rules_initialize()
{
  int i;
  for (i = 0; i <= NRULES; i++) {
    CLEARBITS(rg[i]);
  }
}

void bb_initialize()
{
  int i;
  CLEARBITS(BBelements);
  for (i= 0; i <= BBELEMENTS; i++) 
    BBstate[i] = 0;
}







    

