/* Copyright (C) 1994 Mauro Gaspari - Dipartimento di Matematica,
   University on Bologna, Italy. */

/* C runtime support */

#include "fw_rules.h"
#include "runtime.h"
#include <stdio.h>

SP_pred_ref p;
SP_pred_ref cp;
int number_rules;

#ifdef DEBUG
#define TIME
#endif

#ifdef TIME
#include "time.h"
#endif

/***********************
 *  Runtime Functions  *
 ***********************
 */

int c_del_wm(n)
long n;
{
  BBDEL(n);
  return(1);
}
 
int c_upd_wm(n)
long n;
{
  BBUPD(n);
  return(1);
}

/* 
 *  Compiler Functions 
 */

int c_set_wm(n)
long n;
{
  BBSET(n);
  return(1);
}

int c_set_oc(m,n)
long m;
long n;
{
  BBstate[m] = n;
}

int c_set_rg(n,m)
long m;
long n;
{
  RGSET(n,m);
  return(1);
}

int c_run()
{  
#ifdef TIME
  long t_inizio,t_fine;
  t_inizio = clock();
#endif 
  main_loop();
#ifdef TIME
  t_fine = clock();
  fprintf(stderr,"time: %ld\n",(long)((t_fine-t_inizio)/1000.0));
#endif 
  return(1);
}

main_loop()
{
  int i,res;
  SP_term r;
#ifdef DEBUG
  fprintf(stderr,"start main loop\n");
#endif 
  p = SP_predicate("p",1,MODULE);  /* module is set during compilation */
LOOP:
  i = 0;
  res = 0;
  while (!res && i < NRULES) {
    if (TESTAND(rg[i],BBelements)) {
      SP_show_term(&r);
      SP_put_integer(&r,i);
#ifdef DEBUG
      fprintf(stderr,"calling rule p(%d)\n",i);
#endif
      res = SP_query_cut_fail(p,&r);
      SP_hide_term(&r);
      switch (res) { 
      case 1: 
#ifdef DEBUG
	fprintf(stderr,"rule firing p(%d)\n",i);
#endif
	goto LOOP;
	break;
      case 0: 
	break;
      case -1: 
	fprintf(stderr,"Error in evaluating p(%d)\n",i);
	break;
      }
    }
  i++;
  }
  if (i == NRULES) 
#ifdef DEBUG
    fprintf(stderr,"no production true\n");
#endif
  return(1);
}

int c_run_check(term)
SP_term term;
{  
  int result;
#ifdef TIME
  long t_inizio,t_fine;
  t_inizio = clock();
#endif 
  result = main_loop_check(term);
#ifdef TIME
  t_fine = clock();
  fprintf(stderr,"time: %ld\n",(long)(t_fine/1000.0));
#endif
  return(result);
}

main_loop_check(term)
SP_term term;
{
  int i,res,res1;
  SP_term r;
  p = SP_predicate("p",1,MODULE);
  cp = SP_predicate("callfw",1,"fw_rules");
  res1 = 0;
LOOP:
  i = 0;
  res = 0;
  SP_show_term(&term);
  res1 = SP_query_cut_fail(cp,&term);
  SP_hide_term(&term);
  switch (res1) { 
  case 1: 
#ifdef DEBUG
    fprintf(stderr,"condition true\n");
#endif
    return(1);
    break;
  case 0: 
    break;
  case -1: 
    fprintf(stderr,"Error in evaluating final condition call\n");
  break;
  }

  while (!res && i < NRULES) {
    if (TESTAND(rg[i],BBelements)) {
      SP_show_term(&r);
      SP_put_integer(&r,i);
#ifdef DEBUG
      fprintf(stderr,"calling rule p(%d)\n",i);
#endif
      res = SP_query_cut_fail(p,&r);
      SP_hide_term(&r);
      switch (res) { 
      case 1: 
#ifdef DEBUG
	fprintf(stderr,"rule firing p(%d)\n",i);
#endif
	goto LOOP;
	break;
      case 0: 
	break;
      case -1: 
	fprintf(stderr,"Error in evaluating p(%d)\n",i);
	break;
      }
    }
  i++;
  }
  if (i == NRULES) {
#ifdef DEBUG
    fprintf(stderr,"no production true\n");
#endif
    return(0);
  }
}

/* this is needed to avoid conversion while passing a term 
 * perhaps this can be improved */

int c_init()
{
  SP_install_c_predicate("c_run_check",1,"fw_rules",c_run_check);
}

