/*  board.pl  */


:- module board.


:- public
    building / 2,
    buys / 3,
    in / 2,
    joins / 2,
    sells / 3,
    sells_fuel / 2,
    square / 3,
    unit_volume / 2.


/*  This is the board for the trading game. See TRAVELLER.PL for a
    description of the predicates.
*/

square(1, 2, 12).
square(2, 3, 13).
square(3, 4, 13).
square(4, 5, 13).
square(5, 6, 12).
square(6, 5, 11).
square(7, 4, 11).
square(8, 3, 11).
square(9, 2, 5).
square(10, 3, 6).
square(11, 4, 6).
square(12, 5, 6).
square(13, 6, 5).
square(14, 5, 4).
square(15, 4, 4).
square(16, 3, 4).
square(17, 8, 12).
square(18, 9, 13).
square(19, 10, 13).
square(20, 11, 13).
square(21, 12, 12).
square(22, 11, 11).
square(23, 10, 11).
square(24, 9, 11).
square(25, 9, 7).
square(26, 10, 8).
square(27, 11, 7).
square(28, 10, 6).
square(29, 4, 10).
square(30, 4, 9).
square(31, 4, 8).
square(32, 4, 7).
square(33, 7, 12).
square(34, 10, 10).
square(35, 10, 9).
square(36, 13, 12).
square(37, 14, 12).
square(38, 15, 11).
square(39, 15, 10).
square(40, 15, 9).
square(41, 15, 8).
square(42, 15, 7).
square(43, 15, 6).
square(44, 15, 5).
square(45, 15, 4).
square(46, 15, 3).
square(47, 14, 2).
square(48, 13, 2).
square(49, 12, 2).
square(50, 11, 2).
square(51, 10, 2).
square(52, 9, 2).
square(53, 8, 2).
square(54, 7, 2).
square(55, 6, 2).
square(56, 5, 2).
square(57, 4, 2).
square(58, 3, 2).
square(59, 2, 2).
square(60, 8, 7).
square(61, 7, 8).
square(62, 7, 9).
square(63, 12, 7).
square(64, 13, 6).
square(65, 13, 5).
square(66, 10, 5).
square(67, 9, 4).
square(68, 8, 4).

building(1, 'Fine Things').
building(2, 'Ride Rite').
building(3, 'L d F TV').
building(4, 'KrystalKlear').
building(5, 'Green\'s').
building(6, 'Pirana Petrol').
building(8, 'ClearView').
building(9, 'Argent\'s').
building(10, 'No Bull Please').
building(12, 'Greatfields').
building(13, 'Diamond Gallery').
building(14, 'The Glass House').
building(16, 'Good Taste').
building(18, 'Cookham\'s').
building(20, 'Burnham\'s').
building(22, 'Charrett\'s').
building(24, 'Yugo').
building(30, 'Coker\'s').
building(32, 'Major\'s').
building(33, 'Gifts \'n Glasses').
building(36, 'Scargill\'s').
building(40, 'Truckmate').
building(41, 'First Fruits').
building(43, 'I.G.Knight').
building(44, 'J L B TV').
building(45, 'Aurum').
building(48, 'A.R.L.').
building(50, 'Edison\'s').
building(51, 'Pippin\'s').
building(52, 'A.N.Ode').
building(53, 'Reflections').
building(54, 'B.T.U.Knight').
building(55, 'Slack\'s').
building(56, 'Burnett\'s').
building(57, 'Lucent').
building(58, 'Caprice').
building(59, 'Maxwell\'s').
building(60, 'Goldsmith\'s').
building(61, 'Wheelers').
building(63, 'Freds Fuel').
building(66, 'Collier\'s').

joins(1, 2).
joins(2, 3).
joins(3, 4).
joins(4, 5).
joins(5, 6).
joins(6, 7).
joins(7, 8).
joins(8, 1).
joins(9, 10).
joins(10, 11).
joins(11, 12).
joins(12, 13).
joins(13, 14).
joins(14, 15).
joins(15, 16).
joins(16, 9).
joins(17, 18).
joins(18, 19).
joins(19, 20).
joins(20, 21).
joins(21, 22).
joins(22, 23).
joins(23, 24).
joins(24, 17).
joins(25, 26).
joins(26, 27).
joins(27, 28).
joins(28, 25).
joins(7, 29).
joins(29, 30).
joins(30, 31).
joins(31, 32).
joins(32, 11).
joins(5, 33).
joins(33, 17).
joins(23, 34).
joins(34, 35).
joins(35, 26).
joins(21, 36).
joins(36, 37).
joins(37, 38).
joins(38, 39).
joins(39, 40).
joins(40, 41).
joins(41, 42).
joins(42, 43).
joins(43, 44).
joins(44, 45).
joins(45, 46).
joins(46, 47).
joins(47, 48).
joins(48, 49).
joins(49, 50).
joins(50, 51).
joins(51, 52).
joins(52, 53).
joins(53, 54).
joins(54, 55).
joins(55, 56).
joins(56, 57).
joins(57, 58).
joins(58, 59).
joins(26, 35).
joins(35, 34).
joins(34, 23).
joins(25, 60).
joins(60, 61).
joins(61, 62).
joins(27, 63).
joins(63, 64).
joins(64, 65).
joins(28, 66).
joins(66, 67).
joins(67, 68).

in(1, 'The Hub').
in(2, 'The Hub').
in(3, 'The Hub').
in(4, 'The Hub').
in(5, 'The Hub').
in(6, 'The Hub').
in(7, 'The Hub').
in(8, 'The Hub').
in(9, 'Beverly Hills').
in(10, 'Beverly Hills').
in(11, 'Beverly Hills').
in(12, 'Beverly Hills').
in(13, 'Beverly Hills').
in(14, 'Beverly Hills').
in(15, 'Beverly Hills').
in(16, 'Beverly Hills').
in(17, 'Colliery Row').
in(18, 'Colliery Row').
in(19, 'Colliery Row').
in(20, 'Colliery Row').
in(21, 'Colliery Row').
in(22, 'Colliery Row').
in(23, 'Colliery Row').
in(24, 'Colliery Row').
in(25, 'The Plain').
in(26, 'The Plain').
in(27, 'The Plain').
in(28, 'The Plain').

loop('The Hub').
loop('Beverly Hills').
loop('Colliery Row').
loop('The Plain').

sells_fuel('Freds Fuel', 32).
sells_fuel('Wheelers', 30).
sells_fuel('Truckmate', 40.59).
sells_fuel('Yugo', 35).
sells_fuel('Pirana Petrol', 80.03).
sells_fuel('Ride Rite', 50).

buys('Caprice', diamonds, 1600).
buys('Burnett\'s', coal, 30.0).
buys('Slack\'s', coal, 21.57).
buys('B.T.U.Knight', coal, 19).
buys('Reflections', glasses, 58).
buys('Pippin\'s', peaches, 9.5).
buys('Gifts \'n Glasses', glasses, 60.09).
buys('Major\'s', coal, 24.99).
buys('Charrett\'s', coal, 20.39).
buys('Good Taste', peaches, 8.03).
buys('The Glass House', glasses, 57.0).
buys('Diamond Gallery', diamonds, 1500).
buys('ClearView', televisions, 111.13).
buys('KrystalKlear', glasses, 55.97).

sells('Collier\'s', coal, 8.4).
sells('Goldsmith\'s', diamonds, 350).
sells('Maxwell\'s', televisions, 90.09).
sells('Lucent', glasses, 47.5).
sells('A.N.Ode', televisions, 92.5).
sells('Edison\'s', televisions, 93.49).
sells('A.R.L.', televisions, 95.0).
sells('Aurum', diamonds, 390).
sells('J L B TV', televisions, 98.74).
sells('I.G.Knight', coal, 5.09).
sells('First Fruits', peaches, 4.23).
sells('Scargill\'s', coal, 5.09).
sells('Coker\'s', coal, 8.01).
sells('Burnham\'s', coal, 9.59).
sells('Cookham\'s', coal, 13.79).
sells('Greatfields', peaches, 4.23).
sells('No Bull Please', glasses, 47.99).
sells('Argent\'s', diamonds, 400).
sells('Green\'s', peaches, 5.01).
sells('L d F TV', televisions, 100.39).
sells('Fine Things', glasses, 50.37).

unit_volume(coal, 50).
unit_volume(diamonds, 0.5).
unit_volume(glasses, 10).
unit_volume(peaches, 2).
unit_volume(televisions, 10).


:- endmodule.
