/*  GO.PL  */


:- module go.


:- public go/0.


/*
SPECIFICATION
-------------

This module exports the predicate go/0, the top-level predicate which
starts the Tutor.


PUBLIC go/0:
------------

'go' starts the Tutor. Once started, the Tutor will always terminate by
calling halt.

'go' itself initialises the operating-system interface and editor,
greets the student and confirms she has invoked the right program, and
tries reading the script named when Logic was invoked. At Oxford, the
script name is passed in a system variable set up by the command file
LOGIC.COM.

If no script was named on the command line, or the script file is
unreadable, 'go' halts with a fatal error. Otherwise 'go' auto-loads the
knowledge-base and starts the read-obey loop.
*/


/*
IMPLEMENTATION
--------------

Just calls to other modules.
*/


:- needs
    command_line_parameter_is / 1,
    initialise_editor / 0,
    initialise_operating_system_interface / 0,
    output / 1,
    read_and_do_sentences / 0,
    restore_auto_knowledge_base / 0,
    script / 2,
    set_mode / 1.


go :-
    initialise_operating_system_interface,
    initialise_editor,
    set_mode( logic ),
    output( 'THE LOGIC PROGRAMMING TUTOR'~~ ),
    command_line_parameter_is( LessonName ),
    (
        LessonName = no_parameter_found
    ->
        output( 'I can\'t determine which lesson file you wanted'~ ),
        halt
    ;
        go_given_lesson_name( LessonName )
    ).


go_given_lesson_name( LessonName ) :-
    script( LessonName, Status ),
    (
        Status = ok
    ->
        restore_auto_knowledge_base,
        read_and_do_sentences
    ;
        output( 'I can\'t read the lesson file'...LessonName~ ),
        halt
    ).


:- endmodule.
