/*  TRADER.PL  */


/*  This is an exact copy of TRADER.LOGIC.  */


act( trader, Act, Arg1, Arg2 ) :-
    at( trader, Here ),
    in( Here, 'The Hub' ),
    hub_act( trader, Act, Arg1, Arg2 ).

act( trader, Act, Arg1, Arg2 ) :-
    on_way_to_hub_act( trader, Act, Arg1, Arg2 ).


on_way_to_hub_act( trader, buy, fuel, Qty ) :-
    at_fuel_station( trader, Price ),
    fuel_needed( trader, Qty ),
    Qty >= 1.

on_way_to_hub_act( trader, move, Next, dummy ) :-
    at( trader, Here ),
    nearest_gateway( Here, 'The Hub', HubGate ),
    route( Here, HubGate, Route ),
    Route = [ Next | _ ].


hub_act( trader, buy, fuel, Qty ) :-
    at_fuel_station( trader, Price ),
    Price < 60,
    fuel_needed( trader, Qty ),
    Qty >= 1.

hub_act( trader, buy, glasses, Qty ) :-
    at_seller( trader, glasses, Price ),
    quantity_purchasable( trader, glasses, Price, Qty ),
    Qty >= 1.

hub_act( trader, sell, glasses, Qty ) :-
    at_buyer( trader, glasses, Price ),
    carries( trader, glasses, Qty ),
    Qty >= 1.

hub_act( trader, move, Next, dummy ) :-
    at( trader, Here ),
    clockwise( Here, Next ).


at_seller( T, Good, Price ) :-
    at( T, Square ),
    square_sells( Square, Good, Price ).


at_fuel_station( T, Price ) :-
    at( T, Square ),
    square_sells_fuel( Square, Price ).


at_buyer( T, Good, Price ) :-
    at( T, Square ),
    square_buys( Square, Good, Price ).


square_sells( Square, Good, Price ) :-
    building( Square, Shop ),
    sells( Shop, Good, Price ).


square_sells_fuel( Square, Price ) :-
    building( Square, Shop ),
    sells_fuel( Shop, Price ).


square_buys( Square, Good, Price ) :-
    building( Square, Shop ),
    buys( Shop, Good, Price ).


cheapest_seller_in_region( Good, Region, Square ) :-
    in( Square, Region ),
    square_sells( Square, Good, Price ),
    not((
            in( Other, Region ),
            Other \= Square,
            square_sells( Other, Good, OtherPrice ),
            OtherPrice < Price
       )).


dearest_buyer_in_region( Good, Region, Square ) :-
    in( Square, Region ),
    square_buys( Square, Good, Price ),
    not((
            in( Other, Region ),
            Other \= Square,
            square_buys( Other, Good, OtherPrice ),
            OtherPrice > Price
       )).


fuel_needed( T, Qty ) :-
    fuel( T, F ),
    tank_size( T, TS ),
    Qty is TS - F.


 quantity_purchasable( T, Good, Price, Qty ) :-
    cash( T, CashNow ),
    FuelSafeCash is CashNow - 8*80,
    QtyAffordable is FuelSafeCash / Price,
    unit_volume( Good, UnitVolume ),
    Volume is QtyAffordable*UnitVolume,
    total_load( T, TotalLoad ),
    max_load( T, Capacity ),
    CapacityLeft is Capacity-TotalLoad,
    least( CapacityLeft, Volume, VolumeCarriable ),
    Qty is VolumeCarriable/UnitVolume.


least( A, B, A ) :-
    A < B.

least( A, B, B ) :-
    A >= B.


nearest_gateway( From, Region, Gateway ) :-
    gateway( Region, Gateway ),
    distance( Gateway, From, D ),
    not((
            gateway( Region, Other ),
            Other \= Gateway,
            distance( Other, From, D1 ),
            D1 < D
       )).


gateway( Region, Square ) :-
    in( Square, Region ),
    adjacent( Square, Other ),
    not( in(Other,Region) ).
