/*  COUNTRIES.PL  */


/*  has_capital( Country, Town ):
        True if Country has capital Town.
*/
has_capital(ireland,dublin).
has_capital(uk,london).
has_capital(portugal,lisbon).
has_capital(spain,madrid).
has_capital(andorra,andorra).
has_capital(france,paris).
has_capital(belgium,brussels).
has_capital(luxemburg,luxemburg).
has_capital(switzerland,berne).
has_capital(italy,rome).
has_capital(monaco,monte_carlo).
has_capital(san_marino,san_marino).
has_capital(vatican_city,vatican_city).
has_capital(netherlands,amsterdam).
has_capital(germany,berlin).
has_capital(denmark,copenhagen).
has_capital(poland,warsaw).
has_capital(ussr,moscow).
has_capital(czechoslovakia,prague).
has_capital(austria,vienna).
has_capital(liechtenstein,vaduz).
has_capital(hungary,budapest).
has_capital(rumania,bucharest).
has_capital(yugoslavia,belgrade).
has_capital(albania,tirana).
has_capital(bulgaria,sofia).
has_capital(greece,athens).
has_capital(finland,helsinki).
has_capital(sweden,stockholm).
has_capital(norway,oslo).


/*  is_on( Town, RiverOrSea ):
        True if Town stands on RiverOrSea.
*/
is_on(dublin,liffey).
is_on(london,thames).
is_on(lisbon,tagus).
is_on(madrid,manzanares).
is_on(andorra,valira).
is_on(paris,seine).
is_on(brussels,lenne).
is_on(luxemburg,alzette).
is_on(berne,aare).
is_on(rome,tiber).
is_on(monte_carlo,mediterranean).
is_on(vatican_city,tiber).
is_on(amsterdam,amstel).
is_on(tirana,lumi_tiranes).
is_on(berlin,spree).
is_on(copenhagen,baltic).
is_on(warsaw,vistula).
is_on(moscow,moskva).
is_on(prague,vltava).
is_on(vienna,danube).
is_on(vaduz,rhine).
is_on(budapest,danube).
is_on(bucharest,dimbo_vita).
is_on(belgrade,danube).
is_on(helsinki,baltic).
is_on(stockholm,arbogaan).
is_on(oslo,oslofjord).


/*  linked_to( River1, RiverOrSea2 ):
        True if River has as its destination RiverOrSea2.                     
 */
linked_to(liffey,irish_sea).
linked_to(thames,north_sea).
linked_to(manzanares,jarama).
linked_to(jarama,tagus).
linked_to(tagus,atlantic).
linked_to(valira,segre).
linked_to(segre,ebro).
linked_to(ebro,mediterranean).
linked_to(seine,english_channel).
linked_to(lenne,rupel).
linked_to(rupel,schelde).
linked_to(schelde,north_sea).
linked_to(alzette,sure).
linked_to(sure,moselle).
linked_to(moselle,rhine).
linked_to(amstel,ij).
linked_to(ij,zuider_zee).
linked_to(rhine,north_sea).
linked_to(aare,rhine).
linked_to(tiber,mediterranean).
linked_to(lumi_tiranes,ishm).
linked_to(ishm,mediterranean).
linked_to(spree,havel).
linked_to(havel,elbe).
linked_to(elbe,north_sea).
linked_to(vistula,oder).
linked_to(oder,baltic).
linked_to(moskva,oka).
linked_to(oka,volga).
linked_to(volga,caspian_sea).
linked_to(vltava,elbe).
linked_to(dimbo_vita,arges).
linked_to(arges,danube).
linked_to(iskur,danube).
linked_to(arbogaan,baltic).
linked_to(danube,black_sea).


/*  borders( Country1, Country2 ):
         True if Country1 and Country2 share a common border.
*/
borders(ireland,uk).
borders(portugal,spain).
borders(spain,france).
borders(spain,andorra).
borders(spain,france).
borders(andorra,france).
borders(france,belgium).
borders(france,luxemburg).
borders(france,germany).
borders(france,switzerland).
borders(france,italy).
borders(france,monaco).
borders(belgium,luxemburg).
borders(belgium,netherlands).
borders(netherlands,germany).
borders(belgium,germany).
borders(luxemburg,germany).
borders(switzerland,germany).
borders(switzerland,austria).
borders(switzerland,liechtenstein).
borders(switzerland,austria).
borders(switzerland,italy).
borders(liechtenstein,austria).
borders(italy,vatican_city).
borders(italy,san_marino).
borders(italy,austria).
borders(italy,yugoslavia).
borders(germany,denmark).
borders(germany,czechoslovakia).
borders(germany,austria).
borders(germany,poland).
borders(austria,czechoslovakia).
borders(austria,hungary).
borders(austria,yugoslavia).
borders(czechoslovakia,poland).
borders(yugoslavia,hungary).
borders(yugoslavia,rumania).
borders(yugoslavia,bulgaria).
borders(yugoslavia,albania).
borders(yugoslavia,greece).
borders(albania,greece).
borders(greece,turkey).
borders(greece,bulgaria).
borders(bulgaria,rumania).
borders(bulgaria,turkey).
borders(rumania,hungary).
borders(czechoslovakia,hungary).
borders(poland,ussr).
borders(czechoslovakia,ussr).
borders(hungary,ussr).
borders(rumania,ussr).
borders(ussr,norway).
borders(ussr,finland).
borders(norway,finland).
borders(norway,sweden).
borders(finland,sweden).


/*  next_to( Sea1, Sea2 ):
        True if Sea1 and Sea2 adjoin.
*/
next_to(black_sea,mediterranean).
next_to(baltic,kattegat).
next_to(kattegat,skagerrak).
next_to(oslofjord,skagerrak).
next_to(skagerrak,north_sea).
next_to(english channel,north_sea).
next_to(english_channel,atlantic).
next_to(north_sea,norwegian_sea).
next_to(irish_sea,atlantic).
next_to(zuider_zee, north_sea).
next_to(mediterranean,atlantic).
next_to(atlantic,norwegian_sea).
next_to(norwegian_sea,arctic_sea).


/*  on_sea( Country, Sea ):
        True if Country adjoins Sea.
*/
on_sea(ussr,black_sea).
on_sea(rumania,black_sea).
on_sea(bulgaria,black_sea).
on_sea(turkey,black_sea).
on_sea(turkey,mediterranean).
on_sea(greece,mediterranean).
on_sea(albania,mediterranean).
on_sea(yugoslavia,mediterranean).
on_sea(italy,mediterranean).
on_sea(france,mediterranean).
on_sea(monaco,mediterranean).
on_sea(france,mediterranean).
on_sea(spain,mediterranean).
on_sea(spain,atlantic).
on_sea(portugal,atlantic).
on_sea(spain,atlantic).
on_sea(france,atlantic).
on_sea(uk,atlantic).
on_sea(ireland,atlantic).
on_sea(norway,norwegian_sea).
on_sea(norway,arctic_sea).
on_sea(ussr,arctic_sea).
on_sea(france,english_channel).
on_sea(uk,english_channel).
on_sea(belgium,north_sea).
on_sea(netherlands,north_sea).
on_sea(uk,north_sea).
on_sea(netherlands,north_sea).
on_sea(germany,north_sea).
on_sea(denmark,north_sea).
on_sea(norway,north_sea).
on_sea(denmark,skagerrak).
on_sea(norway,skagerrak).
on_sea(denmark,kattegat).
on_sea(sweden,kattegat).
on_sea(sweden,skagerrak).
on_sea(sweden,baltic).
on_sea(finland,baltic).
on_sea(ussr,baltic).
on_sea(poland,baltic).
on_sea(germany,baltic).
on_sea(denmark,baltic).
on_sea(norway,oslofjord).
on_sea(ireland,irish_sea).
on_sea(uk,irish_sea).
on_sea(ussr,caspian_sea).


/*  flows_to( River1, RiverOrSea2 ):
        True if the water from River1 runs (directly or indirectly) to
        RiverOrSea2.
*/
flows_to(X,Y) :-
    linked_to(X,Y).

flows_to(X,Y) :-
    linked_to(X,Z),
    flows_to(Z,Y).
