;; Eulisp Module
;; Author: pab
;; File: newinit.em
;; Date: Mon May 11 16:09:58 1992
;;
;; Project:
;; Description: 
;;    initialisation of bytecode system 
;;    for a boot image.

(defmodule newinit
  (classes
   strings
   arith
   macros0
   generics
   boot-utils
   lists
   (except (assoc mapcar reverse memq mapc) list-operators)
   generics
   streams
   errors ;; should use generics/callbacks
   (except (null) class-names) ;;(internal-error)
   others ;; setter
   bci
   )
  ()
   
  (defun simple-add-method (gf meth)
    ((lambda (sig table)
       (if (null table)
	   (generic-method-table-setter gf (mk-initial-table sig (list meth)))
	 (add-meth-aux table sig (list meth)))
       ;;(if (methodp (car (find-applicable-methods gf sig)))
       ;;nil
       ;;(cerror  (find-applicable-methods gf sig) nil))
       ;; invalidate cache
       (generic-fast-method-cache-setter gf nil)
       (generic-slow-method-cache-setter gf nil)
       gf)
     (method-signature meth)
     (generic-method-table gf)))
  
  (defun add-method-method (gf meth)
    (simple-add-method gf meth))
  
  (export simple-add-method add-method-method)

  (defun mk-initial-table (initkey initentry)
    (fold (lambda (class tab)
	    (cons (cons class tab) nil))
	  (reverse initkey)
	  initentry))

  ;; starting this lot up...
  
  (defun add-meth-aux (table sig meth)
    ((lambda (xx)
       (if (null table)
	   ;; should never happen (should be a callback)
	   (error "can't happen" Internal-Error)
	 (if (null xx)
	     (progn (nconc table
			   (fold (lambda (class tab)
				   (cons (cons class tab) nil))
				 (reverse sig)
				 meth))
		    table)
	   (if (null (cdr sig))
	       ;; must have a relacement method
	       ((setter cdr) xx meth)
	     (add-meth-aux (cdr xx) (cdr sig) meth)))))
     (assq (car sig) table)))

  (defun add-method-to-slow-cache (gf sig meths)
    ((lambda (table)
       (if (null table)
	   (generic-slow-method-cache-setter 
	    gf 
	    (mk-initial-table sig (cons sig meths)))
	 (add-meth-aux table sig (cons sig meths)))
       table)
     (generic-slow-method-cache gf)))

  (defun find-applicable-methods (gf sig)
    (find-applic-methods-aux (generic-method-table gf)
			     (mapcar class-precedence-list sig)))
  
  (export find-applicable-methods)
  ;; wasteful...
  (defun find-applic-methods-aux (table cpl-lst)
    (if (null cpl-lst)
	nil
      (if (null (car cpl-lst))
	  nil
	(let ((xx (assq (car (car cpl-lst)) table)))
	  (if (null xx)
	      (find-applic-methods-aux table
				       (cons (cdr (car cpl-lst))
					     (cdr cpl-lst)))
	    (if (null (cdr cpl-lst))
		;; found summat
		(if (methodp (car (cdr xx)))
		    (cons (car (cdr xx))
			  (find-applic-methods-aux table
						   (cons (cdr (car cpl-lst))
							 (cdr cpl-lst))))
		  (progn (print "error-1") 
			 (print (list xx cpl-lst))
			 (print "error-1")
			 (print (list xx cpl-lst))
			 nil))
	      (append (find-applic-methods-aux (cdr xx) (cdr cpl-lst))
		      (find-applic-methods-aux table
					       (cons (cdr (car cpl-lst))
						     (cdr cpl-lst))))))))))




      
  (defun find-and-call-generic (gf args)
    (find-and-call-generic-1 gf args (mapcar class-of args)))

  (deflocal x nil)

  (defun find-and-call-generic-1 (gf args sig)
    ((lambda (meths)
       (if (null meths) 
	   (progn ;;(setq x (list gf sig args)) ;; should call generic-no-applicable-method
		  (error "No applicable method" Internal-Error 
			 'error-value (list gf sig)))
	 (progn (add-method-to-slow-cache gf sig meths)
		(generic-fast-method-cache-setter gf 
						  (cons sig meths))
		(if (methodp (car meths))
		    (call-method-by-list meths args)
		  (cerror meths nil)))))
     ((generic-discriminator gf) sig)))
  
  ;; use this at bootstrap...
  (defun default-compute-discriminating-function (gf)
    (lambda (sig)
      (find-applicable-methods gf sig)))
  
  (defun compute-discriminating-function-as-method (gf)
    (lambda (sig)
      (find-applicable-methods gf sig)))
  (export compute-discriminating-function-as-method)

  ;; add as a method...

  ;; Should have enough in place now...
(compile-time
  (set-compute-and-apply-fn find-and-call-generic)
  (set-bc-global 0 find-and-call-generic)
)
  ;; very much hacked up bootstrap
  
  (defun init-generic (gf)
    (generic-discriminator-setter gf
				  (default-compute-discriminating-function gf)))

  (export init-generic)
  ;; end module
  )
