;; Eulisp Module
;; Author: pete broadbery
;; File: comp-utils.em
;; Date: 1/sep/1991
;;
;; Project:
;; Description: 
;;   sundry compiler utliities...
;;

(defmodule comp-utl
  (standard0
   list-fns
   module-operators
   )
  ()

  (defun make-search-path (shell-var separator default)
    (let ((sp (or (getenv shell-var) default))
	  (sp-length 0))
      (if (null sp)
	  (list ".")
	(labels (
		 (dissect-path (index previous-index index-pairs)
		    (if (= index sp-length)
			(cons (cons previous-index (- index 1)) index-pairs)
		      (if (equal (string-ref sp index) separator)
			  (dissect-path
			   (+ index 1)
			   (+ index 1)
			   (cons (cons previous-index (- index 1)) index-pairs))
			(dissect-path (+ index 1) previous-index index-pairs)))))
		(setq sp-length (string-length sp))
		(reverse
		 (mapcar (lambda (start-finish)
			   (substring sp (car start-finish) (cdr start-finish)))
			 (dissect-path 0 0 ())))))))

  (defun path-open (pathlist name . options)
    (let/cc succeed
	    (mapc (lambda (path)
		    (let/cc fail
			    (with-handler (lambda (a b) (fail ()))
					  (succeed (apply open (format nil "~a/~a" path name) options)))))
		  pathlist)
	    (error
	     (format nil "path-open: cannot open stream for (~a) ~a" pathlist name)
	     cannot-open-path)
	    nil))

  (export make-search-path path-open)
  
  ;; macro expansion. 
  ;; low-level
  
  (defun get-expander (module-name name)
    (let ((module (get-module module-name)))
      (dynamic-access module name)))

  (defun interface-file-name (x) (format nil "~a.i" x))

  (defun get-module-stream (x) 
    (open (format nil "~a.em" x)))

  (export get-expander interface-file-name get-module-stream)

  ;; bytecode file-names

  (defun bytecode-file-name (x) 
    (format nil "~a.bc" x))

  (defun encapsulated-byte-file-name (x)
     (format nil "~a.ebc" x))

  (defun encapsulated-static-file-name (x)
     (format nil "~a.est" x))

  (defun sc-file-name (x)
     (format nil "~a.sc" x))

  (export bytecode-file-name encapsulated-byte-file-name
	  encapsulated-static-file-name
	  sc-file-name)

  ;; Reading and writing files. 
  ;; both cute hacks.

  (defun write-object (x file-name . path)
    (let ((xx (path-open (if path (car path) '("./")) file-name 'output)))
      (unwind-protect
	  (write (fold (lambda (slot lst)
			 (cons (car (slot-description-initargs slot))
			       (cons (slot-value-using-slot-description x slot)
				     lst)))
		       (class-slot-descriptions (class-of x))
		       nil)
		 xx)
	(close xx)
	)))
    
  (defun read-object (class file-name . path)
    (let ((file (path-open  (if path (car path) '("./")) file-name)))
      (unwind-protect (apply make-instance class 
			     (read file))
	(close file))))

  (export read-object write-object)

  ;; end module
  )
