;;; Initialisation for XLISP (V1.7) to be more Common Lisp compatible.
(setq *breakenable* t)	; DGUTS! ("Don't give up the ship")
(setq *tracenable* t)	; Show, what went wrong
(setq *tracelimit* 3)	; Usually enough to see what's wrong
 
(defun divide (x y) (/ x y))	; To provide compatibility with CLtL
				; In Common Lisp this is (FLOOR X Y)
				; and won't give you any ratio's
 
; The next is not perfect or correct, but it works...
(defmacro defvar (symbol &optional value documentation)
  (if (not (boundp symbol)) `(setq ,symbol ,value)))
 
; READLN is made for compatibility with Common Lisp (where you have to
; specify a NIL-result at EOF explicitely:
(defun readln (&optional stream)
  (if stream (read-line stream) (read-line *standard-input*)))
 
; Next is my own invention (Winston & Horn wasn't satisfying)
(defun pprint (thing &optional stream)
  (pprint-aux thing 0 (if stream stream *standard-output*))
  (terpri (if stream stream *standard-output*)))
(defun pprint-aux (thing column stream)
  (if	(<= column 0)
	(progn	(terpri stream) (setq column (- column))
		(dotimes (tmp column) (princ " " stream))))
  (if	(or (atom thing) (not (listp (cdr thing))))
	(prin1 thing stream)
	(prog	((tmp (flatsize (car thing))))
		(princ "(" stream)
		       (if (> tmp (/ (- 80 column) 2)) (go car-no-fit))
		       (prin1 (car thing) stream)
		       (if (null (cdr thing)) (go one-item-list))
		       (setq column (+ column tmp 1))
		       (princ " " stream) (setq thing (cdr thing))
		       car-no-fit (setq column (+ column 1))
		       (pprint-aux (car thing) column stream)
		       (dolist	(tmp (cdr thing))
				(pprint-aux tmp (- column) stream))
		       one-item-list (princ ")" stream))))

