;;; (C) Copyright 1990-1993 by Wade L. Hennessey. All rights reserved.

(in-package #+NATIVE-WCL "LISP"
	    #-NATIVE-WCL "W")

(define-system :cross-compiler
    :package #+NATIVE-WCL "LISP"
             #-NATIVE-WCL "W"
    :directory *root-directory*
    :source-extension "lisp"
    :binary-extension #+(and LUCID 386) "3bin"
                      #+(and LUCID MC68000) "lbin"
		      #+(AND LUCID SPARC) "sbin"
                      #+(AND MIPS LUCID) "mbin"
		      #+KCL "o"
		      #+(and CMU SPARC) "sparcf"
		      #+(or NATIVE-WCL WB) "o"
    :files '(:parallel
	     "src/compiler/cross/loop"
	     (:serial
	      "src/compiler/cross/macros"
	      "src/compiler/common/globals"
	      "src/compiler/common/macros"
	      (:parallel
	      "src/compiler/common/configurations"
	       "src/compiler/cross/cl-macros"
	       "src/compiler/common/format-compiler"
	       "src/compiler/common/function-info"
	       "src/compiler/cross/cross-functions"
	       "src/compiler/cross/hash-w"
	       "src/compiler/common/type-dispatch" 
	       "src/compiler/common/analyze"
	       "src/compiler/common/beta"
	       "src/compiler/common/tree-nsubst"
	       "src/compiler/common/improve"
	       "src/compiler/common/name-mangle"
	       "src/compiler/common/emit-code"
	       "src/compiler/common/emit-data"
	       "src/compiler/common/compiler-init"
	       "src/compiler/common/compile"
	       "src/compiler/common/symbol-table"
	       "src/compiler/common/library"
	       "src/compiler/common/link"))))

(define-system :native-compiler
    :package #+NATIVE-WCL "LISP"
             #-NATIVE-WCL "W"
    :directory *root-directory*
    :source-extension "lisp"
    :binary-extension #+(and LUCID 386) "3bin"
                      #+(and LUCID MC68000) "lbin"
		      #+(AND LUCID SPARC) "sbin"
                      #+(AND MIPS LUCID) "mbin"
		      #+KCL "o"
		      #+(and CMU SPARC) "sparcf"
		      #+(or WCL WB) "o"
    :files '(:serial
	     "src/compiler/common/globals"
	     "src/compiler/common/macros"
	     (:parallel
	      "src/compiler/common/configurations"
	      "src/compiler/common/format-compiler"
	      "src/compiler/common/function-info"
	      "src/compiler/common/type-dispatch"
	      "src/compiler/common/line-numbers"
	      "src/compiler/common/analyze"
	      "src/compiler/common/beta"
	      "src/compiler/common/tree-nsubst"
	      "src/compiler/common/improve"
	      "src/compiler/common/name-mangle"
	      "src/compiler/common/emit-code"
	      "src/compiler/common/emit-data"
	      "src/compiler/common/compiler-init"
	      "src/compiler/common/compile"
	      "src/compiler/common/symbol-table"
	      "src/compiler/common/library"
	      "src/compiler/common/link")))



