;;; (C) Copyright 1990-1993 by Wade L. Hennessey. All rights reserved.

(deftype-w cons ()
  '(satisfies consp))

(deftype-w foreign-pointer ()
  '(satisfies foreign-pointer-p))

(deftype-w vector (&optional type length)
  `(array ,type (,length)))

(deftype-w simple-vector (&optional length)
  `(simple-array t (,length)))

(deftype-w simple-string (&optional length)
  `(simple-array character (,length)))

(deftype-w string (&optional length)
  `(array character (,length)))

;;; HEY! What is this really? (array (unsigned-byte 32) (*)) ????
;;; give predicate a better name
(deftype-w 32bit-vector ()
  '(satisfies 32bit-vector-p))

(deftype-w bit-array (&optional dims)
  `(array bit ,dims))

(deftype-w bit-vector (&optional length)
  `(vector bit length))

(deftype-w complex-array ()
  '(satisfies complex-array-p))

(deftype-w vector-with-fill-pointer ()
  '(satisfies vector-with-fill-pointer-p))

(deftype-w sequence ()
  '(or list vector))

(deftype-w list ()
  '(or null cons))

(deftype-w fixnum ()
  `(integer ,most-negative-fixnum ,most-positive-fixnum))

(deftype-w bignum ()
  '(satisfies bignump))

(deftype-w ratio ()
  '(satisfies ratiop))

(deftype-w complex ()
  '(satisfies complexp))

(deftype-w number ()
  '(or integer float ratio complex))	

;;; HEY! fix this now that we have ratios...
(deftype-w rational (&optional low high)
  `(integer ,low ,high))

(deftype-w null ()
  '(satisfies null))

(deftype-w atom ()
  '(satisfies atom))

(deftype-w function-specifier ()
  '(or symbol cons))

(deftype-w function ()
  '(satisfies functionp))

(deftype-w compiled-function ()
  '(satisfies compiled-function-p))

(deftype-w procedure ()
  '(satisfies procedurep))

(deftype-w keyword ()
  '(satisfies keywordp))

(deftype-w string-arg ()
  '(or string symbol))

(deftype-w structure ()
  '(satisfies structurep))

(deftype-w unbound-variable-marker ()
  '(satisfies unbound-variable-marker-p))

(deftype-w byte-specifier ()
  '(satisfies byte-p))

(deftype-w short-float () 'float)

(deftype-w single-float () 'float)

(deftype-w double-float () 'float)

(deftype-w long-float () 'float)

(deftype-w string-char ()
  'character)

(deftype-w bit ()
  `(integer 0 1))

(deftype-w mod (n) `(integer 0 (,n)))

(deftype-w signed-byte (&optional width)
  (if (eq width '*)
      'integer
      (let ((x (expt 2 (1- width))))
	`(integer ,(- x) ,(- x 1)))))

(deftype-w unsigned-byte (&optional width)
  `(integer 0 ,(if (eq width '*)
		   width
		   (- (expt 2 width) 1))))

(deftype-w pathname ()
  'physical-pathname)

