
(defun make-cl-library (&optional (*config* (lib-config))
				  &rest options)
  (apply #'compile-cl *config* options)
  (link-library :cl
		;; :predicates-file "/u/wade/tmp/cl-preds.lisp"
		;; :data-file "/u/wade/tmp/cl-data.c"
		))

(defun make-compiler-library (&optional (*config* (lib-config)))
  (compile-compiler)
  (link-library :com :other-lib-names '(:cl)
		;; :predicates-file "/u/wade/tmp/com-preds.lisp"
		;; :data-file "/u/wade/tmp/com-data.c"
		))

(defun make-clx-library (&optional (*config* (lib-config)))
  (compile-clx)
  ;; Hack to fix gcc optimize bug
  (shell (format nil
		 "cd ~A/src/clx/; gcc -c -w -g -I~A/include patch.c"
		 *root-directory* *root-directory*))
  (link-library :clx :other-lib-names '(:cl)
		;; :predicates-file "/u/wade/tmp/clx-preds.lisp"
		;; :data-file "/u/wade/tmp/clx-data.c"
		))

(defun make-eval-bin (&optional (*config* (bin-config)))
  (comf "../main/eval")
  (link-executable "../main/eval"
		   ;; :data-file "/u/wade/tmp/eval-data.c"
		   ;; :predicates-file "/u/wade/tmp/eval-preds.c"
		   :main-function 'lisp::lmain
		   :output "../../bin/eval"))

(defun make-development-bin (&optional (*config* (bin-config)))
  (comf "../main/wcl")
  (link-executable "../main/wcl"
		   :output "../../bin/wcl"
		   :lib-names '(:cl :com)
		   :main-function 'lisp::lmain))

(defun make-clx-bin (&optional (*config* (bin-config)))
  (comf "../main/clx")
  (link-executable "../main/clx"
		   :output "../../bin/clx"
		   :lib-names '(:cl :com :clx)
		   :main-function 'lisp::lmain))

(defun make-hello-bin ()
  (comf "../../test/hello")
  (link-executable "../../test/hello"
		   :main-function 'lisp::lmain))

;;; Decl files that must be done first and then repeated for cross-compile.
;;; Bletch...
(defparameter *pre-decl-files*
  '("../cl/decls/constants"
    "../cl/decls/defstruct"
    "../cl/decls/foreign"))

;;; The ordering of these files is important!
(defparameter *decl-files*
  '("../cl/decls/constants"
    "../cl/decls/hash"
    "../cl/decls/macros"  ; check emit stuff here
    "../cl/decls/destructuring-bind"
    "../cl/decls/cl-macros"
    "../cl/decls/loop"
    "../cl/decls/defstruct"
    "../cl/decls/foreign"
    "../cl/decls/cl-types"
    "../cl/decls/bq"
    "../cl/decls/last"
    "../cl/decls/condition"))

(defparameter *function-files*
  '("../cl/functions/arrays.lisp"
    "../cl/functions/backquote.lisp"
    "../cl/functions/characters.lisp"
    "../cl/functions/cross-functions.lisp"
    "../cl/functions/cross-macros.lisp"
    "../cl/functions/defstruct.lisp"
    "../cl/functions/eval.lisp"
    "../cl/functions/files.lisp"
    "../cl/functions/format.lisp"
    "../cl/functions/hash.lisp"
    "../cl/functions/initialize-format.lisp"
    "../cl/functions/list.lisp"
    "../cl/functions/loop.lisp"
    "../cl/functions/low-io.lisp"
    "../cl/functions/macro-support.lisp"
    "../cl/functions/math.lisp"
    "../cl/functions/misc.lisp"
    "../cl/functions/packages.lisp"
    "../cl/functions/print.lisp"
    "../cl/functions/reader.lisp"
    "../cl/functions/sequences.lisp"
    "../cl/functions/strings.lisp"
    "../cl/functions/symbols.lisp"
    "../cl/functions/time.lisp"
    "../cl/functions/types.lisp"
    "../cl/functions/condition.lisp"))

(defparameter  *cl-other-files*
  '("../cl/c-src/apply.c"
    "../cl/c-src/arith.c"
    "../cl/c-src/array.c"
    "../cl/c-src/cache-flush.c"
    "../cl/c-src/chars.c"
    "../cl/c-src/closure.c"
    "../cl/c-src/dynamic.c"
    "../cl/c-src/error.c"
    "../cl/c-src/eval-code.c"
    "../cl/c-src/funcall.c"
    "../cl/c-src/generic-loader.c"
    "../cl/c-src/init.c"
    "../cl/c-src/integer-arith.c"
    "../cl/c-src/interrupts.c"
    "../cl/c-src/io.c"
    "../cl/c-src/memory.c"
    "../cl/c-src/misc.c"
    "../cl/c-src/socket.c"
    "../cl/c-src/loader.c"
    "../cl/c-src/time.c"
    "../cl/c-src/bignum/KerN.c"
    "../cl/c-src/bignum/bnCmp.c"
    "../cl/c-src/bignum/bnDivide.c"
    "../cl/c-src/bignum/bnInit.c"
    "../cl/c-src/bignum/bnMult.c"
    "../cl/c-src/bignum/bz.c"))

(defparameter *clx-files*
  '("../clx/package"
    "../clx/depdefs"
    "../clx/clx"
    "../clx/dependent"		
    "../clx/macros"
    "../clx/bufmac"
    "../clx/buffer"
    "../clx/display"
    "../clx/gcontext"
    "../clx/input1"
    "../clx/input2"	
    "../clx/requests1"			
    "../clx/requests2"			
    "../clx/fonts"			
    "../clx/graphics"
    "../clx/text"
    "../clx/attributes"			
    "../clx/translate"
    "../clx/keysyms"			
    "../clx/manager"			
    "../clx/image"
    "../clx/resource"
    "../clx/patch"))

(defparameter *compiler-files*
  '("../compiler/common/globals"
    "../compiler/common/macros"
    "../compiler/common/configurations"
    "../compiler/common/function-info"
    "../compiler/common/type-dispatch"
    "../compiler/common/line-numbers"
    "../compiler/common/analyze"
    "../compiler/common/beta"
    "../compiler/common/tree-nsubst"
    "../compiler/common/improve"
    "../compiler/common/name-mangle"
    "../compiler/common/emit-code"
    "../compiler/common/emit-data"
    "../compiler/common/compiler-init"
    "../compiler/common/compile"
    "../compiler/common/symbol-table"
    "../compiler/common/library"
    "../compiler/common/link"))

(defun compile-cl (&optional (*config* (lib-config))
			     &key
			     (pre? t)
			     (rtl? t)
			     (decls? t))
  (initialize-compiler)			; setup primary function info
  (let ((*pic?* t))
    (compile-src-files *pre-decl-files* pre? nil)
    (compile-src-files *decl-files* decls? nil)
    (compile-src-files *function-files* rtl?)
    (shell (format nil
		   "cd ~A/src/cl/c-src/; make clean; make ~A CC=~S AS=~S"
		   *root-directory*
		   (if (solaris?) "solaris"  "sunos4")
		   (basic-cc-string)
		   (if (solaris?) "as -K PIC -T" "as -k")))))

(defun compile-compiler (&optional (*config* (lib-config)))
  (let ((*features* (cons :native-wcl *features*))
	(*pic?* t))
    (compile-src-files *compiler-files* t))
  t)

(defun compile-clx (&optional (*config* (lib-config)))
  (unless (member :native-wcl *features*)
    (error "CLX can only be natively compiled"))
  ;; Load some declarations
  (load "../clx/package.lisp")
  (load "../clx/depdefs.lisp")
  (load "../clx/clx.lisp")
  (load "../clx/dependent.lisp")
  (load "../clx/macros.lisp")
  (load "../clx/bufmac.lisp")
  (initialize-compiler)
  (let ((*pic?* t))
    (compile-src-files *clx-files* t)
    t))

(defun compile-src-files (files force? &optional load?)
  (dolist (f files)
    (let ((pathname (pathname f)))
      (when (or force? (source-newer? pathname))
	(comf pathname)
	(terpri)
	(when load? (load (merge-pathnames ".o" pathname)))))))

(defun source-newer? (f)
  (newer-file? (merge-pathnames ".lisp" f) (merge-pathnames ".o" f)))

(defun newer-file? (f1 f2)
  (and (probe-file f1)
       (probe-file f2)
       (> (file-write-date f1) (file-write-date f2))))

(define-library :cl 2.2
		:lisp-files (append *decl-files* *function-files*)
		:other-object-files *cl-other-files*)

(define-library :clx 5.0
		:lisp-files *clx-files*)

(define-library :com 2.2
		:lisp-files *compiler-files*)

(defun lib-config ()
  (symbol-value (installation-parameter "LIBRARY_CONFIG")))

(defun bin-config ()
  (symbol-value (installation-parameter "BIN_CONFIG")))



