/*  (C) Copyright 1990-1994 by Wade L. Hennessey. All rights reserved. */

#include "lisp.h"

#ifdef ansi_fixed_args
extern LP ubf_handler(ARGC argc, ...);
#else
extern LP ubf_handler();
#endif

PROCEDURE ubf_procedure = {TYPE_PROCEDURE, (LP) ubf_handler};
UBV ubv_marker= {TYPE_UBV, 0};

/*
runtime for VALUES (written in Lisp for now)
bletch - this is ansi/non-ansi dependent
LP p_lsp_VALUES(ARGC argc, ...)
{
  if (MV_HOLDER_P(argc)) {
    get each arg and put it into the mv struct;
  } else {
    if (argc == 0) {
      return(NIL);
    } else {
      return(first_var_arg);
    }
  }
}

*/

/* Could have written this one in Lisp more easily. */
LP lookup_keyword(kwd, l)
     LP kwd; LP l;
{
  LP rest;
  LP next;

  rest = l;
  while (rest != NIL) {
    next = LDREF(rest,CONS,cdr);
    if (LDREF(rest,CONS,car) == kwd) {
      if (next == NIL) {
	printf("Missing keyword argument\n");
	lisp_debug();
      } else {
	return(LDREF(next,CONS,car));
      }
    } else {
      rest = LDREF(next,CONS,cdr);
    }
  }
  return((LP) UBK_MARKER);
}

LP make_symbol(name,hashcode)
     LP name;
     LP hashcode;
{
  LP result;
  SYMBOL *sym;

  result = alloc_words((sizeof(SYMBOL)/4 - 1),TYPE_SYMBOL);
  sym = (SYMBOL *) (result - 5);
  sym->self_link = result;
  sym->name = name;
  sym->value = UBV_MARKER;
  sym->package = NIL;
  sym->plist = NIL;
  sym->function = LREF(ubf_procedure);
  sym->hashcode = hashcode;
  sym->flags = 0;
  return(result);
}

LP new_foreign_ptr(type, ptr)
     LP type;
     LP ptr;
{
  LP  result;
  FOREIGN_POINTER *fptr;

  if (ptr == 0) {
    return(0);			/* Make C Null pointer = Lisp 0 */
  } else {
    result = alloc_words((sizeof(FOREIGN_POINTER)/4 - 1),TYPE_FOREIGN_PTR);
    fptr = (FOREIGN_POINTER *) (result - 5);
    fptr->pointer = ptr;
    fptr->type = type;
    return(result);
  }
}


#include <sys/utsname.h>

int getosversion(char *name, int namelen)
{
  struct utsname sysinfo;
  int status;

  uname(&sysinfo);
  status = strcpy(name,&(sysinfo.release[0]));
  return(status);
}

#ifdef SYSV

#include <unistd.h>

/* replace  getrusage stuff with times? */

int gethostname(char *name, int namelen)
{
  struct utsname sysinfo;
  int status;

  uname(&sysinfo);
  status = strcpy(name,&(sysinfo.nodename[0]));
  return(status);
}

int getwd (char *path)
{
  int status;
  
  /* cheap hack...get this right */
  getcwd(path, 256); 
}

/* see rand, srand, and drand for solaris */
void initstate (int seed, char *data, int len)
{
  /* printf("HEY! write initstate"); */
}

int random(void)
{
  printf("HEY! write random");
  return(0);
}

void setstate (char *data)
{
  printf("HEY! write setstate");
}

/* no solaris equiv. Use high-res timer facilty, or just sleep */
void usleep (int useconds)
{
  printf("HEY! write usleep");
}

#endif
