
#ifdef UNIX
void InitView() {};
#endif
#ifdef MSDOS
#include <stdio.h>
#include <math.h>
#include "cells.h"
#define DIVIDE_BY_ZERO 99999.9

#define NUMOFFIELDS 8
typedef struct { float x; float y; float z; } coord_3d ;
typedef struct { float x; float y; } coord_2d ;
typedef struct { int x; int y; } pixel_2d;
typedef struct { pixel_2d alpha; pixel_2d beta; } scrvec_2d;
typedef struct { coord_3d alpha; coord_3d beta; } vector_3d;
typedef int pixel;
typedef float ordinate;
#define pi (3.1415926535)
#define deg_to_rad ( (2*pi)/360 )

typedef float degrees;

typedef struct {
	coord_3d shift;
	degrees xangle;
	degrees yangle;
	degrees zangle;
	} orientation;

typedef struct {
	ordinate focal_length;
	float ypixperm;	/* Pixels per metre */
	float xpixperm;	/* Pixels per metre */
	pixel offx;
	pixel offy; 
	float wheelbase;	/*
				 * notional distance between camera and rear
				 * axle of vehicle, used in curved segments
				 */
	} calibration;


double sinla, /* SinLastAngle */ SinLastResult;
double cosla, /* CosLastAngle */ CosLastResult;
#define fpequals(a,b) (a-b<1.0E-10)

#define VPLANE (0.3)  /* 30cm don't show line closer than this */

/*
int matherr(x)
struct exception *x;
{
char *str;

switch( x->type) {
case DOMAIN : str = "DOMAIN"; break;
case SING : str = "SING"; break;
case OVERFLOW : str = "OVERFLOW"; break;
case PLOSS : str = "PLOSS"; break;
case TLOSS : str = "TLOSS"; break;
case UNDERFLOW : str = "UNDERFLOW"; break;

}
printf("matherr: %s name %s args %g %g ret %g\n", 
				str, x->name, x->arg1, x->arg2, x->retval);
return(1);
} 
*/

void v_init_trig()
{
	SinLastResult = sin( (double) (sinla = 0));
	CosLastResult = cos( (double) (cosla = 0));
}

#ifdef ANSI
double v_sin( degrees *angle)
#else
double v_sin(angle)
degrees *angle;
#endif
{

	if( *angle != sinla) {
		sinla= *angle;
		SinLastResult = sin( (double) (*angle)*deg_to_rad);
	}

#ifdef DEBUGTRIG
printf("v_sin: angle %g sin %g\n", sinla*deg_to_rad, SinLastResult);
#endif

	return( SinLastResult);
	
}
#ifdef ANSI
double v_cos(degrees *angle)
#else
double v_cos(angle)
degrees *angle;
#endif
{

	if( *angle != cosla) {
		cosla= *angle;
		CosLastResult = cos( (*angle)*deg_to_rad);
	}
#ifdef DEBUGTRIG
printf("v_cos: angle %g cos %g\n", cosla*deg_to_rad, CosLastResult);
#endif
	return( CosLastResult);
	
}

#ifdef ANSI
void v_topix( coord_2d *view_plane,
pixel_2d *screen_coord,
float *xpixperm, float *ypixperm,
pixel offsetx, pixel offsety)
#else
v_topix(view_plane, screen_coord, xpixperm, ypixperm, offsetx, offsety)
coord_2d *view_plane;
pixel_2d *screen_coord;
float *xpixperm, *ypixperm;
pixel offsetx, offsety;
#endif
{
	screen_coord->x = view_plane->x * (*xpixperm) + offsetx;
	screen_coord->y = view_plane->y * (*ypixperm) + offsety;
}
#ifdef ANSI
v_rot_single( ordinate *old_x, 
	ordinate *old_y, 
	ordinate *new_x, 
	ordinate *new_y,
	degrees *angle)
#else
v_rot_single(old_x, old_y, new_x, new_y, angle)
ordinate *old_x, *old_y, *new_x, *new_y;
degrees *angle;
#endif
{
ordinate nx, ny;

	nx = (*old_x)*v_cos(angle) - (*old_y)*v_sin(angle);
	ny = (*old_x)*v_sin(angle) + (*old_y)*v_cos(angle);
	*new_x = nx;
	*new_y = ny;

#ifdef DEBUG
printf("v_rot_single: old_x %f y %f new_x %f y %f angle %f\n",
	old_x, old_y, *new_x, *new_y, angle);
#endif

	return;

}
#ifdef ANSI
v_rotate( coord_3d *old, coord_3d *new,
degrees *xangle, degrees *yangle, degrees *zangle)
#else
v_rotate(old, new, xangle, yangle, zangle)
coord_3d *old, *new;
degrees *xangle, *yangle, *zangle;
#endif
{
#ifdef DEBUG
printf("v_rotate: old->x %f ->y %f ->z %f xangle %f yangle %f zangle %f\n",
		old->x, old->y, old->z, xangle, yangle, zangle);
#endif

	v_rot_single(&(old->x), &(old->y), &(new->x), &(new->y), zangle);
	new->z = old->z;
	v_rot_single(&(new->y), &(new->z), &(new->y), &(new->z), xangle);
	v_rot_single(&(new->z), &(new->x), &(new->z), &(new->x), yangle);
	return;
}
#ifdef ANSI
v_shift(coord_3d *view, coord_3d *object, coord_3d *new)
#else
v_shift(view, object, new )
coord_3d *view, *object, *new;
#endif
{
	new->x = object->x - view->x;
	new->y = object->y - view->y;
	new->z = object->z - view->z;
	return;
}
#ifdef ANSI
void v_perspective( coord_3d *object,
	coord_2d *view,
	ordinate *focal_length )
#else
v_perspective(object, view, focal_length)
coord_3d *object;
coord_2d *view;
ordinate *focal_length ;
#endif
{
#ifdef DEBUG
printf("v_perspective: focal_length %f\n", focal_length);
printf("v_perspective: object->x %f y %f z %f\n", object->x, object->y, object->z);
#endif
	if ( !fpequals( object->z , 0.0 ) ) {

		view->x = ((*focal_length) * object->x)/(object->z );
		view->y = ((*focal_length) * object->y)/(object->z );
	}
	else {
		view->x = DIVIDE_BY_ZERO;
		view->y = DIVIDE_BY_ZERO;
	}


#ifdef DEBUG
printf("v_perspective: view->x %f y %f \n", view->x, view->y);
#endif
	
}

calibration camera;
orientation posi;

/*
 (setview 
	( camera position x y z )
	( camera angle x y z )
	focal length
	pixels per metre y
	pixels per meter x
	camer offset in pixels x
	camer offset in pixels y
	camer offset from centre line
)
*/
#ifdef ANSI
EXP bsetpos(EXP args)
#else
EXP bsetpos(args)
EXP args;
#endif
{
	EXP tmp = car(args);

	posi.shift.x = cflor(car(tmp)) ;
	tmp = cdr(tmp);
	posi.shift.y = cflor(car(tmp)) ;
	tmp = cdr(tmp);
	posi.shift.z = cflor(car(tmp)) ;

	tmp = car(cdr(args));
	posi.xangle = cflor(car(tmp)) ;
	tmp = cdr(tmp);
	posi.yangle = cflor(car(tmp)) ;
	tmp = cdr(tmp);
	posi.zangle = cflor(car(tmp)) ;

	tmp = cdr(cdr(args));

	camera.focal_length = cflor(car(tmp));
	tmp = cdr(tmp);
	camera.xpixperm 	= cflor(car(tmp));	/* Pixels per metre */
	tmp = cdr(tmp);
	camera.ypixperm 	= cflor(car(tmp));	/* Pixels per metre */
	tmp = cdr(tmp);
	camera.offx 		= cflor(car(tmp));
	tmp = cdr(tmp);
	camera.offy 		= cflor(car(tmp));
	tmp = cdr(tmp);
	camera.wheelbase 	= cflor(car(tmp));

	return(args);
}
#ifdef ANSI
void v_view( coord_3d *object,
	pixel_2d *screen,
	calibration *camera,
	orientation *posi)
#else
v_view(object, screen, camera, posi)
coord_3d *object;
pixel_2d *screen;
calibration *camera;
orientation *posi;
#endif
{
coord_3d view1 ,view2;
coord_2d plane;

#ifdef DEBUGVIEW
printf("v_view: object x %f y %f z %f\n", object->x, object->y, object->z);
#endif

/*
 * First Step: Shift Object Axes to View Axes
 */

	v_shift(&posi->shift, object, &view1);
#ifdef DEBUGVIEW
printf("v_view: shifted x %f y %f z %f\n", view1.x, view1.y, view1.z);
#endif
/*
 * Second Step: Rotate Object Axes to Match Camera Angles
 */
	v_rotate( &view1, &view2, &(posi->xangle), &(posi->yangle),
		  &(posi->zangle));

#ifdef DEBUGVIEW
printf("v_view: rotated x %f y %f z %f\n", view2.x, view2.y, view2.z);
#endif

/*
 * (Object is now mapped intp the viewer's frame of reference)
 */
/*
 * Third Step: Perspective Projection onto the view plane.
 */
	v_perspective(&view2, &plane, &(camera->focal_length));

#ifdef DEBUGVIEW
printf("v_view: in 2d x %f y %f \n", plane.x, plane.y);
#endif
/*
 * Fourth Step: Correct for Camera Distortions
 */
/*
 * Fifth Step: Convert to Screen Coordinates
 */


	v_topix( &plane, screen, &(camera->xpixperm),
		 &(camera->ypixperm), camera->offx, camera->offy); 

#ifdef DEBUGVIEW
printf("v_view: onscreen x %d y %d\n", screen->x, screen->y);
#endif
}



#ifdef ANSI
int v_front( float vplane, coord_3d *p1, coord_3d *p2)
#else
int v_front( vplane, p1, p2)
float vplane;
coord_3d *p1; coord_3d *p2;
#endif
{
float my, by, mx, bx;


	if( p1->z < vplane  && p2->z < vplane )
		return( -1 );
	if( p1->z < vplane  || p2->z < vplane ) {
		if( fpequals(p1->z, p2->z) ) {
			my = 1e-10;
		}
		else {
			my = (p1->y -p2->y)/(p1->z - p2->z);	/* slope */ 
		}

		by = p1->y - my*(p1->z);

		if( fpequals(p1->z, p2->z) )
			mx = 1e-10;
		else
			mx = (p1->x -p2->x)/(p1->z - p2->z);	/* slope */ 

		bx = p1->x - mx*(p1->z);

		if( p1->z < vplane ){
			p1->x = mx*vplane + bx;
			p1->y = my*vplane + by;
			p1->z = vplane;
		}
		else  {
			p2->x = mx*vplane + bx;
			p2->y = my*vplane + by;
			p2->z = vplane;
		}
		return(0);

	}
	else return( 0 );
	
}


#ifdef ANSI
int v_lineview( coord_3d *p1, coord_3d *p2,
	pixel_2d *s1, pixel_2d *s2,
	calibration *camera,
	orientation *posi)
#else
v_lineview(p1, p2, s1, s2, camera, posi)
coord_3d *p1, *p2;
pixel_2d *s1, *s2;
calibration *camera;
orientation *posi;
#endif
{
coord_3d view1 ,view2, rot1, rot2;
coord_2d plane1, plane2;

/*
 * First Step: Shift Object Axes to View Axes
 */

	v_shift(&posi->shift, p1, &view1);
	v_shift(&posi->shift, p2, &view2);
/*
 * Second Step: Rotate Object Axes to Match Camera Angles
 */
	v_rotate( &view1, &rot1, &(posi->xangle), &(posi->yangle),
		  &(posi->zangle));
	v_rotate( &view2, &rot2, &(posi->xangle), &(posi->yangle),
		  &(posi->zangle));

/*
 * (Object is now mapped intp the viewer's frame of reference)
 */
/*
 * Now clip the line to be in front of the camera
 */
	if( v_front(VPLANE, &rot1 , &rot2) < 0)
		return(-1);	/* if entire line is behind do nothing */
/*
 * Third Step: Perspective Projection onto the view plane.
 */
	v_perspective(&rot1, &plane1, &(camera->focal_length));
	v_perspective(&rot2, &plane2, &(camera->focal_length));

/*
 * Fourth Step: Convert to Screen Coordinates
 */

	v_topix( &plane1, s1, &(camera->xpixperm),
		 &(camera->ypixperm), camera->offx, camera->offy); 
	v_topix( &plane2, s2, &(camera->xpixperm),
		 &(camera->ypixperm), camera->offx, camera->offy);

	return(0);

}
/*
 (view (object point x y z)) ==> (x y)
*/
#ifdef ANSI
EXP bview(EXP args)
#else
EXP bview(args)
EXP args;
#endif
{
coord_3d object;
pixel_2d screen;

	EXP tmp = car(args);
	object.x = cflor(car(tmp));
	tmp = cdr(tmp);
	object.y = cflor(car(tmp));
	tmp = cdr(tmp);
	object.z = cflor(car(tmp));

	v_view(&object, &screen, &camera, &posi);

	return( cons( newicell((int)screen.x),
				  cons(newicell((int)screen.y), NIL)
				)
	);
}
#ifdef ANSI
EXP blineview(EXP args)
#else
EXP blineview(args)
EXP args;
#endif
{
coord_3d p1, p2;
pixel_2d s1, s2;

	EXP tmp = car(args);
	p1.x = cflor(car(tmp));
	tmp = cdr(tmp);
	p1.y = cflor(car(tmp));
	tmp = cdr(tmp);
	p1.z = cflor(car(tmp));

    tmp =  car(cdr(args));
	p2.x = cflor(car(tmp));
    tmp = cdr(tmp);
	p2.y = cflor(car(tmp));
    tmp = cdr(tmp);
	p2.z = cflor(car(tmp));

	if( v_lineview(&p1, &p2, &s1, &s2, &camera, &posi) < 0)
			return(NIL); /* line is behind viewer */

	return( cons(newicell((int)s1.x), cons(newicell((int)s1.y),
		cons(newicell((int)s2.x), cons(newicell((int)s2.y),NIL)))));
}
extern EXP bpline(EXP args);
EXP bshow( EXP args)
{
EXP lines = car(args);
EXP both2d = NIL;

	lwhile( lines ) {
		both2d = reference(blineview(car(lines)));
		if( both2d != NIL ) {
			bpline( both2d);;
			purge(both2d);
		}
		lines = cdr(lines);
	}
	return(T);
}
void InitView()
{
	v_init_trig();
	
	set(lookup("setview"), 	newfcell(bsetpos));
	set(lookup("view"),	newfcell(bview));
	set(lookup("lineview"),	newfcell(blineview));
	set(lookup("show"),	newfcell(bshow));
}


#endif

