#include <stdlib.h>
#include <stdio.h>
#include "cells.h"
#include <time.h>
#include <limits.h>
#include <setjmp.h>
#include <errno.h>
#include <string.h>
#ifdef MSDOS
#include <process.h>
#include <time.h>
#include <signal.h>
#include <dir.h>
#include <dos.h>
#endif
#ifdef LASER
#include <osbind.h>
typedef union {
	struct {
		unsigned day : 5;
		unsigned month :4 ;
		unsigned year : 7;
		unsigned seconds :5 ;
		unsigned minutes : 6;
		unsigned hours : 5;
	} part;
	long realtime;
} time;
time mytime;
#endif
extern int errno;
extern void *malloc(size_t);


LISPFUNC(egettime)
{
	args = args;     /* ARGSUSED */

#ifdef LASER
	mytime.realtime = Gettime(); 
	return(cons(newicell((int)mytime.part.hours),
	cons(newicell((int)mytime.part.minutes),
	cons(newicell((int)mytime.part.seconds*2),
	cons(newicell((int)mytime.part.day),
	cons(newicell((int)mytime.part.month),
	cons(newicell((int)mytime.part.year + 80), NIL)))))));
#else
	/* ANSI */
	{  time_t now;
		struct tm *gmt_now;
		daylight = 0;
		time(&now);
		gmt_now = localtime(&now);

	return(
	cons(newicell((int)gmt_now->tm_sec),
	cons(newicell((int)gmt_now->tm_min),
	cons(newicell((int)gmt_now->tm_hour),
	cons(newicell((int)gmt_now->tm_mday),
	cons(newicell((int)gmt_now->tm_mon+1),
	cons(newicell((int)gmt_now->tm_year),
	cons(newicell((int)(gmt_now->tm_wday+6)%7),
	cons(NIL,
	NIL)))))))));
	}
#endif
}
LISPFUNC(egetUtime)
{
	args = args;     /* ARGSUSED */

#ifdef LASER
#else
	/* ANSI */
	{
	time_t now = time((time_t *)NULL) ;
		return(newflocell((float) now ));
	}
#endif
}
static time_t last_time;

LISPFUNC(egetdifftime)
{
	args = args;     /* ARGSUSED */

#ifdef LASER
#else
	/* ANSI */
	{
	time_t now = time((time_t *)NULL) ;
	int diff = now - last_time;

		last_time = now;
		return(newicell(diff));
	}
#endif
}
LISPFUNC(eatoi)
{
	return(newicell(atoi(csr(car(args)))));
}
LISPFUNC(eitoa)
{
char str[40];

	sprintf(str,"%d", cir(car(args)) );
	return(newscell(str));
}
LISPFUNC(efloat_to_ascii)
{
char format[20];
char str[40];

	int width = cir(nth(1,args));
	int precision = cir(nth(2,args)) % 40;
	strcpy(format, "%g");
	if( nth(3,args) == T)
		sprintf(format,"%%0%d\.%df", width, precision);
	else
		sprintf(format,"%%%d\.%df", width, precision);
    	
	sprintf(str, format , cflor(car(args)) );
	return(newbigstring(str));
}

LISPFUNC(bsystem)	/* Keep lint happy by always having an extern visible */
{

#ifdef UNIX
#define NARGS 20
char *pathname, *argv[NARGS+1];
int c = 0;
int pid = 0;

	pathname = malloc(c_lenstr(car(args)));
	c_tostr(pathname ,car(args));

	while( args != NIL && c < NARGS ) {
		argv[c] =  malloc(c_lenstr(car(args)));
		c_tostr(argv[c++] ,car(args));
		args = cdr(args);
	}
	argv[c] = NULL;
	if( (pid = fork()) == 0) { /* child */
		execvp(pathname,argv);
	}
	else {	/* parent */
	int status;
		if( pid == -1) {
			return(newicell(errno));
		}
		else {
			wait(&status);
			for(c -= 1; c >0 ; c--)
				free((void *)argv[c]);
			free((void *)pathname);
			return(newicell(status));
		}
	}
#else
#define NARGS 20
char buffer[80],  *pathname, *argv[NARGS+1];
int c = 0, retval;

	c_tostr(buffer ,car(args));
	pathname = malloc((size_t)strlen(buffer));
	strcpy(pathname, (const char *)buffer);

	while( args != NIL && c < NARGS ) {
		c_tostr(buffer ,car(args));
		argv[c] =  malloc((size_t)strlen(buffer));
		strcpy(argv[c++], (const char *)buffer);
		args = cdr(args);
	}
	argv[c] = NULL;
#ifdef MSDOS
	retval = spawnvp((int)0,pathname,argv);
#else
	retval = execv(pathname,argv);
#endif
	for(c -= 1; c >0 ; c--)
		free((void *)argv[c]);
	return(newicell(retval));

#endif
}

LISPFUNC(bstop)
{
	lif(lnot(null(args)))
		exit(cir(car(args)));
	else
		exit((int)0);
    return(NIL);
}
LISPFUNC(bgetenv)
{
char *envar;
char buffer[80];

	c_tostr(buffer ,car(args));

	envar = getenv(buffer);
	if( envar == (char *)NULL) {
		return(NIL);
	}
	else {
		return(newbigstring(envar));
        }
}

#ifdef MSDOS
LISPFUNC(bchdir)
{
char buffer[MAXPATH];

EXP retval;

	/* get the old directory */
	getcwd(buffer, MAXPATH);
	retval = newbigstring(buffer);

	c_tostr(buffer ,car(args));
	if( chdir(buffer) != 0) {
		return(NIL);
	}
	else {
		return(retval);
        }
}
LISPFUNC(bdir)
{
char buffer[MAXPATH];
struct ffblk ffblk;
int done;
EXP retval = NIL;

   c_tostr(buffer ,car(args));
   done = findfirst(buffer,&ffblk, 0xff);
   while (!done) {
      retval = cons( newbigstring(ffblk.ff_name), retval);
      done = findnext(&ffblk);
   }

   return(retval);

}
#endif
LISPFUNC(bopen)
{
FILE *retval;
char name[80],*modus;
EXP mode = NIL;

	c_tostr(name, car(args));
	lif( null(cdr(args))) {
		modus = "r";
	}
	else {
		mode = nth(2, args);
		lif(equal(mode,lookup(":input"))) {
			modus = "r";
		}
		else lif(equal(mode,lookup(":output"))) {
			modus = "w";
		}
		else {
			c_error("is not option for OPEN",mode);
		}
	}
	retval = fopen(name,modus);
#ifndef LINT
	/* lint complains about "possible pointer alignment problem, o CAST" */
	if( retval == (FILE *)NULL) {
		c_error("could not be opened", car(args));
		return(NIL);
	}
	else
#endif
		return(newocell(retval));
}
EXP jmpresult = NIL;

extern EXP evprogn(EXP);
LISPFUNC(bcatch)
{
jmp_buf jumper;
EXP tag, oldtag, retval;

	tag = eval(car(args));
        oldtag = reference(value(tag));
	set( tag , newvoidcell((void *)&jumper));
	if (setjmp(jumper) != 0) {
        	dereference(oldtag);
		set(tag, oldtag);
		return(jmpresult);
	}
	retval = evprogn(cdr(args));
        dereference(oldtag);
	set(tag, oldtag);
	return(retval);

}
LISPFUNC(bthrow)
{
EXP tag = eval(car(args));

	jmpresult = car(cdr(args));
	longjmp(cvoidr(tag), (int) 0);
        return(NIL); /* never executed */

}
LISPFUNC(bstrerrno)
{
	args = args;     /* ARGSUSED */
	return(newbigstring(strerror(errno)));
}
LISPFUNC(berrno)
{
	args = args;     /* ARGSUSED */
	return(newicell(errno));
}
char *InitOS()
{
   char *envar;

#ifdef LASER
#else
#ifdef MSDOS
	putenv("TZ=GMT00");
#endif
	tzset();

	/* ANSI */
	last_time = time((time_t *)NULL) ;
#endif

   set(lookup("strerrno"), newfcell(bstrerrno) );
   set(lookup("errno"), newfcell(berrno) );
   set(lookup("open"), newfcell(bopen) );
   set( lookup("get-universal-time"), newfcell(egetUtime));
   set( lookup("get-diff-time"), newfcell(egetdifftime));
   set( lookup("get-decoded-time"), newfcell(egettime));
   set( lookup("atoi"), newfcell(eatoi));
   set( lookup("itoa"), newfcell(eitoa));	
   set( lookup("ftoa"), newfcell(efloat_to_ascii));
   set( lookup("system"), newfcell(bsystem));	
   set( lookup("exit"), newfcell(bstop));	
   set( lookup("getenv"), newfcell(bgetenv));

   set( lookup("catch"), newffcell(bcatch));
   set( lookup("throw"), newfcell(bthrow));
#ifdef MSDOS
   set( lookup("directory"), newfcell(bdir));
   set( lookup("chdir"), newfcell(bchdir));
#endif

   set(lookup(":direction"), lookup(":direction") );
   set(lookup(":input"), lookup(":input") );
   set(lookup(":output"), lookup(":output") );

	envar = getenv("LISPINIT");
	if( envar == (char *)NULL) {
   		return("init.lsp");
	}
	else {
		return(envar);
        }

}

 
