#include <stdio.h>
#include <string.h>
#include <values.h>
#include "cells.h"

extern int trace_on;

extern EXP UNBOUND;
extern EXP PRINTNAME;

EXP oblist = NIL;
EXP question = NIL;

EXP hashtab[HASHMODULO];
/*
 * Function hand-builds a symbol, for bootstrap purposes.
 */
void new_constant(char *str, EXP acell, EXP initial)
{
		acell->ztype = CONSTANT;
		acell->zcount = MAXINT; /* i.e. very big ! */
		acell->reg.zpair.zcar = initial;
		acell->reg.zpair.zcdr = reference(cons(cons(PRINTNAME,newscell(str)),NIL));
}
/******************************************************************************
 *
 * Basic property list routines.
 *
 */
EXP eputprop(EXP symbol, EXP val, EXP prop)
{
EXP proplist = NIL ,var = NIL,oldhead = NIL,props = NIL;

  /*	lif( lor( null(symbol) , null(prop)) )
		return(NIL);            */

	oldhead = zprops(symbol);
	proplist = zprops(symbol);
	var = symbol;

	val = reference( val);	/* protection */
	while(proplist != NIL) {
		if( prop == car(car(proplist)) ) {
			/* Found the property, so replace the value */
			purge( cdr(car(proplist)));
			car(proplist)->reg.zpair.zcdr = val ;
			return( cdr(car(proplist)));
		}
		proplist = cdr(proplist);
	}
	/* property not found so add it to the head of the list */
		
	dereference(oldhead);
	props = cons(cons(prop,val),oldhead);
	var->reg.zpair.zcdr = reference(props) ;
	dereference(val);
	return( val );
	
}
EXP bputprop(EXP args) 
{
	return(eputprop(car(args),car(cdr(cdr(args))),car(cdr(args))));
}
EXP getprop(EXP symbol, EXP prop)
{
EXP proplist = NIL;

   /*	if( symbol == NIL || prop == NIL)
		return(NIL);             */
	proplist = zprops(symbol);

	while(proplist != NIL) {
		if( prop == car(car(proplist)) ) {
			/* Found the property, so return the value */
			return( cdr(car(proplist)));
		}
		proplist = cdr(proplist);
	}
	/* property not found so return NIL */
	return( NIL);
}
EXP bgetprop(EXP args)
{
	return(getprop(car(args),car(cdr(args))));
}
/******************************************************************
 *
 *	Function to completely remove a property from the 
 *	property list of a symbol.
 */
EXP remprop(EXP symbol, EXP prop)
{
EXP result = NIL ,prev = NIL;
EXP plst = zprops(symbol);	/* point to plist of the symbol */

	lwhile( plst ) {
	if( car(car(plst)) == prop) {
			if( prev == NIL ) { 	/* head of list */
				symbol->reg.zpair.zcdr = cdr(plst);
			}
			else {
				prev->reg.zpair.zcdr = cdr(plst);
			}
			plst->reg.zpair.zcdr = NIL;
			result = reference(cdr(car(plst)));
			purge(plst);
			dereference(result);
			return(result);
		}
		prev = plst;
		plst = cdr(plst);
	}
	return(NIL);
}
EXP bremprop(EXP args)
{
	return(remprop(car(args),car(cdr(args))));
}
/******************************************************************************
 *
 *
 *
 */
char *pname(EXP x)
{
	lif( land( lnot(null(x)) , idp(x))) {
		return(csr(getprop(x,PRINTNAME)));
	}
	else {
		serr("nil passed to pname");
		return((char *)NULL);
	}
}
EXP bplist(EXP args)
{
EXP symbol = NIL, result = NIL, tmp = NIL;

	lif( null(args) )
		return(NIL);

	symbol = car(args);
 /*	lif( null(symbol) )
		return(NIL);    */
   	result = NIL;
   	tmp = zprops(symbol);
   	while(tmp != NIL ) {
		result = cons( cdr(car(tmp)), result);
		result = cons( car(car(tmp)), result);
		tmp = cdr(tmp);
   	}
   return(result);

}
/******************************************************************************
 *
 *
 *
 */
int hashstr(char *str)
{
int i,retval,hashed = 0;

	i=0;
	while( str[i] != 0 && i <LEN_STRING-1 ) {
		hashed ^= str[i]; /* exclusive OR */
		i += 1;
	}
	retval = (hashed)%HASHMODULO ;
	return( retval );
}
int hashbstr(EXP x)
{
	EXP tmp = x;
	int val = 55;

	lwhile( lnot(null(tmp))) {
			val ^= hashstr(csr(tmp->reg.zpair.zcar));
			tmp = tmp->reg.zpair.zcdr;
	}
	return((val)%HASHMODULO);
}
EXP outsym(EXP args, EXP proforma);
EXP addsym(EXP args, EXP proforma);

EXP lookup(char *str)
{
EXP tmp, symname = NIL;

	if((int)strlen(str) < (int)LEN_STRING) {
		symname = reference(newscell(str));
	}
	else {
		symname = reference(newbigstring(str));
	}
	tmp = addsym(symname,symname);
    purge(symname);
	return(tmp);
}
EXP nameof(EXP x)
{
	lif( idp(x) ) {
		return(getprop(x,PRINTNAME));
	}
	else {
		serr("non-symbol passed to symbol-name");
		return(NIL);
	}
}
LISPFUNC(bsymval)
{
EXP ident = car(args);

   lif( idp(ident) ) {
	  if( zapval(ident ) != UNBOUND)
      	 return( zapval(ident) ); /* apval in car */
	   else {
		 c_error(":value: cannot value non-symbol",ident);
		return(NIL);
	  }
   }
   else {
	  c_error(":value: cannot value non-symbol",ident);
      return(NIL);
   }
}
LISPFUNC(bnameof)
{
	return(nameof(car(args)));
}
/*
 * 	Function to provide a hash number for an s-expression.
 */
int hashany(EXP x)
{
	lif( stringp(x) ) {
		return(hashstr(csr(x)));
	}
	else lif( bigstringp(x) ) {
		return(hashbstr(x));
	}
	else {
		return( hashanyaux(x) );
	}
}
int hashanyaux(EXP x)
{
int retval;

	lif( null(x) ) {
		retval = 0;
	}
	else lif( atom(x) ) {
    	retval = 1;
	}
	else {
		retval = 2*(hashanyaux(car(x)) + hashanyaux(cdr(x)));
	}
	return(retval%HASHMODULO) ;
}
LISPFUNC(bash)
{
	return(newicell(hashany(car(args))));
}
EXP newidcell(EXP print_name)
{
EXP symbol = NIL;

   symbol = cons(UNBOUND,NIL);
   symbol->ztype = IDENTIFYER;
   symbol->zcount = 0;
#ifndef LINT
	/* we don't use return so lint objects */
   eputprop(symbol, print_name, PRINTNAME);
#else
   print_name = print_name; /* for lint */
#endif
   return(symbol);
}
EXP outsym(EXP any, EXP proforma)
{
EXP symbol = NIL;
int bucket;

   /*
	* Just add the symbol, even if one is already present.
	*/

	bucket = hashany(proforma) ;
	symbol = newidcell(any);
   hashtab[bucket] = reference(cons(symbol,hashtab[bucket]));
   return(symbol);

}
void intern_sym(EXP symbol)
{
int bucket;

   /*
	* Add a symbol , created manually or not yet interned.
	*/

	bucket = hashany(nameof(symbol)) ;
   hashtab[bucket] = reference(cons(symbol,hashtab[bucket]));

}

LISPFUNC(boutsym)
{
EXP item = NIL, proforma = NIL;

		  item = car(args);
		  lif( null(cdr(args)) )
			proforma = item;
		  else
			proforma = car(cdr(args));
		  return(outsym(item, proforma));
}

EXP addsym(EXP any, EXP proforma)
{
EXP tmp = NIL, symbol = NIL;
int bucket;


	lif(stringp(any)) {
		if(strcmp(csr(any), "nil") == (int)0)  {
			return(NIL);
		}
    }
	lif( idp(any) )
		return(any);
	bucket =   hashany(proforma);
   tmp = hashtab[bucket];
   while(tmp != NIL ) {
		symbol = car(tmp);
		lif( equal(nameof(symbol),any)) {
		 /*
		  * The symbol is already in the table
		  */
		 return(symbol);
      }
   tmp = cdr(tmp);

   }
   /*
    * The symbol is not in the symbol table, so add it
    */
	return(outsym(any, proforma));
}

LISPFUNC(baddsym)
{
EXP item = NIL, proforma = NIL;

		  item = car(args);
		  lif( null(cdr(args)) )
			proforma = item;
		  else
			proforma = car(cdr(args));
		  return(addsym(item, proforma));
}
/*
% Function to compare two s-expressions
% returns t if there is a match.
% '? in the mask stands for any value
%
*/
EXP match(EXP mask, EXP y)
{
	lif( equal(mask, question) )
		return(T);
	else lif( equal( mask, y))
		return(T);
	else {
		lif( land(consp(mask) , consp(y)) ) {
			lif( land( match(car(mask), car(y)) , match(cdr(mask), cdr(y))))
				return(T);
			else
				return(NIL);
		}
		else
        	return(NIL);
	}

}
LISPFUNC(bmatch)
{
	return(match(car(args), car(cdr(args))));
}
EXP rdsym(EXP mask)
{
EXP tmp = NIL,symbol = NIL;
int bucket;

	lif( idp(mask) )  {
		mask = nameof(mask); /* because we want to compare raw names */
	}
	bucket =   hashany(mask) ;
   tmp = hashtab[bucket];
   while(tmp != NIL ) {
		symbol = car(tmp);
		lif( match(mask, nameof(symbol))) {
		 /*
		  * A matching symbol is in the table
		  */
		 return(symbol);
      }
   tmp = cdr(tmp);

   }
   /*
	* The symbol is not in the symbol table, so NIL
    */
	return(NIL);
}
LISPFUNC(brdsym)
{
	      return(rdsym(car(args)));
}
/*****************************************************************************
 * Doesn't de-allocate memory yet.
 */
EXP insym(EXP x)
{
EXP tmp = NIL, symbol = NIL, prev = NIL;
int bucket;

	lif( idp(x) )  {
		x = nameof(x); /* because we want to compare raw names */
	}
	bucket = hashany(x);
	tmp = hashtab[bucket];
  	while( tmp != NIL ) {
	  		symbol = car(tmp);
		lif( match(x, nameof(symbol)) ) {
			/* The symbol is in the table, so remove it */
			EXP retval = NIL;

			if( prev == NIL )       /* Head of the list? */
				hashtab[bucket] = cdr(tmp);
			else {
				prev->reg.zpair.zcdr = cdr(tmp);
			}
			retval = reference(nameof(symbol));
			tmp->reg.zpair.zcdr=NIL; /* so purge doesn't see all symbols */
			purge(tmp);
            dereference(retval);
			return(retval);
      	}
      	prev = tmp;
      	tmp = cdr(tmp);       /* select the next in the list */
   	}
     return(NIL);
}
LISPFUNC(binsym)
{
	return(insym(car(args)));
}
/***********************************************************************/
LISPFUNC(boblist)
{
EXP result = NIL,tmp = NIL;
int i;

	args = args;   /* shuts up compiler warnings about unused */

   	result = NIL;
	for(i=0;i<HASHMODULO;i++) {
   		tmp = hashtab[i];

   		while(tmp != NIL ) {
			tmp->zcount++; /* What is this for ? */
			result = cons( car(tmp), result);
   			tmp = cdr(tmp);
   		}
	}
   	return(result);
}

/****************************************************************************
 *
 *
 *
 */
void set( EXP identifyer, EXP valu )
{
   lif( land(idp(identifyer),lnot(constantp(identifyer))) ) {
   
	  valu = reference( valu);	/* prevent next unlink from deleting valu
							 * as in (setq x  x)
							 */
      purge( zapval(identifyer) ); /* apval in car */
      identifyer->reg.zpair.zcar = valu ;
   }
   else {
		  c_prints(identifyer);
	      c_error(" can't set to a nonidentifier or constant",identifyer);
   }
}
/****************************************************************************
 *
 *
 *
 */

EXP value(EXP ident)
{
   lif( idp(ident) ) {
      return( zapval(ident) ); /* apval in car */
   }
   else {
      c_error(":value: cannot value non-identifyer",ident);
      return(NIL);
   }
}
EXP boundp(EXP ident)
{

	  if( value(ident ) == UNBOUND)
			return(NIL);
	  else
			return(T);
}
LISPFUNC(bboundp)  { return( boundp(car(args)) ); }
EXP bdefconstant(EXP args)
{
EXP result = eval( car(cdr(args)) );

	set( car(args), result );
    car(args)->ztype = CONSTANT;
	return( result ); 
}
LISPFUNC(bset)
{ 
	set(car(args),car(cdr(args)));
	return(car(cdr(args))); 
}

LISPFUNC(emksymbol)
{
	return( lookup(csr(car(args))) );
}
/******************************************************************
 *
 *	Function to create a unique symbol.
 */
static int new_symbol = 1;
LISPFUNC(bgensym)
{
char new_name[LEN_STRING];

	args = args; /* shut up lint */
	lif(args) {
		new_symbol = cir(car(args));
	}
	sprintf(new_name,"G%d",new_symbol++);
	return(newidcell(newscell(new_name)));
}
/******************************************************************** 
 *
 * Object Oriented Function to search a class tree for a slot.
 */
EXP quote_class = NIL;

LISPFUNC(bslot)
{
EXP object = car(args);
EXP slot = car(cdr(args));

EXP class = NIL;
EXP superclass = NIL;
EXP val = NIL;

		switch( object->ztype ) {
			case   PAIR : 		class = lookup("cons");			break;
			case   INTEGER :	class = lookup("fixnum");		break;
			case   SUBRP :		class = lookup("subr");		break;
			case   FSUBRP :		class = lookup("fsubr");		break;
			case   STRING :		class = lookup("string");		break;
			case   FILEPTR :	class = lookup("stream");		break;
			case   FLOAT :		class = lookup("float");		break;
			case   BIGSTRING :	class = lookup("string");	break;
			case   CONSTANT :
			case   IDENTIFYER :	class = object;					break;
		}
		if( slot == quote_class ) {
			lif( lnot(idp(object)))
				return(class);
			else {
				lif( null(getprop(class, slot)))
					return(lookup("symbol"));
			}
		}
		val = getprop(class, slot);
		lwhile( null(val) ) {
			superclass = getprop(class, quote_class);
			lif(null(superclass)) {
				 c_error("object has no slot",cons(object,slot));
			}
			else {
				class = superclass;
				val = getprop(class, slot);
			}
		}
		return(val);
}
void InitSymtab()
{
   set( lookup("defconstant"), newffcell(bdefconstant));
   set( lookup("set"), newfcell(bset));
   set( lookup("hash"), newfcell(bash));
   set( lookup("boundp"), newfcell(bboundp));
   set( lookup("oblist"), newfcell( boblist ));
   set( lookup("symbol-plist"), newfcell( bplist ));
   set( lookup("symbol-name"), newfcell( bnameof ));
   set( lookup("symbol-value"), newfcell( bsymval ));
   set( lookup("put"), newfcell(bputprop));
   set( lookup("get"), newfcell(bgetprop));
   set( lookup("intern"), newfcell(emksymbol));
   set(lookup("remprop"), newfcell(bremprop));
   set(lookup("gensym"), newfcell(bgensym));

   /* linda-esque stuff */
   question = reference( lookup("*"));
   set( lookup("_match"), newfcell(bmatch));
   set( lookup("outsym"), newfcell(boutsym));	
   set( lookup("addsym"), newfcell(baddsym));
   set( lookup("rdpsym"), newfcell(brdsym));
   set( lookup("inpsym"), newfcell(binsym));

/*
 * Object Oriented Stuff 
 */
   quote_class = reference( lookup("class"));
	set(lookup("slot"), newfcell(bslot));
}
 
