#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include "cells.h"

#define COMMENTCHAR ';'

extern FILE *input;
extern EXP addsym(EXP, EXP);
extern void c_warn_header(char *);

EXP cursym = NIL;
int ch = ' ';
int linecount =1;
/****************************************************************************
 *   Raise a number to an integer power.
 */
float lpower(float x,int y)
{
float ret = 1.0;


     if( y >= 0) {
          while(y > 0) {
               ret *= x;
               y -= 1;
          }
     }
     else { /* -ve power so divide */
          while(y < 0) {
               ret /= x;
               y += 1;
          }
     }
     return(ret);
}
/***********************************************************************
 *
 */
int asc_to_int( int x )
{

  	if( x <= '9' && x >= '0' ) {
      return( x - '0' );
	}
  	else {
		if( x == '.') {
     		ungetc(x , input);
   	   		return( 888 ); /* This must be a float ! */
  		}
   		else {
			if( x == 'e' || x == 'E') {
      			ungetc(x , input);
      			return( 999 ); /* This must be a mantissa ! */
   			}
   			else {
     			ungetc(x , input);
      			return( 100 );  /* ie return value is > 9 */
   			}
		}
	}
#ifdef LASER
	ungetc(x , input); /* LASER C seems to need this */
    return( 100 );  /* ie return value is > 9 */
#endif
}
/***********************************************************************
 *
 */
EXP c_number(int sign)
{
int d;
int leading = 0;
int mantissa = 0;
int mant_sign = 1;
float trailing = 0.0;
float place = 0.1;
int itsafloat = 0;

   
   d = asc_to_int( ch );
   do {
      leading = 10*leading + d;
      ch = getc(input);
      d = asc_to_int(ch);
   } while( d < 10 );

   if( d == 888) { /* parse the fractional part of a float */
		itsafloat = 1;
          ch = getc(input);   /* skip the '.' */
          ch = getc(input);
          while( (d = asc_to_int( ch )) < 10) {
               trailing = trailing + d*place;
               place = place/10.0;
               ch = getc(input);
          }
   }

   if( d == 999) { /* parse the mantissa part of a float */
          ch = getc(input);   /* skip the 'e' */
          ch = getc(input);
          if( ch == '-' ) {
               mant_sign = -1;
               ch = getc(input);
          }
          while( (d = asc_to_int( ch )) < 10) {
               mantissa = mantissa*10 + d;
               ch = getc(input);
          }
          
   }
   if( itsafloat ) {
          /* must be floating-point */
	float lp = lpower((float)10.0,(int)(mant_sign*mantissa));

          return(newflocell( (float) (sign*(leading+trailing))*lp));
   }
   else {
          /* must be a round integer */
          return(newicell(sign*leading));
   }
}
/*
 * Predicate tests if char is valid in a symbol.
  */
ident_char_p( int c)
{
int retval;

   switch(c ) {

   case '\f':
   case '\n':
   case '\t':
   case ' ' :
   case '\r':
   case '(' :
   case ')':
  case COMMENTCHAR :
   case BQUOTECHAR :
   case QUOTECHAR :
   case '"':
	  retval =0;
	  break;

   default:
	  retval=  1;
	  break;

   }
   return( retval );
}
/***********************************************************************
 *
 */
inside_identifyer( int c )
{
int retval;

	if( ident_char_p(c) ) {
	  return(1);
	}
	else {
	  ungetc(c,input);
	  return(0);
        }
}

/***********************************************************************
 *
 */
EXP c_string()
{
int i=0;
char string[LEN_STRING];
EXP first = NIL;
EXP tmp = NIL,last = NIL;

	while( (ch = getc(input)) != '"') {
		if( ch == ((int)EOF))
			break;
		if( ch == '\134') {
			int ch2;
	
			ch2 = getc(input);
			if( ch2 == EOF) break;
			switch( ch2) {
				case 'n' : ch = '\n'; break;
				case 'r' : ch = '\r'; break;
				case 't' : ch = '\t'; break;
				case 'f' : ch = '\f'; break;
				case '"' : ch = '\"'; break;
				case 'e' : ch = '\033'; break;
				case '\134' : ch = '\134'; break; /* ? */
				default: ch = ch2; /* ungetc(ch2,input); */ break;
			}
		}
		if( i < LEN_STRING -1)
			string[i++] = ch;
		else {
			string[i] = 0;
			tmp = newbscell(newscell(string));
			tmp->reg.zpair.zcdr = NIL;
			if( first == NIL )  {
				first = tmp;
				last = tmp;
			}
			last->reg.zpair.zcdr = tmp;
			last = tmp;
			i = 0;
			string[i++] = ch;
		}
	}
	string[i] = 0;
	if( first == NIL ) {
		first = newscell(string);
	}
	else if( i != 0 ) {
		tmp = newbscell(newscell(string));
		tmp->reg.zpair.zcdr = NIL;
		last->reg.zpair.zcdr = tmp;
	}
	return( first ); 
}
/***********************************************************************
 *
 */
EXP c_ident()
{
int i = 0;
char string[LEN_STRING];
EXP tmp = NIL;
EXP	last = NIL;    /* pointer to last in chain */
EXP first = NIL;   /* pointer to first in the list */

   while( inside_identifyer(ch) ) {
	  if( ch == '\\' )
         ch = getc(input);
		if( i < LEN_STRING -1)
			string[i++] = ch;  	/* use the buffer */
		else {          		/*   buffer full so append another */
			
			string[i] = 0; 				/* terminate buffer */
			tmp = newbscell(newscell(string));
			tmp->reg.zpair.zcdr = NIL;  	/* last points nowhere */
			if( first == NIL )  {
				first = tmp;
				last = tmp;
			}
			last->reg.zpair.zcdr = tmp;    /* append to chain */
			last = tmp;                    /* update pointer */
			i = 0;                         /* start from the beginning */
			string[i++] = ch;              /* add the char */
		}
	  ch = tolower(getc(input));
	}    /* end of loop */
	string[i] = 0;       /* terminate current buffer */
	if( first == NIL )  {  /* identifyer length < LEN_STRING */
		first = newscell(string);
	}
	else {
		if( i != 0 ) {       /* completely fill buffers  */
			tmp = newbscell(newscell(string));
			tmp->reg.zpair.zcdr = NIL;
		}
		last->reg.zpair.zcdr = tmp;
	}
	{
		EXP retval;
		reference(first);
		retval = addsym(first,first) ;
		purge(first);         /* chuck away the string if possible */
		return(retval);
    }
}
/***********************************************************************
 *
 */
EXP oldc_ident()
{
int cntr;
char astring[LEN_STRING];

   cntr = 0;
   do {
	  if( ch == '\\' )
         ch = getc(input);
      if( cntr < LEN_STRING -1) {
         astring[cntr] = ch;
         cntr++;
      }
      ch = getc(input);
   } while( inside_identifyer(ch) );
   astring[cntr] = '\0';
   return( lookup(astring) );
}

/***********************************************************************
 *
 */
void nextsym()
{
int forever = 1;

   do{
      ch = getc(input);
      switch( ch ) {
         case '\f':
         case '\n':
            linecount++;
         case '\t':
         case ' ':
         case '\r':
            break;
		 case '-' :
            ch = getc(input);
			if( ch >='0' && ch <= '9') {
 				cursym = c_number((int)-1);
			}
			else {
           		ungetc(ch , input);
				ch = '-';
                cursym = c_ident();
			}
			return;
			
		 case '"' :
			cursym = c_string();
			return;
			
         case '0' : case '1' : case '2' : case '3' : case '4' :
         case '5' : case '6' : case '7' : case '8' : case '9' :
            cursym = c_number((int)1);
            return;
            
		 case '(' : cursym = lpar; return;
		 case ')' : cursym = rpar; return;
		 case '.' : cursym = period; return;
		 case QUOTECHAR : cursym = raw_quote; return;
		 case BQUOTECHAR : cursym = back_quote; return;
		 case FUNCCHAR : {
            ch = getc(input);
			if( ch == '\'' ) {
				cursym = raw_func;
			}
			else if( ch == USERCHAR2 ) {
				cursym = raw_uchar2;
			}
			else if( ch == USERCHAR1 ) {
            	cursym = raw_uchar1;
            }
			else {
				ungetc(ch , input);
				ch = FUNCCHAR;
                cursym = c_ident();
			}
		}
		return;

		 case COMMACHAR : {
            ch = getc(input);
			if( ch == ATCHAR ) {
				cursym = raw_comma_at;
			}
			else {
           		ungetc(ch , input);
				ch = COMMACHAR;
				cursym = raw_comma;
			}
		 }
		 return;

		 case COMMENTCHAR :
			do {  /* strip comments */
               ch = getc(input);
            } while( ch != '\n' && ch != ((int)EOF) );
            ungetc(ch , input); /* comment line are counted */
            break;

         case EOF :
			cursym = beof;
            return;
            

         default:
	 	if( (ch >= ' ') && (ch <= '~') ) {
			ch = tolower(ch);
			cursym = c_ident();
			return;
		}
            	else {
		     c_warn_header("Ignoring Illegal Character");
		     fprintf(stderr," %dd\n",ch);
		}
	 }
	 } while( forever );
}


 
