#include <stdio.h>
#include <stdlib.h>
#include "cells.h"

extern void *malloc(size_t);

extern EXP hashtab[HASHMODULO];

extern char *pname(EXP);
extern EXP lookup(char *);
extern EXP oblist;
extern void new_constant(char *, EXP, EXP);

CELL cell_pool[POOL_SIZE];
long cellcount;
long watermark;
long totalcells = POOL_SIZE;

/*
 * Bootstrap Constants: Step 1
 * Declare pointers to well known, but as yet un-initialised objects.
 * This allows some initialisations, which just require a valid cell pointer. 
 * Step 2 will actually initialise these cells.
 */
CELL real_nil;

CELL unb,true,rq,rbq,rc,rca,real_printname,ruc1,ruc2,rf;

EXP PRINTNAME = &real_printname;

EXP UNBOUND = NIL;
EXP free_list = NIL;
EXP T = NIL;
EXP beof = NIL;
EXP lpar = NIL;
EXP rpar = NIL;
EXP raw_quote = NIL;
EXP quote = NIL;
EXP back_quote = NIL;
EXP backquote = NIL;
EXP raw_comma = NIL;
EXP comma = NIL;
EXP raw_comma_at = NIL;
EXP comma_at = NIL;
EXP raw_uchar1 = NIL;
EXP uchar1 = NIL;
EXP raw_uchar2 = NIL;
EXP uchar2 = NIL;
EXP raw_func = NIL;
EXP func_quote = NIL;
EXP period = NIL;


char *csr(EXP x)
{
	lif( stringp(x)) {
   		return(x->reg.zstring);
	}
	else {
		c_error(" not STRING for CSR",x);
		return((char *)NULL);
	}
}
/******************************************************************************
 *
 *
 *
 */
void *cvoidr(EXP x)
{
	if( x->ztype == VOIDPTR) {
		return(x->reg.zvoid);
	}
	else {
		serr("non-pointer passed to cvoidr");
		return((void *)NULL);
	}
}
FILE *cor(EXP x)
{
	lif( filep(x)) {
		return(x->reg.zfile);
	}
	else {
		serr("non-file passed to cor");
		return(stdout);
	}
}
PTRFCELLPTR cfr(EXP x)
{
	lif( lor( subrp(x) , fsubrp(x))) {
		return(x->reg.zfunction);
	}
	else {
		serr("non-subrp passed to cfr");
		return(x->reg.zfunction);
	}
}
void rplcf(EXP x, PTRFCELLPTR val, int type)
{
	lif( lnot(null(x))) {
	   x->ztype = type;
	   x->reg.zfunction = val;
	}
	else {
		serr("nil passed to rplcf");
	}
}
EXP newffcell( PTRFCELLPTR func )
{
register EXP new;

	new = get_cell();
	rplcf( new, func, FSUBRP );
	return(new);
}
EXP newfcell( PTRFCELLPTR func )
{
register EXP new;

	new = get_cell();
	rplcf( new, func, SUBRP );
	return(new);
}
/******************************************************************************
 *
 *
 *
 */
void rplci(EXP x, int val)
{
	lif( lnot(null(x)) ) {
	   x->reg.zinteger = val;
	}
	else {
		serr("nil passed to rplci");
	}
}
/******************************************************************************
 *
 *
 *
 */
int ccr(EXP x)
{
	lif( lnot(null(x)) ) {
 	  return(x->zcount);
	}
	else {
		serr("nil passed to ccr");
		return((int)NULL);
	}
}
/******************************************************************************
 *
 *
 *
 */
int cir(EXP x)
{
	lif( fixp(x) ) {
  		 return(x->reg.zinteger);
	}
	else lif( floatp(x) ) {
  		 return((int)x->reg.zfloat);
	}
	else {
		serr("non-integer passed to cir");
		return((int)NULL);
	}
}
/*
 * Contents of float register
 */
float cflor(EXP x)
{
	lif( floatp(x) ) {
  		 return(x->reg.zfloat);
	}
	else lif( fixp(x) ) {
  		 return((float)x->reg.zinteger);
	}
	else {
		serr("non-float passed to cflor");
		return((float)0);
	}
}
EXP fixp(EXP x)
{
   lif( lnot(null(x)) ) {
	   if(x->ztype == INTEGER )
	       return(T);
	   else
	      return(NIL);
	}
	else {
		serr("nil passed to fixp");
		return(NIL);
	}
}
EXP nth(int n , EXP l)
{
	for(n=n; n>0; n--) {
		lif( (null(l) ) ) {
			return(NIL);
			/* c_error("nth: to few list elements", l);  */
		}
		l = cdr(l);
	}
	lif( l)
		return(car(l));
	else
		return(NIL);
}
EXP member(EXP a , EXP l)
{
	lwhile( lnot(null(l)) ) {
		lif( equal(a,car(l)) )
			return(l);
		l = cdr(l);
	}
	return(NIL);
}
/************************************************************************
 *
 * Put a cell back on the free list
 *
 */
void c_release(EXP x)
{

   if( x == NIL) 
		return;
   if( x->ztype == BIGSTRING ) {
		EXP tmp;

		tmp = x->reg.zpair.zcdr;
		c_release(x->reg.zpair.zcar);
          x->ztype = STRING;
		c_release(x);
		c_release(tmp);
		return;
   }
   cellcount++;
   x->zcount = 0;
   x->ztype = PAIR;
   x->reg.zpair.zcar = NIL;
   x->reg.zpair.zcdr = free_list;
   free_list = x;
}

/******************************************************************
 *
 *
 */

EXP newflocell(float init)
{
register EXP new;

   new = get_cell();
   new->ztype = FLOAT;
   new->reg.zfloat = (float) init;
   return(new);
}
EXP newicell(int init)
{
register EXP new;

   new = get_cell();
   new->ztype = INTEGER;
   new->reg.zinteger = init;
   return(new);
}
EXP newvoidcell(void *init)
{
register EXP new;

   new = get_cell();
   new->ztype = VOIDPTR;
   new->reg.zvoid = init;
   return(new);
}
EXP newocell(FILE *init)
{
register EXP new;

   new = get_cell();
   new->ztype = FILEPTR;
   new->reg.zfile = init;
   return(new);
}
/******************************************************************
 *
 *
 *
 */
EXP newbscell(EXP str)
{
register EXP new;

   new = get_cell();
   new->ztype = BIGSTRING;
   new->reg.zpair.zcar = str;
   return(new);
}
EXP newbigstring(char *str)
{
int i = 0;
char string[LEN_STRING];
EXP tmp = NIL;
EXP	last = NIL;    /* pointer to last in chain */
EXP first = NIL;   /* pointer to first in the list */

   while( *str != 0 ) {
	 /* if( *str == '\\' )
			str++;      Comment out \ processing */
		if( i < LEN_STRING -1)
			string[i++] = *str;  	/* use the buffer */
		else {          		/*   buffer full so append another */
			
			string[i] = 0; 				/* terminate buffer */
			tmp = newbscell(newscell(string));
			tmp->reg.zpair.zcdr = NIL;  	/* last points nowhere */
			if( first == NIL )  {
				first = tmp;
				last = tmp;
			}
			last->reg.zpair.zcdr = tmp;    /* append to chain */
			last = tmp;                    /* update pointer */
			i = 0;                         /* start from the beginning */
			string[i++] = *str;              /* add the char */
		}
      str++;
	}    /* end of loop */
	string[i] = 0;       /* terminate current buffer */
	if( first == NIL )  {  /* identifyer length < LEN_STRING */
		first = newscell(string);
	}
	else {
		if( i != 0 ) {       /* completely fill buffers  */
			tmp = newbscell(newscell(string));
			tmp->reg.zpair.zcdr = NIL;
		}
		last->reg.zpair.zcdr = tmp;
	}
	return( first );
}
/******************************************************************
 *
 *
 *
 */
EXP newscell(char *str)
{
register EXP new;
int i,not_finished=1;

   new = get_cell();
   new->ztype = STRING;
   i = 0;
  	while( not_finished) {
		new->reg.zstring[i] = str[i];
      	i++;
		if( (i == LEN_STRING-1) || str[i] == 0 ) /* last in string */
			not_finished = 0;	
	}
	new->reg.zstring[i] = 0;
   	return(new);
}
/**************************************************************
 *
 *
 */
EXP get_cell()
{
register EXP new = NIL;

   lif( null(free_list) ) {
#ifndef LINT
			/* lint complains about the next line:
			 * "possible pointer alignment problem, op CAST"
			 *, but it is OK really
			 */
		new = (EXP)malloc(sizeof(CELL));
#endif
		if( new == NULL ) {
      		serr("no more free memory");
      		return(NIL);
		}
		else {
			totalcells++;
      		new->reg.zpair.zcdr = NIL;
      		new->ztype = PAIR;
      		new->zcount = 0;
      		return(new);
		}
   }
   else {
      cellcount--;
      if( cellcount < watermark )
         watermark = cellcount;
      new = free_list;
      free_list = free_list->reg.zpair.zcdr;
      new->reg.zpair.zcdr = NIL;
      new->ztype = PAIR;
      new->zcount = 0;
      return(new);
   }
}

/******************************************************************************
 *
 * Decrement the usage count of the cell.
 *
 */
void c_decr(EXP x)
{
	if( x != NIL) 
		x->zcount--;
}
/******************************************************************************
 *
 * Decrement the usage count of the cell, then attempt discard.
 *
 */
void c_unlinkaux(EXP x)
{

	lif( consp(x) ) {   /* if it is a list
                            * attempt to release the
			    * children of this cell 
			    */
		c_unlink( car(x) );
		c_unlink( cdr(x) );
	}
	/* put this cell onto the free list ,
	because it is unused */
	c_release(x);
}
/******************************************************************************
 *
 *  Points a C variable at a cell , ensuring that the use count is incremented.
 *
 */
void c_link(EXP *variable_adr, EXP x)
/* EXP *variable_adr;         location of the C variable cell pointer */
/* EXP x;                     Address of cell to point to  */
{
   /* Give it a new value */
   *variable_adr = x;

   if( x != NIL )
      (*variable_adr)->zcount++;

}
void c_dlinkcell( EXP to, EXP from)
{
	c_link( &to->reg.zpair.zcdr, from);
}
void c_alinkcell( EXP to, EXP from)
{
	c_link( &to->reg.zpair.zcar, from);
}
/******************************************************************************
 *
 *
 *
 */
EXP cons(EXP a, EXP d)
{
register EXP new;

   new = get_cell();
   new->ztype = PAIR;
   new->reg.zpair.zcar = a;
   new->reg.zpair.zcdr = d;
   return(new);
}
/******************************************************************************
 *
 *
 *  
 */
EXP equal(EXP x, EXP y)
{
register EXP retval = NIL;

#ifdef DEBUG
printf("equal: "); c_prints(x); printf(" "); c_prints(y);printf("\n");
#endif

   retval = NIL;
   if( x == NIL && y == NIL)
      retval = T;
   else if( x == NIL || y == NIL )
      retval = NIL;
   else if( x->ztype == y->ztype)

      switch( x->ztype ) {
         case PAIR :
			lif( land(equal( car(x) , car(y)) , equal( cdr(x), cdr(y) ) ))
                  retval = T;
            else
                  retval = NIL;
            break;

		 case IDENTIFYER :
		 case CONSTANT :
            if( x == y)
               retval = T;
            else
               retval = NIL;
            break;

         case STRING :
            if( strncmp( x->reg.zstring, 
					y->reg.zstring,LEN_STRING) == 0)
               retval = T;
            else
               retval = NIL;
            break;

		 case BIGSTRING : {
				EXP tmpx = x;
				EXP tmpy = y;
                retval = T;
				lwhile( land(lnot(null(tmpx)) , lnot(null(tmpy))) ) {
				   if( strncmp( tmpx->reg.zpair.zcar->reg.zstring,
				       tmpy->reg.zpair.zcar->reg.zstring,LEN_STRING) != 0) {
								retval = NIL;
								tmpx = NIL; /* terminate loop */
				   }
                   else {
						tmpx = tmpx->reg.zpair.zcdr;
						tmpy = tmpy->reg.zpair.zcdr;
                    }
			   }
			}
            break;

         case INTEGER :
            if( x->reg.zinteger == y->reg.zinteger)
               retval = T;
            else
               retval = NIL;
            break;

         case FILEPTR :
            if( x->reg.zfile == y->reg.zfile)
               retval = T;
            else
               retval = NIL;
            break;

         case SUBRP :
         case FSUBRP :
            if( x->reg.zfunction == y->reg.zfunction )
               retval = T;
            else
               retval = NIL;
            break;

         default :
            retval = NIL;

      }
#ifdef DEBUG
printf("==> "); c_prints(retval); printf("\n");
#endif

	return(retval);

}

/*****************************************************************************
 *
 *
 *
 */
EXP eq(EXP x , EXP y)
{
   if( x == y)
      return( T );
   else
      return( NIL );

}
/*
 * Function to check if a circularity exists.
 */
int c_circularp(EXP target, EXP b)
{
EXP tmp = b;

	lwhile( land(target , tmp) )    {
		lif(idp(tmp))
			return(0);
		else if( target == tmp )
			return(1);
		else lif(consp(tmp)) {
			if( c_circularp( target, car(tmp) )) {
				return(1);
			}
			tmp = cdr(tmp);
		}
		else
        	tmp = NIL;
	}
	return(0);
}
/*
 * Function to copy contents of a cell to another (except it's ref count).
 */
void c_movecell(EXP to, EXP from)
{
	lif( lor( null(to) , null(from)) ) {
		serr(" attempt to replace cell with NIL in c_movecell");
		return;
	}
	if( to == from)
		return;
	to->ztype = from->ztype;
	switch(from->ztype) {
		case INTEGER:
			to->reg.zinteger = from->reg.zinteger;
		break;
		case PAIR :  {
			to->reg.zpair.zcar = from->reg.zpair.zcar;
			to->reg.zpair.zcdr = from->reg.zpair.zcdr;
		}
		break;
		case IDENTIFYER :
			to->reg.zpair.zcar = from->reg.zpair.zcar;
			to->reg.zpair.zcdr = from->reg.zpair.zcdr;
		break;
		case SUBRP :
		case FSUBRP :
			to->reg.zfunction = from->reg.zfunction;
		break;
		case STRING :
			strncpy(to->reg.zstring , from->reg.zstring, LEN_STRING);
		break;
		case FILEPTR :
			to->reg.zfile = from->reg.zfile;
		break;
		case FLOAT :
			to->reg.zfloat = from->reg.zfloat;
		break;
		case BIGSTRING :
			to->reg.zpair.zcar = from->reg.zpair.zcar;
			to->reg.zpair.zcdr = from->reg.zpair.zcdr;
		break;
		default:
			serr("unknown Cell type passed to c_copycell");
        break;
	}
}
/*
 * Function to over-write one cell with another
 */
EXP c_replace(EXP target, EXP source)
{
EXP tmp = NIL;

	lif( lor( null(target) , null(source)) ) {
		serr("can't replace cell with NIL in c_replace");
	}

	if( source == target)
		return(target);
	if(c_circularp(target, source)) {
		c_error("circular structure in c_replace",
				cons(target,source));
	}
	tmp = get_cell();
	c_movecell(tmp, target);
	reference(tmp);
	/* reference(source);       */
	reference(target);
	c_movecell(target , source);	/* over-write */
	purge(tmp);
    dereference(target);
	/* dereference(source);    */
	return(target);
}
void InitCells()
{
register int i;



	watermark = POOL_SIZE;
	for(i=0;i<POOL_SIZE;i++) {
		cell_pool[i].ztype = STRING;
		c_release( &cell_pool[i]);
		}
	oblist = NIL;

	for(i=0;i<HASHMODULO;i++)
		hashtab[i] = NIL;

	{
	extern void intern_sym(EXP);
	/* 
	 * Bootstrap data declarations: Step 2
	 * Some constants are used everywhere, and require proper
	 * definition before anything else.
	 */
	 /* NIL is a macro ! */
	 T = &true;  /* used in #define macros like null() */

    /*
	 * PRINTNAME is used by eputprop() when lookup() or
	 * addsym() create a new symbol. therfore hand-build
	 * it now. The explicit initialisation avoids having
	 * zero fields, which screws up the reference() etc.
	 * 
	 *
	 */
		PRINTNAME = &real_printname;
		new_constant("pname", PRINTNAME, PRINTNAME);
		intern_sym(PRINTNAME);
	/*
	 * The code below hand-builds the "nil" symbol. Notice
	 * it uses PRINTNAME, which is built just above.
	 *
	 * NIL ==> &real_nil ; NIL is a macro !
	 * NIL is used inside the interpreter, even in the cell pools
	 * as above. It is used to terminate hash lists in the
	 * symbol table, therfore cannot appear there. It must
	 * be created "by hand", and lookup() etc must check for
	 * it explicitly to simulate internment.
	 *
	 *
	 */ 
	 new_constant("nil",NIL, NIL);
		/*
		 * UNBOUND is used by lookup() to set the value field of a symbol.
		 */
		UNBOUND = &unb;
		new_constant("unbound", UNBOUND, UNBOUND);
		intern_sym(UNBOUND);

		/*
		 * T is used in macros like null(), needs a symbol.
         * the actual value of T is irrelevant, and can be over-written.
		 */
		 new_constant("t",T,T);
         intern_sym(T);
	}

	/*
	 * Here we generate some constants for internal use.
	 * lookup() is used just to construct some unique pointers.
     */

	c_link(&beof ,lookup("_*eof*"));
	c_link(&lpar ,lookup("lpar"));
	c_link(&rpar ,lookup("rpar"));
	back_quote =  reference(lookup("`")); ;
	raw_comma = reference(lookup(",")); /* &rc;     */
	raw_quote = reference(lookup("\'")); /* &rq;  */
	raw_uchar1 = reference(lookup("#!")); /* &ruc1;   */
	raw_uchar2 = reference(lookup("#?")); /* &ruc2;   */
	raw_func = reference(lookup("#'")); /* &rf;  */
	raw_comma_at = reference(lookup(",@")); /* &rca;  */
	c_link(&quote ,lookup("quote"));
	c_link(&uchar1 ,lookup("quser1"));
	c_link(&uchar2 ,lookup("quser2"));
	c_link(&func_quote ,lookup("function"));
	c_link(&backquote ,lookup("backquote"));
	c_link(&comma ,lookup("comma"));
	c_link(&comma_at ,lookup("comma-at"));
	c_link(&period ,lookup("period"));

}
/*
 * Function to convert identifyers, strings and bigstrings to a 
 * character array. Caller supplies array. No checks are done
 * regarding length which is obviously crap!
 */
EXP c_tostr( char *str, EXP x)
{
  	lif(idp(x)) {
		sprintf(str, "%s", pname(x) );
		return(T);
	} 
	else lif( stringp( x ) ) {
      	sprintf(str, "%s", csr(x) );
		return(T);
	}
	else lif( bigstringp( x ) ) {
		while(x != NIL) {
      		sprintf(str, "%s", csr(x->reg.zpair.zcar) );
			str += strlen(csr(x->reg.zpair.zcar));
			x = x->reg.zpair.zcdr;
		}
		return(T);
   	}
	else 
		return(NIL);
}
int c_lenstr( EXP x)
{
	lif(idp(x)) {
		return(c_lenstr(nameof(x)));
	} 
	else lif( stringp( x ) ) {
		return(strlen(csr(x)));
	}
	else lif( bigstringp( x ) ) {
		int l = 0;
		while(x != NIL) {
			l += strlen(csr(x->reg.zpair.zcar));
			x = x->reg.zpair.zcdr;
		}
		return(l);
   	}
	else 
		return(-1);
}

