;;;;
;;;; File contains functions to manipulate time.
;;;; 
;;;; Reminder: (get-decoded-time) returns (ss mm hh dd mm yy ..)
;;;;
;;
;; Function to convert decoded-time to seconds since midnight
;;
(defun time:convert (dec-time)
	(+  (nth 0 dec-time)					; seconds
		(* 60 (+ (nth 1 dec-time)			; minutes
				(* 60 (nth 2 dec-time))))))	; hours
;;
;; Function to get number of seconds since midnight.
;; 
;;
(defun time:get-secs ()
	 (time:convert (get-decoded-time))) ; fetch the time now, convert
;;
;; Function delays for specified time, less than a day.
;; Does NOT work near midnight! Fixed modulo version needed...
;;
(defun time:Delay (secs)
	 (time:wait  (+ (time:get-secs) secs)))			; timeout time

;;;
;;; Wait until the appointed time (secs since midnight).
;;;
(defun time:wait (end)
	(do-while (< (time:get-secs) end) t)) ; do nothing loop

;;;
;;; Wait until a particular date, time
;;; INPUT: time in decoded-time format.
;;;
(defun time:alarm (bing)
	(do-while (not(equal bing (get-decoded-time))) t))	; do nothing loop


;;;
;;; Function to measure the time taken to execute something.
;;;
(defmacro time:perf (&rest forms)
   `(progn
		(setq start (get-decoded-time))
		,@forms
		(-  (time:convert (get-decoded-time)) (time:convert start))))

;;;
;;; Function to print out the time in Digital form
;;;
(defun time:print ()
	(time:print-aux (get-decoded-time)))

(defun time:print-aux (time:now)
	(princ (nth 2 time:now))
	(princ ":")
	(princ (nth 1 time:now))
	(princ ":")
	(princ (nth 0 time:now)) )
