;;;;
;;;; Taken from "Lisp" by Winston & Horn 2nd edition
;;;; Problem 11-9
;;;;
;;;;
;;;;
(defun = (a b) (equal a b))
(DEFUN QUEEN (SIZE) (QUEEN-AUX NIL 0 SIZE))

(DEFUN QUEEN-AUX (BOARD N SIZE)					; sTART ON NEXT rOW
	(COND ((= N SIZE) (BOARD-PRINT (REVERSE BOARD)))
		(T (QUEEN-SUB BOARD N 0 SIZE))))

(DEFUN QUEEN-SUB (BOARD N M SIZE)
	(COND ((= M SIZE))
		(T (COND ((CONFLICT N M BOARD))
			(T (QUEEN-AUX (CONS (LIST N M) BOARD) (+ N 1) SIZE)))
		(QUEEN-SUB BOARD N (+ M 1) SIZE))))

(DEFUN CONFLICT (cN cM cBOARD)
	(COND ((NULL cBOARD) NIL)
		((OR (THREAT cN cM (CAAR cBOARD) (CADAR cBOARD))
			(CONFLICT cN cM (CDR cBOARD))))))

(DEFUN THREAT (I J A B)
	(OR (= I A)
		(= J B)
		(= (- I J) (- A B))
		(= (+ I J) (+ A B))))


(DEFUN BOARD-PRINT (BOARD) (BOARD-PRINT-AUX BOARD (LENGTH BOARD)))

(DEFUN BOARD-PRINT-AUX (BOARD SIZE)
	(TERPRI)
	(COND ((NULL BOARD))
		(T (BOARD-PRINT-SUB (CADAR BOARD) 0 SIZE)
			(BOARD-PRINT-AUX (CDR BOARD) SIZE))))

(DEFUN BOARD-PRINT-SUB (COLUMN N SIZE)
	(COND ((= N SIZE))
		(T (COND ((= COLUMN N) (PRINC "Q"))
				(T (PRINC ".")))
			(PRINC " ")
			(BOARD-PRINT-SUB COLUMN (+ N 1) SIZE))))

