; 
; 
;
(load "shake.lsp")

(defun type-of (x) 
	(if (symbolp x) 'symbol (slot x 'class)))

(defun profile-report (functions)
	(cond ((atom functions) (setq functions (list functions))))
	(dolist (fun functions)
		(unless (equal 0 (get fun 'count))
			(princ* CR (get fun 'count) "\t" fun ))))

(defun profile (functions)
	(cond ((atom functions) (setq functions (list functions))))
	(dolist (f functions)
		(profile-aux f))
		t)

;;
;;	Filter out symbols which are not functions defined by 
;;	the user in Lisp.
;;

(defun filter (symlist &optional val)
	(cond
		((null symlist) '())
		((and (boundp (car symlist))
				(or (and (member (type-of (symbol-value (car symlist))) 
						'(subr fsubr)) 
						(not (member (car symlist) except )) )
					(and (consp (symbol-value (car symlist)))	
						(member (car (symbol-value (car symlist)))
							'(macro lambdaq lambda)))))
			(cons (car symlist) (filter (cdr symlist))))
							
		(else
			(filter (cdr symlist)))))

(defun profile-clear (functions)
	(cond ((atom functions) (setq functions (list functions))))
	(dolist (g functions)
		(unprofile g)))

(defun profile-aux (fn)
   (put fn 'olddef (function-value fn))   ; save old definition
   (put fn 'count 0)   			; initialise counter
   (set fn 
      `(,(cond
	  		((equal (type-of (function-value fn)) 'subr)
				'lambda)
	  		((equal (type-of (function-value fn)) 'fsubr)
				'lambdaq)
	  		((consp (function-value fn))
				(car (function-value fn))))
			(&rest *x)
	  	 (put ',fn 'count (+ 1 (get ',fn 'count)))
		 (apply (get ',fn 'olddef) *x)
          ))
   fn )

(setq except (shake-tree 'profile))
(defun unprofile (fn)
   (set fn (get fn 'olddef))
;   (remprop fn 'olddef)
   (list fn 'unprofiled) )
