;;;
(setq char-d 100)
(setq char-r 114)
(setq char-c 99)
(setq char-j 106)
(setq char-v 118)
(setq char-x 22) ; ^X
;;;
(setq BLACK 0)
(setq WHITE 15)


	(setq all '())

;
; Elementary O O functions.
;
; Utility function to call a method without arguments. 
(defun selfx (method)
   ((slot this method) this) )

(defun distribute (method obs)
   (do-while obs
		 ((slot (car obs) method) (car obs))
		  (setq obs (cdr obs)) ) )

; definition of the class of graphics objects
; Abstract Data Type
(put 'object '*down* '(lambda () ))
(put 'object '*save* '(lambda (&rest args) ))

; Define the dollar #? quote syntax to get slots from 'this
; #?r => (slot this 'r)
(df quser2 (slotname) (get this slotname))

; Handy function to set the value of a slot.
(defun setslot (slotname value)
	(put this slotname value))

(defun defclass (_child _parent) (put _child 'class _parent))

(defun gen-obj ()
	(setq last-id (+ last-id 1))
	(gensym last-id))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; definition of the class - text-objects
(setq menuheight (-  4800 17))
(defclass 'text-object 'object)    ; text-objects are objects

; simplification of initialization
(put 'text-object 'new '(lambda (this label &optional (h 1000) (v 1000)) 

	(setslot 'state NIL) ; T if displayed.
	(setslot 'h h)
	(setslot 'v v)

   (setslot 'label label)
   (setslot 'function function)
	; add it to the list of the objects
	(setq all (cons this all) )
	))
(defun remove (item lis)
	(cond 
			((null lis) '())
			((equal item (car lis)) (remove item (cdr lis)))
			(else
				(cons (car lis) (remove item (cdr lis))))))

(put 'text-object '*cut* '(lambda (this )

	(selfx '*unselect*)
	(selfx 'undraw)
	(setq buffer this)

	; remove it from the list of the objects
	(setq all (remove this all) )
	))

(defun text-object-refresh (this &optional ret) 
; text-object draw method
      ; first display the text-object
      ; NB text-objects are drawn down from the point, so height 'h is
      ; highest point.
      (setq ret  (textxy #?h #?v #?label))
	 ; now save its dimensions
	 (setslot 'wi (car ret))   ; width
	 (setslot 'he (cdr ret)) ; height down
)      
(put 'text-object '*refresh* text-object-refresh)

(put 'text-object 'draw '(lambda (this &optional ret) 
; text-object draw method
	(cond (#?state )
	  (else
		(text-object-refresh this)
		(setslot 'state T)
	))
))      

(put 'text-object 'undraw '(lambda (this &optional joins) 
	(cond (#?state 
		(colour BLACK)
		(text-object-refresh this)
		(setslot 'state NIL)
		(colour WHITE)
	))
	))
; text-object mouse up functions
(defun hitp (mx my x1 y1 x2 y2)
   (and (> mx x1) 
      (< mx x2) 
      (> my y1) 
      (< my y2) ) )

(defun draw-polyline (p)
	(do-while (cdr p)
		(line (caar p) (cdar p) (caadr p) (cdadr p))
		(setq p (cdr p)) ) )

(defun text-object-hilite (this)
	(draw-polyline (list
		(cons   #?h #?v)
		(cons   (+  #?h #?wi) #?v)
		(cons   (+  #?h #?wi) (-  #?v #?he))
		(cons   #?h (-  #?v #?he))
		(cons   #?h #?v ) )) )

(defun between-h (s d)
	(/ (+ (get s 'h) (get d 'h)) 2) )

(defun between-v (s d)
	(/ (+ (get s 'v) (get d 'v)) 2) )

(put 'text-object '*poll* '(lambda (this mh mv)
	 ; check if the text-object has been hit
		 (hitp mh mv  #?h  (-  #?v #?he)  (+  #?h #?wi) #?v)))

(put 'text-object '*select* '(lambda (this)
			; highlight text-object
			(text-object-hilite this)))

(put 'text-object '*unselect* '(lambda (this)
			; un-highlight text-object
			(text-object-hilite this)))

(put 'text-object '*move-relative* '(lambda (this h v)
			(text-object-hilite this)
			(selfx 'undraw)   ; un-draw old image
			(setslot 'h (- #?h h))
			(setslot 'v (- #?v v))
			(text-object-hilite this)
			(selfx 'draw)  ))

(put 'text-object '*duplicate* '(lambda (old &optional tmp)
	(setq this (gen-obj))
	(defclass this (slot old 'class))
	((slot this 'new) this (symbol-name this) 
		(+ (get old 'h) 400)
		(get old 'v))
	(selfx 'draw)

	))

(put 'text-object '*rename* '(lambda (this)
	(princ "Old label: ")
	(prin1 #?label)
	(terpri)
	(princ "New label? ")
	(put this 'label (read))
	(clear) 
	(text-object-hilite this) 
    (distribute '*refresh* all) 
	))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(put 'next-h 'h 100)
(defun next-h ()
	(get 'next-h 'h))
(put 'next-v 'v 2000)
(defun next-v ()
	(put 'next-v 'v (+ (get 'next-v 'v) 200)) )
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass 'button 'text-object)
(put 'button '*select* 
   '(lambda (this) 
    (#?function this) 
	) )
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass 'load-file 'button)
((slot 'load-file 'new) 'load-file "load-file" (next-h) (next-v))
(put 'load-file 'function
   '(lambda (this) 
   		(clear)
		(load "pic.lsp")
	(text-object-hilite this) 
    (distribute '*refresh* all) 
	(select-only '())) )

(defclass 'save-file 'button)
((slot 'save-file 'new) 'save-file "save-file" (next-h) (next-v))
(put 'save-file 'function 
   '(lambda (this) 
   (setq fd (open "pic.lsp" :direction :output))
   (distribute '*save* all) 
   (print `(setq last-id ,last-id) fd)
	(close fd)
   ) )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass 'quit 'button)
((slot 'quit 'new) 'quit "Quit" (next-h) (next-v))
(put 'quit 'function 
   '(lambda (this) (setq quitflag nil)) )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass 'clear 'button)
((slot 'clear 'new) 'clear "Refresh" (next-h) (next-v))
(put 'clear 'function 
   '(lambda (this)  
	(clear) 
	(text-object-hilite this) 
    (distribute '*refresh* all) 
	(select-only '())) )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun cadddr (x)
   (car (cdr (cdr (cdr x)))) )


(defun ps-princ (x)
	(cond 
		((numberp x) (princ (/ x 10) ps-fd))
		(else  (princ x ps-fd))))

(defun ps-line (p1 p2 p3 p4)
	(ps-princ p1)
	(ps-princ " ") 
	(ps-princ p2)
	(ps-princ " moveto\n") 
	(ps-princ p2)
	(ps-princ " ") 
	(ps-princ p3)
	(ps-princ " lineto\n")  )

(defun ps-textxy (p1 p2 p3)
	(ps-princ p1)
	(ps-princ " ") 
	(ps-princ p2)
	(ps-princ " moveto\n") 
	(ps-princ "(") 
	(ps-princ p3)
	(ps-princ ")\n" )
	'(2000 . 200)) 

(defun print-context (line textxy ps-fd &rest body)
    (distribute '*refresh* all) )

(defclass 'evprint 'button)
((slot 'evprint 'new) 'evprint "Print"  (next-h) (next-v))
(put 'evprint 'function '(lambda (this)
    (setq ps-fd (open "gui.ps" :direction :output))
	(print-context ps-line ps-textxy ps-fd )
	(close ps-fd)
))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass 'node 'text-object)
(put 'node '*join* '(lambda (dest source &optional tmp)
	(cond (source
	(setq tmp (link-new dest source))
	(put source 'to (cons tmp (get source 'to) ))
	(put dest 'from (cons tmp (get dest 'from) ))
	((slot tmp 'draw) tmp)
	))))

(put 'node 'undraw '(lambda (this)
 	((slot 'text-object 'undraw) this) ; invoke parent class draw method
	(distribute 'undraw (append #?to #?from))
	))
(put 'node 'draw '(lambda (this &optional joins) 
 	((slot 'text-object 'draw) this) ; invoke parent class draw method
	(distribute 'draw (append #?to #?from))
))
(put 'node '*save* '(lambda (this)
	(print `(progn 
		(setq tmp (gen-obj ,#?id))
		(defclass tmp 'node)
		((slot tmp 'new) tmp ,#?label ,#?h ,#?v) 
		(put tmp 'he ',#?he)
		(put tmp 'wi ',#?wi)
		(put tmp 'to ',#?to)
		(put tmp 'from ',#?from))
		fd)
	))
;;;---------------------------------------------------------
(defclass 'nodes 'text-object)
((slot 'nodes 'new) 'nodes "Make Node"  (next-h) (next-v))
(put 'nodes '*select* '(lambda (this)
	(setq this (gen-obj))
	(defclass this 'node)
	((slot this 'new) this (symbol-name this) (next-h) (next-v) )
	(selfx 'draw)

	))
;;;---------------------------------------------------------
(defclass 'link 'text-object)
(defun link-new (dest source &optional tmp)
	(cond ((and source dest)
	(setq tmp (gen-obj))
	(defclass tmp 'link)
	((slot 'text-object 'new) tmp "o" 
		(between-h source dest)
		(between-v source dest) )
	(put tmp 'from (list source))
	(put tmp 'to (list dest))
	tmp
	)))

(put 'link '*join* '(lambda (dest source &optional tmp) ))

(defun redraw-joins (this &optional joins) 
	; re-draw all joins
	(setq joins (append #?to #?from ))
	(do-while joins
		(line (get (car joins) 'h) (get (car joins) 'v)
			  #?h  #?v)
		(setq joins (cdr joins)))
)
(put 'link '*refresh* '(lambda (this) 
 	((slot 'text-object '*refresh*) this) ; invoke parent class method
	(redraw-joins this)
))
(put 'link 'undraw '(lambda (this)
 	((slot 'text-object 'undraw) this) ; invoke parent class draw method
	(redraw-joins this)
	))
(put 'link 'draw '(lambda (this)
	(put this 'h (between-h (car #?to) (car #?from)))
	(put this 'v (between-v (car #?to) (car #?from)))
 	((slot 'text-object 'draw) this) ; invoke parent class draw method
	(redraw-joins this)
))
(put 'link '*save* '(lambda (this)
	(princ `(progn 
		(defclass ,#?label 'link)
		((slot ,#?label 'new) ,#?label ,#?label ,#?h ,#?v) 
		(put ,#?label 'to ',#?to)
		(put ,#?label 'from ',#?from))
		fd)
	))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun drawl ()
    (distribute 'draw all) )


(defun do-to-one (method this)
		((slot this method) this))

(defun pass-to-list (method l &rest args)
	(do-while l
		(apply (slot (car l) method) (cons (car l) args))
		(setq l (cdr l))))

(defun do-to-list (method l)
	(do-while l
		((slot (car l) method) (car l))
		(setq l (cdr l))))

(defun select-only (obj)
	(do-to-list '*unselect* selected)
	(cond 
		(obj
			(setq selected (list obj))
			(do-to-list '*select* selected))
		(t  (setq selected '()))))

(defun select-add (obj)
	(cond ((member obj selected))
		; already selected -so ignore
		(else 
			(setq selected (cons obj selected))
			(do-to-one '*select* obj))))

(defun drag (this curr-h curr-v &optional drag-ev )
	(do-while (not (equal (car (setq drag-ev (getevent))) *up*)))
				(setq rh (- curr-h (caddr drag-ev)))
				(setq rv (- curr-v (cadddr drag-ev)))
				(setq curr-h (caddr drag-ev))
				(setq curr-v (cadddr drag-ev))
				(pass-to-list '*move-relative* selected rh rv))
				

(defun pass-to-one (event this)
	((slot this (car event)) this event))

(defun gui ()
	(setq quitflag t)
	(do-while quitflag
		(setq ev (getevent))
		(cond   ((or (equal (car ev) *down*) (equal (car ev) *sdown*))
	     	(setq tmp all) ; get a copy of the objects existing
			(setq one-found NIL)
			(do-while tmp
	    		(cond 
				; call the poll function for the object,
	       		; if it returns true, then stop the loop
	       		; by setting tmp to nil
		 		(( (slot (car tmp) '*poll*) ; function to call
		    		(car tmp) (caddr ev) (cadddr ev)) ; args
		   
				(setq one-found T)
				(cond ((member (car tmp) selected)
						(drag (car tmp) (caddr ev) (cadddr ev)))
					((equal (car ev) *down*)
						(select-only (car tmp)) )	
					(t (select-add (car tmp))))
		  		(setq tmp nil)) ; executed if polled ok not nil
	       
		       		(t (setq tmp (cdr tmp))) )); otherwise try the next
		   (cond ((not one-found) (select-only '())))
		   )
	 ((equal (car ev) *keys*)
	 	(cond ((equal (cadr ev) char-x) (do-to-list '*cut* selected))
			((equal (cadr ev) char-d) (do-to-list '*duplicate* selected)) 

	 		 ((equal (cadr ev) char-j) 
			 	(cond ((and (nth 1 selected) ; must be two to join!
					(null (equal (get (nth 0 selected) 'class) 'link))
					(null (equal (get (nth 1 selected) 'class) 'link))
					)
			 		((slot (nth 0 selected) '*join*) 
						(nth 0 selected)
						(nth 1 selected) ))) )

	 		 ((equal (cadr ev) char-r) 
	 			(do-to-list '*rename* selected)) 
		)
	 )
	 (else nil) )  ) )

(defun r ()
	(setq selected '())
	(setq polyline '())
	(setq last-id 1)
	(GraphOpen VGA 2) ; Has to be here because 'new calls button.
	(progn
		; Draw a border around the screen
		(line 10 10 6390 10)
		(line 10 10 10 4800)
		(line 10 4800 6390 4800)
		(line 6390 10 6390 4800))
	(mode XOR)
	(drawl)
	(gui)
	(setq all '())
	(GraphClose) )

(r)
