;;;
;;; 6 Oct 92
;;;
;;; This file contains a utility that searches all the .lsp files
;;; in the current directory for s-expressions matching the supplied critera.
;;;
;;;
;; INPUT:
;;
;; pattern, a pattern to be passed to "compare" (see below)
;; gaction, an action to be evaluated o the form (lambda (token) <body>)
;; file-spec, a string to be passed to (directory)
;;
;; OUTPUT:
;;
;; A print out of the number of cells in use, the file being searched.
;; and all the (gaction) results.
;;
;; EXAMPLE:
;;
;; Search for and print names of all function defs with null 
;; formal argument lists.
;; (grep 
;; 		'(defun * () *) ; pattern
;; 		
;; 		'(lambda (token) (print (cadr token)) (terpri)  )  ; action
;; )


(defun grep (pattern &optional gaction file-spec)

	(setq find:files (directory 
			(cond ((null file-spec) "*.lsp") (t filespec))))
	(setq gaction (cond 
		((null gaction) ''(lambda (token) (print token)))
		(t gaction)
	))
	(do-while find:files
	
		(princ "\;\;\; ")(princ (eroom)) (princ " ")(princ (car find:files))
		(terpri)
		(find:lookat (car find:files) pattern  gaction )
		(setq find:files (cdr find:files))
	)
)

(defun find:lookat (find:filename match-pattern action)
	(setq find:fd (open find:filename))
	(do-while (not (eq *eof* (setq token (read find:fd))))
		(cond
			((compare match-pattern token) (action token)   ) 
		)
	)
	(close find:fd)
)

;;;;;;;;;;;;;;;;;;;;;;;;
;
; Function to compare two s-expressions
; returns NIL if there is no match.
; '* in the mask stands for any value
;
(defun compare (mask y)
	(match-aux mask y mask)
)
(defun match-aux (mask y original)
	(cond
	((equal mask '*) t)
		((equal mask y) t) 
		(t  (cond
				((and (consp mask) (consp y))
					(and (match-aux (car mask) (car y) original) 
						(match-aux (cdr mask) (cdr y) original))
				)
				(t  nil)
			)
		)
	)
)
