; anag.lsp                 24 Sept 1990
;
;	Attempt at writing a program to discover anagrams by cycling
;	through combinations.
;
;
;	Bill Birch    23 Sept 1990
;
;
;
(setq SP " ")
;
(defun flatten (x)
   (cond
      ((null x) nil)
	  ((consp (car x)) (append (car x)(flatten (cdr x))))
      (t (cons (car x) (flatten (cdr x))))))

;	Slow function to remove one occurrence of an atom from a list.
;
;	returns 'failed if the atom is not in the list.
;
;	eg (remove 'a '(1 2 3 e q a 3 4)) ==> (4 3 q e 1 2 3)
;
(defun remove (x y)
     (removeaux x y nil))

(defun removeaux (letter list residue)
     (cond
          ((null list) 'failed)
          ((equal (car list) letter) (append (cdr list) residue))
          (t (removeaux letter (cdr list) (cons (car list) residue)))))
;
;	Faster version of remove
;
(defun fastremove (letter list)
     (setq result 'failed)
     (setq residue nil)
	 (do-while list         ; null list terminates the loop
          (cond
               ((equal (car list) letter) 
               (setq result (append (cdr list) residue))
		  (setq list nil)) ; force termination of loop
          
          (t   (setq residue (cons (car list) residue))
                    (setq list (cdr list)))))
     result)
;
; Function to test if a list could be legally derived from another list.
;
; returns 'failed if not
;
;	eg '(b a n k) cannot be made from '(b a n a n a) because
;		 there is no 'k in 'banana
;
(defun validp (word tst)
     (cond ((null word) t)
          (t
          (setq result (fastremove (car word) tst))
               (cond
               ((equal result 'failed) nil)
          (t (validp (cdr word) result))))))
;
; Function to scan a dictionary of words to extract all the words that could
; legally be used in an anagram
;
(defun scan (word filename)
	 (setq wordlist nil)                ; accumulated list of valid words.
	 (setq fd (open filename :direction :input))      ; open the dictionary file
	 (setq ofd (open "cwords" :direction :output))      ; open trace file

	 (do-while (not (equal (setq aword (read fd)) *eof*))
          (cond
               ((validp aword word) 
                         (setq wordlist (cons aword wordlist))
                         (write ofd aword CR)
                         (force-output ofd))
               (t nil)))
     (close ofd)
     '(scan finished))
;
; Predicate function to test if a list is an anagram.
;
;	returns   t if anag is an exact anagram of word,
;		 'incomplete if it is too short
;		 'excess if too long
;
;	it successively removes all the letters of word from anag,
;	if it's an anagram there will be none left at the end.
;
(defun checkp (target anag)  
	(cond 
		((null target)  (cond
			((null anag) t) ; exact match
			(t 'excess)))    ; too long to be an anagram
		(t
		(cond
		 ((null anag) 'incomplete) ; too short
         (t          
            (setq result (fastremove (car anag) target))
                  (cond
					 ((equal result 'failed) 'failed) ; not a letter
                   (t (checkp result (cdr anag) ))))))))
;
;
(defun cycle (target current wl)
     (do-while wl
      (setq res (checkp target (flatten (append current (car wl)))))
          (cond 
               ((equal res 'failed) nil)
               ((equal res 'excess) nil)
         ((equal res 'incomplete)
            (cycle target (cons (car wl) current) wordlist))
         (t
            (writeana outfd (append current (car wl)))
            (force-output outfd)))
      (setq wl (cdr wl))))
;
; Function to print out a list in the form ((a s d)(q w e))
; as: asd qwe
;
(defun writeana (fd x)
   (cond
      ((null x) (write fd CR))
      ((atom (car x)) (writeword fd x)(write fd CR))
      (t   (writeword fd (car x))
         (write fd SP)
         (writeana fd (cdr x)))))

(defun writeword (fd y)
   (cond
      ((null y) nil)
      (t    (write fd (car y)) 
         (writeword fd (cdr y)))))

;
;	Do it
;
;
(defun find-anag ()
'(checkp '(w e n d y) '(w e n))

(checkp '(w e n d y) '(w e n))
'(checkp '(w e n d y) '(w e n n))
(checkp '(w e n d y) '(w e n n))
'(checkp '(w e n d y) '())
(checkp '(w e n d y) '())
'(checkp '(w e n d y) '(w e n d y))
(checkp '(w e n d y) '(w e n d y))
'(checkp '(w e n d y) '(d y))
(checkp '(w e n d y) '(d y))

(setq word '(l i s p))  ; phrase to create
									; anagrams from
(print "Scanning dictionary for suitable words ")
(scan word "dict.lsp")
(print "Results in cwords")
(setq outfd (open "cycle" :direction :output))
(print "Searching for Anagrams .... ")
(cycle word nil wordlist)
(close outfd)
(print "Results in file CYCLE")

)
