
/*
    Copyright (c) 1994 Jeff Weisberg

    see the file "License"
*/

/*
  $Id: jlisp.h,v 1.23 94/08/23 08:52:13 weisberg Exp Locker: weisberg $
*/

#ifndef _jlisp_h
#define _jlisp_h

#include <jlconf.h>

typedef long Obj;

typedef struct {
	Obj car, cdr;
} Cell;

typedef struct {
	char * name;
	Obj value, props, next, prev;
} Symbox;

typedef struct {
	char *name;
	Obj (*func)();
	int minarg, maxarg;
	int evalp, listp;
	char *doc;
} Defun_Decl;

typedef struct {
	void (*mark)();
	int (*free)();
	int (*print)();
	Obj (*equal)();
} Obj_Vtbl;



#define CLASS0P(x)	( (x) & 2 )
#define CLASS1P(x)	(!CLASS0P(x))

#define IMMEDP(x)	(CLASS0P(x))
#define INUMP(x)	( ((x)&7)==2 )
#define ICHARP(x)	( ((x)&0x3F)==6)
#define ICONSTP(x)	( ((x)&0x3F)==14)

#define CINT(x)		((int)((x) >> 3))
#define MAKINT(i)	(((i) << 3) | 2)
#define CCHAR(x)	((x) >> 6)
#define MAKCHAR(c)	(((c) << 6) | 6)

#define IC_NIL		(( 0 << 6) | 14)
#define IC_TRUE		(( 1 << 6) | 14)
#define IC_FALSE	(( 2 << 6) | 14)
#define IC_UNDEF	(( 3 << 6) | 14)
#define IC_UNSPEC	(( 4 << 6) | 14)
#define IC_EOF		(( 5 << 6) | 14)


#define NULLP(x)	((x)==IC_NIL)
#define NNULLP(x)	((x)!=IC_NIL)
#define BOUNDP(x)	((x)!=IC_UNSPEC)
#define NBOUNDP(x)	((x)==IC_UNSPEC)
#define DEFINEDP(x)	((x)!=IC_UNDEF)
#define NDEFINEDP(x)	((x)==IC_UNDEF)
#define FALSEP(x)	((x)==IC_FALSE)


#define CAR(x)		( ((Cell*)(x))->car)
#define CDR(x)		( ((Cell*)(x))->cdr)
#define CDDR(x)		CDR( CDR(x))
#define CAAR(x)		CAR( CAR(x))
#define CDAR(x)		CDR( CAR(x))
#define CADR(x)		CAR( CDR(x))
#define CADDR(x)	CAR( CDDR(x))
#define CONSP(x)	(CLASS1P(x) && ( !(CAR(x)&1)))
#define NCONSP(x)	(! CONSP(x))

#define TYPEMASK	2041
#define TYPEOF(x)	( (CAR(x)&TYPEMASK) >>3)
#define MAKETYPE(t)	(((t)<<3) | 1)
#define SDBIT		4
#define GCBIT		2

#define TPV_FLOAT	1
#define TPV_DOUBLE	2
#define TPV_COMPLEX	3
#define TPV_STRING	4
#define TPV_VECTOR	5
#define TPV_BIGNUM	6
#define TPV_SYMBOL	7
#define TPV_C_CODE	8
#define TPV_SYM_BOX	9
#define TPV_FREE_CELL	10
#define TPV_BOX_CELLS	11
#define TPV_IOPORT	12
#define TPV_FUNCTION	13
#define TPV_MACRO	14
#define TPV_CATCHFRM	15
#define TPV_WEAK	16
#define TPV_ENVEC	17

#define TPV_USER_BASE	18
#define TPV_USER1	(TPV_USER_BASE + 0)
#define TPV_USER2	(TPV_USER_BASE + 1)
#define TPV_USER3	(TPV_USER_BASE + 2)
#define TPV_USER4	(TPV_USER_BASE + 3)
#define TPV_USER5	(TPV_USER_BASE + 4)
#define TPV_USER6	(TPV_USER_BASE + 5)
#define TPV_USER7	(TPV_USER_BASE + 6)
#define TPV_USER8	(TPV_USER_BASE + 7)
#define TPV_USER9	(TPV_USER_BASE + 8)
#define TPV_USER10	(TPV_USER_BASE + 9)
#define TPV_USER11	(TPV_USER_BASE + 10)
#define TPV_USER12	(TPV_USER_BASE + 11)
/* ... */

#define TPV_LAST	(TPV_USER_BASE + 11)

/* pair of fake values to simplify things */
#define TPVF_IMMED	-1
#define TPVF_CONS	0
/* and an extended typeof */
#define TYPEOFX(x)	(IMMEDP(x) ? TPVF_IMMED :( CONSP(x) ? TPVF_CONS : TYPEOF(x)))

#define FLOATP(x)	(TYPEOFX(x)==TPV_FLOAT)
#define DOUBLEP(x)	(TYPEOFX(x)==TPV_DOUBLE)
#define COMPLEXP(x)	(TYPEOFX(x)==TPV_COMPLEX)
#define STRINGP(x)	(TYPEOFX(x)==TPV_STRING)
#define VECTORP(x)	(TYPEOFX(x)==TPV_VECTOR)
#define BIGNUMP(x)	(TYPEOFX(x)==TPV_BIGNUM)
#define SYMBOLP(x)	(TYPEOFX(x)==TPV_SYMBOL)
#define SYMBOXP(x)	(TYPEOFX(x)==TPV_SYM_BOX)
#define CCODEP(x)	(TYPEOFX(x)==TPV_C_CODE)
#define FREECELLP(x)	(TYPEOFX(x)==TPV_FREE_CELL)
#define BOXCELLP(x)	(TYPEOFX(x)==TPV_BOX_CELLS)
#define IOPORTP(x)	(TYPEOFX(x)==TPV_IOPORT)
#define FUNCTIONP(x)	(TYPEOFX(x)==TPV_FUNCTION)
#define MACROP(x)	(TYPEOFX(x)==TPV_MACRO)
#define ENVECP(x)	(TYPEOFX(x)==TPV_ENVEC)
	
#define READABLE	1
#define WRITABLE	2
#define RPORTP(x)	(IOPORTP(x) && ((CAR(x)>>12) & READABLE))
#define WPORTP(x)	(IOPORTP(x) && ((CAR(x)>>12) & WRITABLE))

#define CFLOAT(x)	(*((float*)&CDR(x)))
#define CDOUBLE(x)	(*((double*)CDR(x)))
#define CCHARS(x)	((char*)CDR(x))
#define CVECTOR(x)	((Obj*)CDR(x))
#define CSYM_BOX(x)	((Symbox*)CDR(x))
#define CFILEPTR(x)	((FILE*)CDR(x))
#define CBIGNUM(x)	((short*)CDR(x))

#define CLENGTH(x)	ABS (CAR(x) >> 12)

#define CFREENEXT(x)	(CDR(x))

#define CBOXSIZE(x)       	(((Cell*)CDR(x))[0].car)
#define CBOXPTR(x)		((Cell*)CDR(x))
#define CBOXNEXT(x)      	(((Cell*)CDR(x))[0].cdr)
#define CBOXNFREE(x)     	(((Cell*)CDR(x))[1].car)
#define CBOXFREECELL(x)		(((Cell*)CDR(x))[1].cdr)

#define CCDECL(x)		((Defun_Decl*)CDR(x))
#define CCFUNC(x)		(((Defun_Decl*)CDR(x))->func)
#define CDBGME(x)		((CAR(x)>>12)&1)

#define DEFUN(ln, cn, sn, min, max, ep, lp, doc, pr)       			\
 	EXTERN_C Obj cn pr;							\
 	Defun_Decl sn = { ln, (Obj (*)())cn, min, max, ep, lp, doc };		\
 	EXTERN_C Obj cn pr

#define DEFVAR(ln, cn, doc, val)				\
Obj cn = 0;

#define VALUE(v)	CSYM_BOX(v)->value

extern Obj stdin_port, stdout_port, stderr_port;
extern Obj sym_optional, sym_rest, sym_quote;
extern Obj *stackbase;
extern Obj internal_gc_protect;


typedef struct Backtrace {
	struct Backtrace *next;
	int dbg_me;
	Obj fncname;
	Obj fncdefn;
	Obj argl;
} Backtrace;

/* for protecting critical sections from signals */
extern int signals_blocked;
extern unsigned int got_signal_vec;
EXTERN_C void signal_dispatcher(void);
#define DISABLE(x)	x = signals_blocked ++
#define RENABLE(x)	if( !(signals_blocked = x) && got_signal_vec) signal_dispatcher()


#define QQUOTIFY(x)	#x
#define QUOTIFY(x)	QQUOTIFY(x)
#define ABS(x)		((x) < 0 ? -(x) : (x))

#define PROTECT_SYM(x)	(CAR(x) |= SDBIT)


#include <jl_proto.h>

#endif /* !_jlisp_h */
