/*
    critical.h  -- Mutual exclusion.
*/
/*
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/

#define BUSY 1
#define CRITICAL 5
#define ACTIVE 1
#define INACTIVE 0

extern bool timer_state;
extern int critical_level;
extern int critical_semaphore;
extern bool was_interrupted;


extern intha();

#define start_critical_section(){\
    if (timer_state)  {\
       critical_semaphore = BUSY ;\
       critical_level++ ;\
       }\
    }

#define end_critical_section() {\
    if (timer_state) {\
      if (--critical_level == 0) {\
        if ( was_interrupted)  {\
	  critical_semaphore = FREE ;\
          was_interrupted = FALSE ;\
          intha(CRITICAL,0,0) ;\
        }\
        else critical_semaphore = FREE ;\
	if ( was_interrupted ) {\
	  critical_semaphore = FREE ;\
          was_interrupted = FALSE ;\
          intha(CRITICAL,0,0) ;\
        }\
      }\
      }\
}
