/*
    bds.h -- Bind stack.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#define	BDSGETA		16

struct bds_bd {
	object	bds_sym;	/*  symbol  */
	object	bds_val;	/*  previous value of the symbol  */
};

#ifdef MTCL
#define bind_stack      clwp->lwp_bind_stack
#else
extern struct bds_bd bind_stack[BDSSIZE + BDSGETA + BDSGETA];
#endif
#define bds_org		bind_stack

typedef struct bds_bd *bds_ptr;

#ifdef MTCL
#define bds_limit       clwp->lwp_bds_limit
#define bds_top         clwp->lwp_bds_top
#else
extern bds_ptr bds_limit;
extern bds_ptr bds_top;	/*  bind stack top  */
#endif

#define	bds_check  \
	if (bds_top >= bds_limit)  \
		bds_overflow()

#define	bds_bind(sym, val)  \
	(++bds_top)->bds_sym = (sym);  \
	bds_top->bds_val = (sym)->s.s_dbind;  \
	(sym)->s.s_dbind = (val)

#define	bds_unwind1  \
	((bds_top->bds_sym)->s.s_dbind = bds_top->bds_val, --bds_top)
