(in-package 'lisp)

(export '(definline defCbody))

(defmacro definline (fun arg-types type code)
  `(eval-when (compile load eval)
	      ;; defCbody must go first, because it clears symbol-plist of fun
	      (defCbody ,fun ,arg-types ,type ,code)
	      (proclaim '(function ,fun ,arg-types ,type))
	      (setf (get ',fun 'compiler::inline-always)
		    '((,arg-types ,type
		       t		; side-effect-p
		       nil ,code)))))

