/*
    num_pred.c  -- Predicates on numbers.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/

#include "config.h"
#include "num_include.h"

number_zerop(x)
object	x;
{
	switch (type_of(x)) {

	case t_fixnum:
		if (fix(x) == 0)
			return(1);
		else
			return(0);

	case t_bignum:
	case t_ratio:
		return(0);

	case t_shortfloat:
		if (sf(x) == 0.0)
			return(1);
		else
			return(0);

	case t_longfloat:
		if (lf(x) == 0.0)
			return(1);
		else
			return(0);

	case t_complex:
		return(number_zerop(x->cmp.cmp_real) &&
		       number_zerop(x->cmp.cmp_imag));

	default:
		FEwrong_type_argument(Snumber, x);
	}
}

number_plusp(x)
object	x;
{
	switch (type_of(x)) {

	case t_fixnum:
		if (fix(x) > 0)
			return(1);
		else
			return(0);

	case t_bignum:
		if (big_sign((struct bignum *)x) > 0)
			return(1);
		else
			return(0);

	case t_ratio:
		if (number_plusp(x->rat.rat_num))
			return(1);
		else
			return(0);

	case t_shortfloat:
		if (sf(x) > 0.0)
			return(1);
		else
			return(0);

	case t_longfloat:
		if (lf(x) > 0.0)
			return(1);
		else
			return(0);

	default:
		FEwrong_type_argument(TSor_rational_float, x);
	}
}

number_minusp(x)
object	x;
{
	switch (type_of(x)) {

	case t_fixnum:
		if (fix(x) < 0)
			return(1);
		else
			return(0);

	case t_bignum:
		if (big_sign((struct bignum *)x) < 0)
			return(1);
		else
			return(0);

	case t_ratio:
		if (number_minusp(x->rat.rat_num))
			return(1);
		else
			return(0);

	case t_shortfloat:
		if (sf(x) < 0.0)
			return(1);
		else
			return(0);

	case t_longfloat:
		if (lf(x) < 0.0)
			return(1);
		else
			return(0);

	default:
		FEwrong_type_argument(TSor_rational_float, x);
	}
}

number_oddp(x)
object x;
{
	int	i;

	if (FIXNUMP(x))
		i = fix(x);
	else if (type_of(x) == t_bignum)
		i = x->big.big_car;
	else
		FEwrong_type_argument(Sinteger, x);
	return(i & 1);
}

number_evenp(x)
object x;
{
	int	i;

	if (FIXNUMP(x))
		i = fix(x);
	else if (type_of(x) == t_bignum)
		i = x->big.big_car;
	else
		FEwrong_type_argument(Sinteger, x);
	return(~i & 1);
}

Lzerop(int narg, object x)
{
	check_arg(1);
	check_type_number(&x);
	VALUES(0) = (number_zerop(x)) ? Ct : Cnil;
	RETURN(1);
}

Lplusp(int narg, object x)
{
	check_arg(1);
	check_type_or_rational_float(&x);
	VALUES(0) = (number_plusp(x)) ? Ct : Cnil;
	RETURN(1);
}

Lminusp(int narg, object x)
{
	check_arg(1);
	check_type_or_rational_float(&x);
	VALUES(0) = (number_minusp(x)) ? Ct : Cnil;
	RETURN(1);
}

Loddp(int narg, object x)
{
	check_arg(1);
	check_type_integer(&x);
	VALUES(0) = (number_oddp(x)) ? Ct : Cnil;
	RETURN(1);
}

Levenp(int narg, object x)
{
	check_arg(1);
	check_type_integer(&x);
	VALUES(0) = (number_evenp(x)) ? Ct : Cnil;
	RETURN(1);
}

init_num_pred()
{
	make_function("ZEROP", Lzerop);
	make_function("PLUSP", Lplusp);
	make_function("MINUSP", Lminusp);
	make_function("ODDP", Loddp);
	make_function("EVENP", Levenp);
}
